#!/bin/bash
#usage:
#download whole mymaemo-workdir 
#cd into the dir 
# ./flash-it-all.sh [basename_COMBINED [basename_VANILLA]]
#
# (c) docscrutinizer 2014, v2:2015. v3.1:2017  This file and the containing folder are strictly for private use only 
#       and must not get used by anybody except me!


#COMBINED=RX-51_2009SE_20.2010.36-2_PR_COMBINED_MR0_ARM.bin
COMBINED=${1:-RX-51_2009SE_21.2011.38-1_PR_COMBINED_MR0_ARM.bin}
VANILLA=${2:-RX-51_2009SE_10.2010.13-2.VANILLA_PR_EMMC_MR0_ARM.bin}

flasher=maemo_flasher-3.5_2.5.2.2/flasher-3.5
trasher=trasher-3.5_2.5.2.2.tar.gz


echo "Welcome to N900 flasher tool v3.1!"



processfile() {
local f=$1

  if ! grep "${f}" md5sums.txt; then
    echo "${f} is not known (has no checksum line in local file md5sums.txt for checking file integrity). Aborting." 
    exit 10
  fi


  if ! md5sum -c <(grep "${f}" md5sums.txt); then
    echo "no local file "${f}" or checksum incorrect. Trying to fetch..."
    if wget http://maemo.cloud-7.de/maemo5/fiasco+co/_"${f}" -O "${f}"; then
      echo "resuming..."
      return 1
    else
      error=$?
      echo -n "wget failed with errorcode $error. Please get file "${f}" and place it in this directory: "; pwd;
      echo "Aborting."
      exit $error
    fi
  fi
}


main() {
  cd $(dirname -- "$0")
  if [ $(id -u) != 0 ]; then
    echo "this script must be run as root. Aborting."
    exit 1
  fi;
  
  echo "this v3.1 (libusbcheck) version of $0 by default will flash the rootfs only and will NOT flash your homedir and MyDocs"
  read -p "if you want to flash your homedir and MyDocs too (aka eMMC flashing), answer 'YES':" 
  flashall=0
  if [ "$REPLY" == "YES" ]; then
    echo "flashing ALL"
    flashall=1
  fi
  
  if ! [ -x ${flasher} ]; then
    tar -xzf ${trasher}
  fi;
  echo "testing for libusb0.1.4 ..."
  if ! ${flasher} -u >/dev/null; then
    echo "libusb0.1.4_32bit not installed! Trying with LD_PRELOAD of downloaded version"
    flasher="LD_PRELOAD=./libusb-0.1.so.4.4.4 ${flasher}"
    if ! eval ${flasher} -u >/dev/null; then
      echo "this failed as well. Please install the 32bit version of full libusb-0.1.so.4 *and dependencies*, and rerun this script
        e.g. on debian you might need:
         dpkg --add-architecture i386
         apt-get update
         apt-get install libusb-0.1-4:i386"
      exit 127
    fi;
  fi;

  for file in ${COMBINED} ${VANILLA}; do
    echo -e "\n\nprocessing file ${file}..."
    while ! processfile "${file}"; do echo "${file} rerun"; done
  done

  echo -e 'image files found and checked OK for integrity.\n'
  
  
  echo -e "fixing flasher-3.5 cdc_phonet kernel module collision problem,\ndelete /etc/modprobe.d/00-blacklist-cdcphonet.conf after completing flashing if you need phonet based USB to N900"
  echo "blacklist cdc_phonet" >/etc/modprobe.d/00-blacklist-cdcphonet.conf
  modprobe -r cdc_phonet


  echo -e "\n\n##################################################################\nplease remove battery from N900, then plug N900 to a primary (non-hub) USB jack of this PC. Then insert battery which should result in this script continuing...\n##################################################################\n\n"
  sleep 3

  echo "resetting r&d-mode and flags"
  eval ${flasher} --clear-rd-flags=force-power-key 
  eval ${flasher} --disable-rd-mode
  
  echo "flashing rootfs..."
  if ! eval ${flasher} -f -F $COMBINED; then
    error=$?
    echo "sorry, flashing $COMBINED (NOLO, rootfs, modem-fw) failed with errorcode $error"
    exit $error
  fi
  if [ $flashall -eq 1 ]; then
    echo "flashing eMMC..."
    if ! eval ${flasher} -f -F $VANILLA; then
      error=$?
      echo "sorry, flashing $VANILLA (content of eMMC, incl /home/user/) failed with errorcode $error"
      exit $error
    fi
  fi
      
  echo "please remove battery, unplug USB, then reinsert battery and let device boot and init system which may take a while"
}

main;