/* -*- c++ -*- */
/*
 * Copyright 2004,2008,2012-2013 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

// WARNING: this file is machine generated. Edits will be overwritten

#ifndef INCLUDED_BLOCKS_VECTOR_SOURCE_C_H
#define INCLUDED_BLOCKS_VECTOR_SOURCE_C_H

#include <blocks/api.h>
#include <gr_sync_block.h>

namespace gr {
  namespace blocks {

    /*!
     * \brief source of gr_complex's that gets its data from a vector
     * \ingroup misc_blk
     */
    class BLOCKS_API vector_source_c : virtual public gr_sync_block
    {
    public:
      // gr::blocks::vector_source_c::sptr
      typedef boost::shared_ptr<vector_source_c> sptr;

      static sptr make(const std::vector<gr_complex> &data,
                       bool repeat=false, int vlen=1,
                       const std::vector<gr_tag_t> &tags=std::vector<gr_tag_t>());

      virtual void rewind() = 0;
      virtual void set_data(const std::vector<gr_complex> &data,
                            const std::vector<gr_tag_t> &tags=std::vector<gr_tag_t>()) = 0;
    };

  } /* namespace blocks */
} /* namespace gr */

#endif /* INCLUDED_BLOCKS_VECTOR_SOURCE_C_H */
