/*
 * Copyright (C) 2008, Nokia gate5 GmbH Berlin
 *
 * These coded instructions, statements, and computer programs contain
 * unpublished proprietary information of Nokia gate5 GmbH, and are
 * copy protected by law. They may not be disclosed to third parties
 * or copied or duplicated in any form, in whole or in part, without
 * the specific, prior written permission of Nokia gate5 GmbH.
 */

eval(nokia.aduno.utils.getImportCode());
eval(nokia.aduno.dom.getImportCode());
eval(nokia.aduno.medosui.getImportCode());

/**
 * Main settings maplet class
 */
var SettingsMaplet = new Class({
    Name: "SettingsMaplet",

    _screen: null,

    /**
    * Main maplet constructor
    * @ignore
    */
    initialize: function() {
        this._screen = new nokia.maps.application.ui.Screen(null,null,nokia.maps.application.Application.getInstance().screenManager);
        this._screen.setStyle("index");
        this._screen.addEventHandler("creating", this.creating, this);
    },

    /**
    * Proxy screen opening
    */
    open: function() {
        this._screen.open();
    },

    /**
     * Proxy screen closing
     */
    close: function() {
        this._screen.close();
    },

    /**
    * Create screen handler
    */
    creating: function() {
        var header = new nokia.aduno.medosui.Label("ScreenHeader",
                nokia.maps.application.Application.getInstance().getTranslation().settingsUCASE);
        this._screen.setChildAt(header, "header");

        var list = new nokia.aduno.medosui.SelectionList("SettingsList");
        list.addEventHandler("selected", function(aEvent) {
            // @todo: select the right item
            // @todo: needs refactoring
            list.clearSelection();
            maplet.fireEvent(new nokia.aduno.utils.Event("openSettings", aEvent.data.selection._data));
        });
        // pick up only the maplets which contain settings
        var maplets = nokia.maps.application.Application.getInstance().mapletManager.getMapletsWithSettings();
        maplets.sort(function (aMaplet, aOtherMaplet)  {
			if(aMaplet.getMetaData().uid=='com.nokia.maps.application'){
				return -1;
			}
			if(aOtherMaplet.getMetaData().uid=='com.nokia.maps.application'){
                return 1;
            }


            if (aOtherMaplet.getName() < aMaplet.getName()) {
                return 1;
            }

            return -1;
        });
        for (var i = 0; i < maplets.length; i++ ) {
            // "var" in each loop is required
            var maplet = maplets[i];
            var item = new nokia.aduno.medosui.ListItem("SettingsListMapletItem");
            item.setModel({
                label: maplet.getName()
//                icon: maplet._metaData.mapletURL + "/images/maplet_icon_44.png"
            });
            // remark the maplet
            item._data = maplet;
            list.addChild(item);
        }

        this._screen.setChildAt(list, "content");
    }
});

var settingsMaplet = new SettingsMaplet();

nokiaMaplet.onBeforeShow = nokia.aduno.utils.bind(settingsMaplet, settingsMaplet.open);
nokiaMaplet.onAfterHide = nokia.aduno.utils.bind(settingsMaplet, settingsMaplet.close);

nokiaMaplet.setCustomButton0(nokiaMaplet.CUSTOM_BUTTON_NONE);

