eval(nokia.maps.application.getImportCode());
eval(nokia.maps.application.model.getImportCode());
eval(nokia.maps.maplet.getImportCode());
eval(nokia.maps.common.getImportCode());
eval(nokia.aduno.medosui.getImportCode());
eval(nokia.aduno.dom.getImportCode());
eval(nokia.aduno.utils.getImportCode());
eval(nokia.maps.pfw.ui.getImportCode());
eval(nokia.maps.pfw.spices.getImportCode());
eval(nokia.maps.pfw.getImportCode());


var TouchRoutingMapletUi = new Class({
    Name: "TouchRoutingMapletUi",

    _currentRouteToWaypoint: null,
    _persistedRouteCalculation: false,
    _routing: null,
    _position: null,
    _maplet: null,
    _spiceManager: null,
    _infoBarSpice: null,
    _positionSelectorHandler: null,
    _map: null,
    _application: null,
    _callingMaplet: null,
    _positionSelectionActive: false,
    _positionSelectionByMapClick: false,
    _appInstance: null,
    // holds the value of last added waypoint
    _lastWaypointIndex: -1,
    LOADING_ICON_PATH: "pfw/images/ui/touch/loader_30px_light.gif",
    ROUTE_PLANNER_ICON_PATH: "maplets/com.nokia.maps.routing.pop/images/maplet_icon_24.png",

    initialize: function(aPlayer, aParent, aMaplet, aInfoBarSpice, aTranslator) {
        this._application = aPlayer.application;
        this._routing = aPlayer.routing;
        this._position = aPlayer.position;
        this._map = aPlayer.map;
        this._routeSettings = aPlayer.routeSettings;
        this._player = aPlayer;
        this._translator = aTranslator;
        this._spiceManager = nokia.maps.mapPlayer._spiceManager;
        this._appInstance = nokia.maps.application.Application.getInstance();    //TODO: Solve the "nokia is not defined" problem

        this._createSelector(this._application, aPlayer.map, aParent);

        this._application.addEventHandler(ApplicationModel.EVENT_SELECT_POSITION,
            this._onPositionSelector, this);
        this._application.addEventHandler(ApplicationModel.EVENT_APPLICATION_START,
            this._onApplicationStart, this);
        this._application.addEventHandler(TouchApplicationModel.EVENT_SHOW_SELECTOR,
            this._onShowSelector, this);
        this._application.addEventHandler(TouchApplicationModel.EVENT_HIDE_SELECTOR,
            this._onHideSelector, this);
        this._application.addEventHandler(ApplicationModel.EVENT_SWITCH_SELECTOR_DIALOG,
            this._onSwitchSelectorDialog, this);
        this._application.addEventHandler(TouchApplicationModel.EVENT_WAYPOINTS_VIEW_CHANGED,
            this._onWaypointsViewChanged, this);
        this._routing.addEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_DONE,
            this._onRouteCalculationDone, this);
        this._routing.addEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_ERROR,
            this._onRouteCalculationError, this);
        this._routing.addEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_CANCELLED,
            this._onRouteCalculationCancelled, this);
        this._routing.addEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_STARTED,
            this._onRouteCalculationStarted, this);
        this._routing.addEventHandler(RoutingModel.EVENT_CURRENT_ROUTE_CHANGED,
            this._onCurrentRouteChanged, this);
        this._routeSettings.addEventHandler(RouteSettingsModel.EVENT_BLOCKERS,
            this._onRouteSettingsChanged, this);
        this._routeSettings.addEventHandler(RouteSettingsModel.EVENT_ROUTE_TYPE,
            this._onRouteSettingsChanged, this);
        this._routeSettings.addEventHandler(RouteSettingsModel.EVENT_TRANSPORTATION_MODE,
            this._onRouteSettingsChanged, this);
        this._map.addEventHandler(MapModel.EVENT_MAP_CLICKED,
            this._onMapClicked, this);

        this._player.hideGUI("TouchRouteInfoSpice");
        this._player.hideGUI("CenterCursorSpice");
        this._player.hideGUI("MaemoInfoBarSpice");
        this._player.showGUI("ZoomSpice");
        this._player.showGUI("OrientationTiltSpice");
        this._switchMaemoPositionSpiceOffset(false);

        this._maplet = aMaplet;
        this._maplet.onClickedCustomButton0 = nokia.aduno.utils.bind(this, this.switchSelector);

        this._infoBarSpice = aInfoBarSpice;
        this._infoBarSpice.addEventHandler(MaemoInfoBarSpice.MENUICON_CLICKED,this._onInfoBarIconClicked,this);

        this._positionSpice = this._spiceManager.getSpice("PositionSpice");
        this._positionSelectorHandler = {};
    },

    _unregister: function () {
        this._application.removeEventHandler(ApplicationModel.EVENT_SELECT_POSITION,
            this._onPositionSelector, this);
        this._application.removeEventHandler(ApplicationModel.EVENT_APPLICATION_START,
            this._onApplicationStart, this);
        this._application.removeEventHandler(TouchApplicationModel.EVENT_SHOW_SELECTOR,
            this._onShowSelector, this);
        this._application.removeEventHandler(TouchApplicationModel.EVENT_HIDE_SELECTOR,
            this._onHideSelector, this);
        this._routing.removeEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_DONE,
            this._onRouteCalculationDone, this);
        this._routing.removeEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_ERROR,
            this._onRouteCalculationError, this);
        this._routing.removeEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_CANCELLED,
            this._onRouteCalculationCancelled, this);
        this._routing.removeEventHandler(RoutingModel.EVENT_ROUTE_CALCULATION_STARTED,
            this._onRouteCalculationStarted, this);
        this._routing.removeEventHandler(RoutingModel.EVENT_CURRENT_ROUTE_CHANGED,
            this._onCurrentRouteChanged, this);
        this._routeSettings.removeEventHandler(RouteSettingsModel.EVENT_BLOCKERS,
            this._onRouteSettingsChanged, this);
        this._routeSettings.removeEventHandler(RouteSettingsModel.EVENT_ROUTE_TYPE,
            this._onRouteSettingsChanged, this);
        this._routeSettings.removeEventHandler(RouteSettingsModel.EVENT_TRANSPORTATION_MODE,
            this._onRouteSettingsChanged, this);
        this._infoBarSpice.removeEventHandler(MaemoInfoBarSpice.MENUICON_CLICKED,
            this._onInfoBarIconClicked,this);
        this._map.removeEventHandler(MapModel.EVENT_MAP_CLICKED,
            this._onMapClicked, this);
    },

    /**
     *
     * @param {Object} aApplicationModel
     * @param {Object} aMapModel
     * @param {Object} aParent
     */
    _createSelector: function(aApplicationModel, aMapModel, aParent) {
        this._selector = new Selector(this._application, aMapModel);
        this._selector.addEventHandler(Selector.EVENT_SELECTOR_SHOW_STARTED, this._onSelectorShowStarted, this);
        this._selector.addEventHandler(Selector.EVENT_SELECTOR_HIDE_STARTED, this._onSelectorHideStarted, this);
        this._selector.addEventHandler(Selector.EVENT_SELECTOR_HIDE_FINISHED, this._onSelectorHideFinished, this);
        aParent.setChildAt(this._selector, "selector",false,false);

        var dialogs = this._application.getAllModalDialogs();
        this._selector.clearItems();
        Collection.forEach(dialogs, function(aValue, aKey) {
            if (aValue.showInSelector) {
                this._selector.addItem(aValue.id, aValue.image, aValue.label, aValue.dialog);
            }
        }, this);
    },

    /**
     * @private
     *
     * Creates a route object and shows selector.

     * @callback
     */
    _onApplicationStart: function() {
        this._attachSelectorToButton0();
        this._player.showGUI("CenterCursorSpice");
        var currentRoute = this._routing.getCurrentRoute();
        if (!currentRoute) {
            this._createRoute();
        }

        if (!currentRoute || !currentRoute.isValid()) {
            this._onShowSelector();
        }
    },


    /**
     * @private
     *
     * @callback
     */
    _onShowSelector: function() {
        this._selector.show(this._selector.getDefaultSelectorItem());
    },

    /**
     * @private
     * Switch event to hide selector.
     *
     * @callback
     */
    _onHideSelector: function() {
        this.switchSelector(false);
    },

    /**
     * @private
     * Callback, is fired when the icon in info bar is clicked.
     * @callback
     * @param {Object} aEvent
     */
    _onInfoBarIconClicked: function (aEvent){
        this._player.hideGUI("MaemoInfoBarSpice");
        this._infoBarSpice.setAddWaypointMode(false);
        this._positionSelectionActive = false;

        this._setDefaultTitleText();
        nokia.maps.application.Application.getInstance().header.enterMaplet(false, true, false);
        nokia.maps.application.Application.getInstance()._setHeaderButtonCount();

        var selectedPosition = aEvent.getData().position;
        var title = aEvent.getData().title;
        var description = aEvent.getData().description;

        var handler = this._positionSelectorHandler.handler;
        var context = this._positionSelectorHandler.handlerContext;
        var data = this._positionSelectorHandler.data;

        this._positionSelectorHandler.handler = null;
        this._positionSelectorHandler.cancelHandler = null;
        this._positionSelectorHandler.handlerContext = null;
        this._positionSelectorHandler.data = null;

        if (handler) {
            var eventData = {
                position: selectedPosition,
                title: title,
                description: description,
                data: data
            };
            // timeout due to slow rendering performance
            setTimeout(function() {
                try {
                    handler.apply(context,
                        [new nokia.aduno.utils.Event("positionSelected", eventData)]);
                } catch (ex) {
                    // just don't break the control flow
                }}, 1
            );
        }
    },

    _onEnableTrackingButton: function () {
        var positionSpice = nokia.maps.mapPlayer._spiceManager.getSpice("PositionSpice");
        if (positionSpice) {
            positionSpice.setTrackingEnabled(true);
        }
    },

    /**
     * @private
     * Fired, when s position in the map is to be selected.
     * @callback
     * @param {Object} aEvent The event data.
    */
    _onPositionSelector: function(aEvent) {
        this._positionSelectionActive = true;
        if (aEvent.data.data.selectionByMapClick) {
            // nokia.maps.application.Application.getInstance().header.enterDetailScreen(false, true, false);
            // nokia.maps.application.Application.getInstance().header.setHeaderTitle(aEvent.data.title);
        }
        else {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_BACK);
            this._maplet.onClickedCustomButton0 = nokia.aduno.utils.bind(this, this._onCancelSelectPosition);
            this._selector.closeCurrentItem(null, true);
            nokia.maps.application.Application.getInstance().header.enterDetailScreen(false, true, false);
            nokia.maps.application.Application.getInstance().header.setHeaderTitle(aEvent.data.title);
            this._positionSelectionByMapClick = false;
        }

        this._positionSelectorHandler.handler = aEvent.data.selectHandler;
        this._positionSelectorHandler.cancelHandler = aEvent.data.cancelHandler;
        this._positionSelectorHandler.handlerContext = aEvent.data.handlerContext;
        this._positionSelectorHandler.data = aEvent.data.data;
        this._positionSelectorHandler.title = aEvent.data.title;


        if (this._player.isGuiVisible("TouchRouteInfoSpice")) {
            this._infoBarSpice.setAddWaypointMode(true,true);
            this._switchMaemoPositionSpiceOffset(true);
        } else {
            this._infoBarSpice.setAddWaypointMode(true,false);
        }

        this._player.showGUI("MaemoInfoBarSpice");
        this._player.showGUI("CenterCursorSpice");

        if (aEvent.data.initialPosition) {
            this._map.setMapCenterPosition(aEvent.data.initialPosition);
        }
    },

    _onMapClicked: function() {
        if (!this._positionSelectionActive) {
            this._positionSelectionByMapClick = true;
            var bindObj = this;
            this._application.selectPosition(this._maplet.getName(), this._onPositionFromMapSelected, function() {
                bindObj._attachSelectorToButton0();
            }, this, {selectionByMapClick: true});
        }
    },

    _onPositionFromMapSelected: function(aEvent) {
        var route = this._routing.getCurrentRoute();
        var selectedPosition = aEvent.getData().position;
        var waypoint = new Waypoint(selectedPosition, null);
        waypoint.setPlace(aEvent.getData().title);
        waypoint.setDescription(aEvent.getData().description);


        var aIndex = route.getWaypointCount();

        if (! route.getStartPosition()){
            route.replaceWaypointAt(0, waypoint);
        } else{
            if (route.isValid()){
                route.addWaypoint(waypoint);
            } else{
                route.insertWaypointAt(1, waypoint);
            }
        }

        if (route.isValid()) {
            this._routing.calculateRoute(route);
        }

    },

    /**
     * Hide or show the selector.
     *
     * @param {Object} aVisible
     */
    switchSelector: function(aVisible) {
        var visible = (aVisible !== undefined) ? !!aVisible : !this._selector.isVisible();
        if (visible) {
            this._selector.show();
        } else {
            this._selector.hide();
        }
    },

    /**
     * Bind an event to maplet infobarbutton.
     *
     */
    _attachSelectorToButton0: function() {
        this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_OPEN_SELECTOR);
        this._maplet.onClickedCustomButton0 = nokia.aduno.utils.bind(this, this.switchSelector);
    },

    /**
     * Set title of application.
     */
    _setDefaultTitleText: function() {
        this._appInstance.header.setHeaderTitle(this._maplet.getName());
    },

    /**
     * Set mapplet and according application buttons with shown selector.
     *
     */
    _onSelectorShowStarted: function() {
        //this._maplet.switchToMaplet(true);
        if (this._routing.isRouteCalculationInProgress()) {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE);
        } else {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE_SELECTOR);
        }
    },

    /**
     * Set mapplet and according application buttons with hidden selector.
     *
     */
    _onSelectorHideStarted: function() {
        if (this._positionSelectionActive && !this._positionSelectionByMapClick) {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_BACK);
        } else if (this._routing.isRouteCalculationInProgress()) {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE);
        } else {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_OPEN_SELECTOR);
        }
    },

    /**
     * Hide selector.
     *
     */
    _onSelectorHideFinished: function() {
        if (this._positionSelectionActive && !this._positionSelectionByMapClick) {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_BACK);
        } else if (this._routing.isRouteCalculationInProgress()) {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE);
        } else {
            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_OPEN_SELECTOR);
        }
    },

    _isGpsAvailable: function () {
        var available = false;
        if (this._position.isLivePositioningData() &&
            this._position.getPositioningAccuracy() > 0 &&
            this._position.getPositioningAccuracy() < PositionModel.MAX_VALID_ACCURACY) {
                available = true;
        }
        return available;
    },

    /**
     * Calculate a route with the given route parameters.
     *
     * @param {Object} aParameters
     */
    routeTo: function(aParameters) {
        this._currentRouteToWaypoint = new nokia.maps.pfw.Waypoint({
            latitude: aParameters.route.to.latitude,
            longitude: aParameters.route.to.longitude
        });
        if (aParameters.route.to.title) {
            this._currentRouteToWaypoint.setPlace(aParameters.route.to.title);
        }
        if (aParameters.route.to.address && aParameters.route.to.address !== "") {
            this._currentRouteToWaypoint.setDescription(aParameters.route.to.address);
        }

        this._callingMaplet = aParameters.callingMaplet;

        //Get the startpoint from GPS
        if (this._isGpsAvailable()) {
            this._startRouteToPlanning();
        } else {
            this._appInstance.header.setHeaderTitle(
                this._translator.translate("__I18N_nokia.maps.pfw.ui.waypointlistitem.lookuptext__"));

            this._position.addEventHandler(PositionModel.EVENT_POSITION, this._onPositionChanged, this);

            this._player.hideGUI("TouchRouteInfoSpice");
            this._player.hideGUI("CenterCursorSpice");
            this._player.hideGUI("MaemoInfoBarSpice");
            this._player.showGUI("ZoomSpice");
            this._player.showGUI("OrientationTiltSpice");
            this._switchMaemoPositionSpiceOffset(false);

            this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE);
            this._maplet.onClickedCustomButton0 = nokia.aduno.utils.bind(this, this.cancelRouteTo);
            //nokia.maps.application.Application.getInstance().header.enterDetailScreen(false, true, false);

            //****************************************************************************************
            // FOR DEMO PURPOSES FAKE GPS POSITION AFTER NOT FINDING SIGNAL ANYTHING FOR 1 SECOND
            // TODO: Very important!!! Remove after demo!!!
            //var bindObj = this;
            //setTimeout(function() {
            //    bindObj._routeToDemoNoGpsSignalTimeout();
            //}, 1000);
            //****************************************************************************************
        }
    },

    _routeToDemoNoGpsSignalTimeout: function() {
        var currentRoute = this._routing.getCurrentRoute();

        if (!currentRoute
            || !currentRoute.isValid()
            || currentRoute.getDuration() === 0) {   //No GPS signal found, fake run
            this._fakeGpsSignalFound();
        }
    },

    /**
     * Cancel route calculation
     *
     */
    cancelRouteTo: function() {
        this._currentRouteToWaypoint = null;
        this._position.removeEventHandler(PositionModel.EVENT_POSITION, this._onPositionChanged, this);
        if (this._callingMaplet) {
            this._maplet.switchMaplet(this._callingMaplet, null);
        }
    },

    /**
     * Restore waypoint list from aduno persistence.
     *
     * @param {Object} aWaypointsListString
     * @returns boolean route loaded
     */
    loadStoredRoute: function(aWaypointsList) {
        var routeLoaded = false;

        try {
            if (aWaypointsList.length > 1) {
                var route = new nokia.maps.pfw.Route();
                this._routing.setCurrentRoute(route);

                var waypoint;
                var iLocation;
                var location;
                var waypointInfo;

                for (var i = 0; i < aWaypointsList.length; i++) {
                    waypointInfo = aWaypointsList[i];

                    if (waypointInfo.ADDR_CITY_NAME && waypointInfo.ADDR_CITY_NAME !== "") {
                        iLocation = nokia.maps.mapPlayer._pluginControl.createLocation();
                        location = new Location(iLocation);

                        location.setField("ADDR_CITY_NAME", waypointInfo.ADDR_CITY_NAME);
                        location.setField("ADDR_STREET_NAME", waypointInfo.ADDR_STREET_NAME);
                        location.setField("ADDR_HOUSE_NUMBER", waypointInfo.ADDR_HOUSE_NUMBER);
                        location.setField("ADDR_DISTRICT_NAME", waypointInfo.ADDR_DISTRICT_NAME);
                        location.setField("ADDR_POSTAL_CODE", waypointInfo.ADDR_POSTAL_CODE);
                        location.setField("PLACE_NAME", waypointInfo.PLACE_NAME);

                        waypoint = new nokia.maps.pfw.Waypoint({
                            latitude: waypointInfo.latitude,
                            longitude: waypointInfo.longitude
                        }, location);

                    } else {
                        waypoint = new nokia.maps.pfw.Waypoint({
                            latitude: waypointInfo.latitude,
                            longitude: waypointInfo.longitude
                        });

                        waypoint.setDescription(waypointInfo.DESCRIPTION);
                        waypoint.setPlace(waypointInfo.PLACE);
                    }

                    route.addWaypoint(waypoint);
                }

                this._routeSettings.applySettings(route);
                this._persistedRouteCalculation = true;
                this._routing.calculateRoute(route);
            }

        } catch(error) {
            warn("Routing maplet: Could not load stored route: " + error);
            routeLoaded = false;
        }

        return routeLoaded;
    },

    /**
     * @private
     * Event which is bound to application info bar button.
     * Triggers event to cancel state of position selection.
     *  @callback
     */
    _onCancelSelectPosition: function() {
        this._selector.reopenLastItem();
        //FIXME: Restore custom button
        this._infoBarSpice.setAddWaypointMode(false);
        this._player.hideGUI("MaemoInfoBarSpice");
        this._positionSelectionActive = false;

        nokia.maps.application.Application.getInstance().header.enterMaplet(false, true, false);
        nokia.maps.application.Application.getInstance()._setHeaderButtonCount();

        this._setDefaultTitleText();

        if (this._positionSelectorHandler.cancelHandler) {
            try {
                this._positionSelectorHandler.cancelHandler.apply(
                    this._positionSelectorHandler.handlerContext,
                    [new nokia.aduno.utils.Event("positionSelectionCancelled", this._positionSelectorHandler.data)]);
            } catch (ex) {
                //don't let bad handlers break the control flow
            }
        }

        this._positionSelectorHandler.handler = null;
        this._positionSelectorHandler.cancelHandler = null;
        this._positionSelectorHandler.handlerContext = null;
        this._positionSelectorHandler.data = null;

        this._attachSelectorToButton0();
    },

    /**
     * @private
     *
     * Evaluate event if position has been changed.
     *
     * @callback
     */
    _onPositionChanged: function() {
        this._position.removeEventHandler(PositionModel.EVENT_POSITION, this._onPositionChanged, this);

        if (this._currentRouteToWaypoint) {
            this._startRouteToPlanning();
        }
    },

    /**
     * @private
     *
     * Evaluate event if route has been changed.
     *
     * @callback
     * @param {Object} aEvent
     */
    _onCurrentRouteChanged: function(aEvent) {
        var newRoute = aEvent.getData().newRoute;
        var oldRoute = aEvent.getData().oldRoute;

        if (aEvent.data.newRoute === null) {
            this._createRoute();
            this._player.showGUI("ZoomSpice");
            this._player.showGUI("OrientationTiltSpice");
            this._player.hideGUI("MaemoInfoBarSpice");
            this._player.hideGUI("TouchRouteInfoSpice");
            this._switchMaemoPositionSpiceOffset(false);
        }

        if (oldRoute) {
            oldRoute.removeEventHandler(Route.EVENT_ROUTE_WAYPOINTS_CHANGED, this._onWaypointsChanged, this);
        }
        if (newRoute) {
            newRoute.addEventHandler(Route.EVENT_ROUTE_WAYPOINTS_CHANGED, this._onWaypointsChanged, this);
        }

        nokia.maps.application.Application.getInstance().mapLoadingDialog.setEnabled(true);
    },

    /**
     * @private
     * Callback, is fired by the current route when a waypoint was added or removed.
     * @callback
     * @param {nokia.aduno.utils.Event} aEvent
     */
    _onWaypointsChanged: function(aEvent) {
        this._lastWaypointIndex = aEvent.data.index;
    },


    /**
     * @private
     *
     * Create route.
     *
     */
    _createRoute: function() {
        var route = new nokia.maps.pfw.Route();

        var gpsWaypoint = new nokia.maps.pfw.Waypoint();
        var gpsPosition = null;
        if (this._isGpsAvailable()) {
            gpsPosition = this._position.getPosition();
            gpsWaypoint.setGpsPosition(gpsPosition);
        } else {
            gpsWaypoint.setGpsPosition(null);
        }
        route.setStartWaypoint(gpsWaypoint);
        this._routeSettings.applySettings(route);
        this._routing.setCurrentRoute(route);
    },

    /**
     * @private
     *
     *
     * @param {Object} aIsFake
     */
    _startRouteToPlanning: function(aIsFake) {
        this._routing.setCurrentRoute(null);
        var route = new Route();
        var gpsWaypoint;
        var gpsPosition;

        //-------------------------------------------------------------------------------------
        // Get waypoint from GPS, in order to fake-test it, run _fakeGpsSignalFound
        gpsPosition = aIsFake ? { latitude: 52.5305079203099, longitude: 13.384416522458196 } :
                                this._position.getPosition();

        gpsWaypoint = new nokia.maps.pfw.Waypoint(gpsPosition);
        gpsWaypoint.setGpsPosition(gpsPosition);

        route.addWaypoint(gpsWaypoint);

        // Set the new route AFTER the GPS waypoint was added, since the selector would
        // show up if you do it before (invalid route with one waypoint)
        this._routing.setCurrentRoute(route);
        route.addWaypoint(this._currentRouteToWaypoint);

        this._routing.setCurrentRoute(route);
        this._routeSettings.applySettings(route);
        this._routing.calculateRoute(route);
    },

    /**
     * Test method to simulate available gps position.
     *
     */
    _fakeGpsSignalFound: function() {
        this._startRouteToPlanning(true);
    },

    /**
     * @private
     * Route calculation done
     *
     */
    _onRouteCalculationDone: function() {
        this._setDefaultTitleText();
        nokia.maps.application.Application.getInstance().header.enterMaplet(false, true, false);
        nokia.maps.application.Application.getInstance()._setHeaderButtonCount();

        this._player.showGUI("TouchRouteInfoSpice");
        this._player.hideGUI("CenterCursorSpice");
        this._player.showGUI("ZoomSpice");
        this._player.showGUI("OrientationTiltSpice");
        this._player.hideGUI("MaemoInfoBarSpice");
        this._switchMaemoPositionSpiceOffset(true);

        this._attachSelectorToButton0();

        if (this._currentRouteToWaypoint) {        // Route Calculated after "Route to" case
            this._currentRouteToWaypoint = null;
            this.switchSelector(false);
        } else if (this._persistedRouteCalculation) {
            this._persistedRouteCalculation = false;
            this.switchSelector(false);
        }

        //hide the loader
        if (this._routeCalculationLoader) {
            nokia.maps.application.MessageBoxes.closeMessageBox(this._routeCalculationLoader);
            this._routeCalculationLoader = null;
        }

        nokia.maps.application.Application.getInstance().mapLoadingDialog.setEnabled(false);
    },

    _onRouteCalculationCancelled: function() {
        this._onRouteCalculationStopped();
    },

    /**
     * @private
     * Route calculation stopped.
     *
     */
    _onRouteCalculationStopped: function() {
        nokia.maps.application.Application.getInstance().header.enterMaplet(false, true, false);
        nokia.maps.application.Application.getInstance()._setHeaderButtonCount();

        this._setDefaultTitleText();

        this._player.showGUI("ZoomSpice");
        this._player.showGUI("OrientationTiltSpice");
        this._player.hideGUI("TouchRouteInfoSpice");
        this._player.hideGUI("CenterCursorSpice");
        this._player.hideGUI("MaemoInfoBarSpice");
        this._switchMaemoPositionSpiceOffset(false);

        this._currentRouteToWaypoint = null;
        this._persistedRouteCalculation = false;

        this._attachSelectorToButton0();

        //hide the loader
        if (this._routeCalculationLoader) {
            nokia.maps.application.MessageBoxes.closeMessageBox(this._routeCalculationLoader);
            this._routeCalculationLoader = null;
        }

        nokia.maps.application.Application.getInstance().mapLoadingDialog.setEnabled(true);
    },

    _deleteLastAddedWaypoint: function() {
        if (!this._lastWaypointIndex != -1) {
            var route = this._routing.getCurrentRoute();
            route.removeWaypointAt(this._lastWaypointIndex);
        }
    },

    _onRouteCalculationError: function(aEvent) {
        this._onRouteCalculationStopped();

        // FIXME: Use global constants for yes/no.
        var yes = this._translator.translate("__I18N_nokia.maps.routingmaplet.yes__");
        var no = this._translator.translate("__I18N_nokia.maps.routingmaplet.no__");
        var editRouteSettings = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.editroutesettings__");

        var options = [];
        var text = "";
        var handlerFunc = this._onRouteCalculationStopped;
        // NOTHE
        switch (aEvent.data.errorCause) {
            case RoutingModel.ERROR_CAUSE_ROUTE_USES_DISABLED_ROADS:
                options = [yes, no];
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound.disabledroadtypes__");
                handlerFunc = this._onHandleRoutingErrorReaction;
                break;
            case RoutingModel.ERROR_CAUSE_CANNOT_DO_PEDESTRIAN:
                options = [yes, no];
                if (this._map.getMeasurementType()) {
                    text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.cannotdopedestrian.miles__");
                } else {
                    text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.cannotdopedestrian__");
                }
                handlerFunc = this._onHandleRoutingErrorReaction;
                break;
            case RoutingModel.ERROR_CAUSE_GRAPH_DISCONNECTED:
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound__");
                break;
            case RoutingModel.ERROR_CAUSE_GRAPH_DISCONNECTED_CHECK_OPTIONS:
                options = [yes, no];
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound.disabledoptions__");
                handlerFunc = this._onHandleRoutingErrorReaction;
                break;
            case RoutingModel.ERROR_CAUSE_NO_START_POINT:
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound.nostartpoint__");
                handlerFunc = this._onHandleRoutingErrorReaction;
                break;
            case RoutingModel.ERROR_CAUSE_NO_END_POINT:
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound.noendpoint__");
                handlerFunc = this._onHandleRoutingErrorReaction;
                break;
            case RoutingModel.ERROR_CAUSE_NO_END_POINT_CHECK_OPTIONS:
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound.noendpointcheckoptions__");
                break;
            default:
                text = this._translator.translate("__I18N_nokia.maps.routingmaplet.routingerror.noroutefound__");
                break;
        }

        this._application.changeWaypointsDialogView("waypoints");
        this._player.showGUI("CenterCursorSpice");

        this._application.showMessageBox(
           "Routing Error",
           text,
           handlerFunc,
           this,
           options,
           aEvent.data);
    },

    /**
     * @private
     *
     * @callback
     * @param {Object} aEvent
     */
    _onHandleRoutingErrorReaction: function(aEvent) {
        var errorData = aEvent.data.data;
        var route = this._routing.getCurrentRoute();

        switch (errorData.errorCause) {
            case RoutingModel.ERROR_CAUSE_ROUTE_USES_DISABLED_ROADS:
                if (aEvent.data.selectedIndex === 0) {
                    this._routeSettings.setAllowedRoadTypes(true,true,true,true,true,true);
                }
                break;
            case RoutingModel.ERROR_CAUSE_GRAPH_DISCONNECTED_CHECK_OPTIONS:
                if (aEvent.data.selectedIndex === 0) {
                    this._routeSettings.setAllowedRoadTypes(true,true,true,true,true,true);
                }
                break;
            case RoutingModel.ERROR_CAUSE_CANNOT_DO_PEDESTRIAN:
                if (aEvent.data.selectedIndex === 0) {
                    this._routeSettings.setTransportationMode(Route.TRANSPORTATION_MODE_CAR);
                }
                break;
            case RoutingModel.ERROR_CAUSE_NO_START_POINT:
                // FIXME: GL -> to much magic?
                route.removeWaypointAt(0);
                if (route.isValid()){
                    this._routing.calculateRoute(route);
                }
                break;
            case RoutingModel.ERROR_CAUSE_NO_END_POINT:
                // FIXME: GL -> to much magic?
                route.removeWaypointAt(route.getWaypointCount()-1);
                if (route.isValid()){
                    this._routing.calculateRoute(route);
                }
                break;
        }
    },

    /**
     * @private
     *
     * Trigger event during route calculation.
     *
     * @param {Object} aEvent
     * @callback
     */
    _onRouteCalculationStarted: function(aEvent) {
        this._player.hideGUI("TouchRouteInfoSpice");
        nokia.maps.application.Application.getInstance().header.enterDetailScreen(false, true, false);
        var routeCalculationCaption = this._translator.translate("__I18N_nokia.maps.pfw.spices.routeinfospice.calcprogress__");

        if (!this._routeCalculationLoader) {
            this._routeCalculationLoader =
                nokia.maps.application.MessageBoxes.showLoadingMessage(routeCalculationCaption, false);
            this._routeCalculationLoader.getReplica().addCssClass("mb_lower_Z_Index");
        }

        this._appInstance.header.setHeaderTitle(routeCalculationCaption);

        this._player.showGUI("ZoomSpice");
        this._player.showGUI("OrientationTiltSpice");
        this._player.hideGUI("CenterCursorSpice");
        this._player.hideGUI("MaemoInfoBarSpice");
        this._switchMaemoPositionSpiceOffset(true);

        this._maplet.setCustomButton0(this._maplet.CUSTOM_BUTTON_CLOSE);
        this._maplet.onClickedCustomButton0 = nokia.aduno.utils.bind(this, this._onCancelRouteCalculation);
    },

    /**
     * @private
     * Cancel calculation of route.
     * @callback
     * @param {Object} aEvent
     */
    _onCancelRouteCalculation: function (aEvent){
        this._deleteLastAddedWaypoint();
        var route = this._routing.cancelRouteCalculation();
    },

    /**
     * @private
     * Recalculate route if route settings have been changed.
     * @callback
     * @param {Event} aKeyEvent
     */
    _onRouteSettingsChanged: function(aEvent) {
        if (this._routing.getCurrentRoute() && !this._routeSettings.hasEqualSettings(this._routing.getCurrentRoute())) {
            this._routeSettings.applySettings(this._routing.getCurrentRoute());
            nokia.aduno.utils.info("TRMUI: on route settings changed, mode is " +
                this._routing.getCurrentRoute().getTransportationMode());
            if (this._routing.getCurrentRoute().isValid()) {
                this._routing.calculateRoute(this._routing.getCurrentRoute());
            }
        }
    },

    /**
     *
     * @param {Object} aEvent
     */
    _onWaypointsViewChanged: function (aEvent) {
        var waypointsSpice = this._spiceManager.getSpice("TouchWaypointSpice");
        waypointsSpice.switchView(aEvent.data.newView);
    },

    hideSelector: function() {
        this._selector.hideWithoutAnimation();
    },

    /**
     *
     * @param {Object} aEvent
     */
    _onSwitchSelectorDialog: function (aEvent){
        var id = aEvent.getData().id;
        if (!this._application.getOpenModalDialog()){
            this._selector.showDialog(id);
        } else if (id !== this._application.getOpenModalDialog()){
            this._selector.switchDialog(id);
        }
    },

    //TODO: Revise the real value of this function
    restoreUiState: function(lastState) {
        //Check route status
        var currentRoute = this._routing.getCurrentRoute();
        if (!currentRoute || !currentRoute.isValid()) {
            this._createRoute();
        }

        //Restore state
        var stateName = lastState ? lastState.name : null;
        var data = lastState ? lastState.data : null;
        switch (stateName) {
            case TouchApplicationModel.STATE_POSITION_SELECTION:
                if (data !== null && data.title !== null) {
                    nokia.maps.application.Application.getInstance().header.setHeaderTitle(data.title);
                }
                break;
            case TouchApplicationModel.STATE_SELECTOR:
            case TouchApplicationModel.STATE_MAP_VIEW:
                this._attachSelectorToButton0();
                this.switchSelector(false);
                break;
            default:
                this._selector.showDialog("waypoints");
                break;
        }
    },

    getUiState: function() {
        var openDialogId = this._application.getOpenModalDialog();
        var stateName = null;
        var data = {};

        if (this._positionSelectionActive) {
            stateName = TouchApplicationModel.STATE_POSITION_SELECTION;
            data.title = this._positionSelectorHandler.title;
        } else if (this._selector.isVisible()) {
            stateName = TouchApplicationModel.STATE_SELECTOR;
        } else {
            stateName = TouchApplicationModel.STATE_MAP_VIEW;
        }

        return {
            name: stateName,
            data: data
        };
    },

    _switchMaemoPositionSpiceOffset: function(aEnable) {
        var maemoPositionSpice = this._spiceManager.getSpice("MaemoPositionSpice");
        if (!maemoPositionSpice) {
            return;
        }

        if (aEnable) {
            maemoPositionSpice.addCustomStyle("nmp_Offset");
        } else {
            maemoPositionSpice.removeCustomStyle("nmp_Offset");
        }
    },

    deactivate: function() {
        this._switchMaemoPositionSpiceOffset(false);
        this._infoBarSpice.setAddWaypointMode(false);
        this._unregister();
    }
});

nokiaMaplet.getOptionsMenu().onOptionSelected = function(aItemId) {
    alert(aItemId + " was selected");
};