
const LAST_DIR_PREF = "browser.download.lastDir";

var EXPORTED_SYMBOLS = [ "gDownloadLastDir" ];

let prefSvc = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefBranch);

let observer = {
  QueryInterface: function (aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) ||
        aIID.equals(Components.interfaces.nsISupports) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  observe: function (aSubject, aTopic, aData) {
    switch (aTopic) {
      case "private-browsing":
        gDownloadLastDirFile = null;
        break;
      case "browser:purge-session-history":
        gDownloadLastDirFile = null;
        if (prefSvc.prefHasUserValue(LAST_DIR_PREF))
          prefSvc.clearUserPref(LAST_DIR_PREF);
        break;
    }
  }
};

let os = Components.classes["@mozilla.org/observer-service;1"]
                   .getService(Components.interfaces.nsIObserverService);
os.addObserver(observer, "private-browsing", true);
os.addObserver(observer, "browser:purge-session-history", true);

let gDownloadLastDirFile = null;
let gDownloadLastDir = {
  get file() {
    if (gDownloadLastDirFile && !gDownloadLastDirFile.exists())
      gDownloadLastDirFile = null;

    return gDownloadLastDirFile;
  },
  set file(val) {
    if (val instanceof Components.interfaces.nsIFile)
      gDownloadLastDirFile = val.clone();
    else
      gDownloadLastDirFile = null;
  }
};
