BEGIN TRANSACTION; 

CREATE TABLE DATATYPES (
	ID INTEGER PRIMARY KEY,
	TXTNAME TEXT NOT NULL
);

-- Dictionary of field types
CREATE TABLE SFIELDTYPES (
	SFTYPE INTEGER PRIMARY KEY,
	TXTNAME TEXT NOT NULL,
	DATATYPE INTEGER NOT NULL 
		CONSTRAINT fk_datatype_id REFERENCES DATATYPES(ID) 
		ON DELETE CASCADE
	
);

-- Attachments
CREATE TABLE ATTACHMENTS (
	ID INTEGER PRIMARY KEY, 
	NUM INTEGER NOT NULL,
	-- Id of the synced item the attachment belongs to
	OWNER INTEGER NOT NULL 
		CONSTRAINT fk_sitems_id REFERENCES SITEMS(ID)
		ON DELETE CASCADE,
	-- Checksum of the file which contains the attachment		
	CHKSUM TEXT NOT NULL		
);

-- Fields of the synced items
CREATE TABLE SFIELDS (
	ID INTEGER PRIMARY KEY,
	NUM INTEGER NOT NULL,
	CONTENT TEXT NOT NULL,
	-- Item the field belongs to
	SITEM INTEGER NOT NULL
		CONSTRAINT fk_sitems_id REFERENCES SITEMS(ID)
		ON DELETE CASCADE,
	-- Type of the field	
	SFTYPE INTEGER NOT NULL
		CONSTRAINT fk_sfieldtypes_sftype REFERENCES SFIELDTYPES(SFTYPE)
		ON DELETE CASCADE
);

CREATE INDEX idx_sfields_sitem ON sfields(sitem);

-- Synced items
CREATE TABLE SITEMS (
	ID INTEGER PRIMARY KEY AUTOINCREMENT,
	-- Folder the synced item belongs to
	FOLDER INTEGER NOT NULL
		CONSTRAINT fk_folders_id REFERENCES FOLDERS(ID) 
		ON DELETE CASCADE
);

CREATE INDEX idx_sitems_folder ON sitems(folder);

--CREATE INDEX idx_msgheaders_msg ON msgheaders(MSG);

-- CREATE INDEX idx_attachmenthdrs_attachment ON attacmenthdrs(attachment);

-- Folders types
CREATE TABLE FOLDERTYPES (
	ID INTEGER PRIMARY  KEY,
	NAME TEXT NOT NULL,
	MAINTABLE TEXT
);

INSERT INTO FOLDERTYPES (ID, NAME, MAINTABLE) VALUES (6, "Email", "MAILFIELDS");
INSERT INTO FOLDERTYPES (ID, NAME, MAINTABLE) VALUES (2, "Calendar", NULL);
INSERT INTO FOLDERTYPES (ID, NAME, MAINTABLE) VALUES (1, "Contacts", NULL);


-- Folders and their relations
CREATE TABLE FOLDERS (
	ID INTEGER PRIMARY KEY, 
	NAME TEXT NOT NULL,
	CLIENTANCHOR TEXT,
	TEMPANCHOR TEXT, 
	PARENT INTEGER
		CONSTRAINT fk_folders_id REFERENCES FOLDERS(ID)
		ON DELETE CASCADE,
	ROOT   INTEGER
		CONSTRAINT fk_foldersroot_id REFERENCES FOLDERS(ID)
		ON DELETE CASCADE,
	FTYPE INTEGER NOT NULL
		CONSTRAINT fk_folders_type REFERENCES FOLDERTYPES(ID)
		ON DELETE CASCADE
);

-- Dictionary of possible edit log entries types
CREATE TABLE EDITTYPES (
	ID INTEGER PRIMARY KEY,
	NAME TEXT NOT NULL
);

-- Tasks for IS Daemon
CREATE TABLE EDITLOG (
	ID INTEGER PRIMARY KEY,
	ETYPE INTEGER NOT NULL
		CONSTRAINT fk_edittypes_id REFERENCES EDITTYPES(ID)
		ON DELETE CASCADE,
	FOLDER INTEGER NOT NULL
		CONSTRAINT fk_tasks_FOLDER_id REFERENCES FOLDERS(ID)
		ON DELETE CASCADE,
	SITEM INTEGER NOT NULL
		CONSTRAINT fk_sitems_id REFERENCES SITEMS(ID)
		ON DELETE CASCADE,
	-- null, or some "stamp" number for current sync
	SYNCHRONIZING INTEGER,
	ARG1 TEXT,
	ARG2 TEXT
);

-- Attachment headers
CREATE TABLE ATTACHMENTHDRS (
	-- Id of the attachment header
	ID INTEGER PRIMARY KEY,
	-- Type of the header
	HDRTYPE INTEGER NOT NULL,
	-- Id of the attachment the header belongs to
	ATTACHMENT INTEGER NOT NULL
		CONSTRAINT fk_attachments_id REFERENCES ATTACHMENTS(ID)
		ON DELETE CASCADE,
	-- Content of the attachment header	
	VALUE TEXT NOT NULL	
);

-- Folder specific settings
CREATE TABLE FOLDERSETTINGS (
	ID INTEGER PRIMARY KEY,
	FOLDER INTEGER NOT NULL
		CONSTRAINT fk_folderss_id REFERENCES FOLDERS(ID),
	SKEY TEXT NOT NULL,
	VALUE TEXT NOT NULL
);

-- "Special" fields of the mail messages
CREATE TABLE MAILFIELDS (
	ID INTEGER PRIMARY KEY
		CONSTRAINT fk_sitemsm_id REFERENCES SITEMS(ID),
	emlFrom TEXT,
	-- Email Address (To)
	emlTo TEXT,
	-- Email Subject
	emlSubject TEXT,
	-- Email date (Created)
	emlDate DATETIME,
	-- Email Maximum body size
	emlMaxEmailBody INTEGER,
	-- Total size of the message
	emlServerSize INTEGER,
	-- Email Read Item Indicator
	emlRead  INTEGER,
	-- Internal Status Indicator
	emlReadySyncGo INTEGER,
	emlCC TEXT,
	emlBCC TEXT,
	-- Mail priority
	emlPriority INTEGER,
	-- Number of attachments
	attachmentCount INTEGER,
	-- Checksum of the file which contains the body message	
	emlSource INTEGER,
	FOLDER INTEGER,
	CHKSUM TEXT,
	TIMESTAMP INTEGER
);

CREATE INDEX idx_mailfields_folder ON mailfields(folder);
CREATE INDEX idx_mailfields_emlSource ON mailfields(emlSource);

CREATE TABLE ACCOUNTINFOS (
	ACCOUNT TEXT,
	PKEY TEXT,
	VALUE TEXT
);

CREATE TABLE CHANGECACHE (
	ID INTEGER PRIMARY KEY,
	SITEM INTEGER NOT NULL,
	FOLDER INTEGER NOT NULL
		CONSTRAINT fk_tasks_FOLDER_id REFERENCES FOLDERS(ID),
	ETYPE INTEGER NOT NULL
		CONSTRAINT fk_edittypes_id REFERENCES EDITTYPES(ID),
	SFTYPE INTEGER
		CONSTRAINT fk_folders_type REFERENCES FOLDERTYPES(ID)
);

CREATE TABLE SETTINGS (
	USERNAME TEXT,
	PASSWORD TEXT,	
	SERVERADDRESS TEXT,
	DEVICEID TEXT,
	DEVICENAME TEXT
);


CREATE TRIGGER fkd_sitems_delete
BEFORE DELETE ON SITEMS
FOR EACH ROW BEGIN 
	delete from MAILFIELDS where MAILFIELDS.ID = OLD.ID;
	delete from SFIELDS where SFIELDS.SITEM = OLD.ID;
	delete from ATTACHMENTS where ATTACHMENTS.OWNER = OLD.ID;
END;

--CREATE TRIGGER fkd_msgheaders_delete
--BEFORE DELETE ON MSGHEADERS
--FOR EACH ROW BEGIN 
--	delete from HEADERS where HEADERS.ID = OLD.HDR;
	
--END;

-- CREATE TRIGGER fkd_sfields_delete
-- BEFORE DELETE ON SFIELDS
-- FOR EACH ROW BEGIN 
-- 	delete from MSGHEADERS where MSGHEADERS.HDR = OLD.ID;
-- 	delete from ATTACHMENTHDRS where ATTACHMENTHDRS.HDR = OLD.ID;
-- END;

CREATE TRIGGER fkd_attachments_delete
BEFORE DELETE ON ATTACHMENTS
FOR EACH ROW BEGIN 
	delete from ATTACHMENTHDRS where ATTACHMENTHDRS.ATTACHMENT = OLD.ID;
END;

CREATE TRIGGER fkd_folder_delete
BEFORE DELETE ON FOLDERS
FOR EACH ROW BEGIN 
  SELECT CASE
    WHEN ((SELECT sitems.id FROM sitems WHERE sitems.folder = OLD.id) IS NOT NULL)
    THEN RAISE(ABORT, 'delete on table "FOLDERS" violates fkd_folder_delete')
  END;
  delete from FOLDERSETTINGS where FOLDERSETTINGS.FOLDER = OLD.ID;
END;


CREATE TRIGGER fkd_mailfields_update
AFTER INSERT ON ATTACHMENTS
FOR EACH ROW BEGIN 
	update MAILFIELDS set attachmentCount=NEW.NUM+1 where MAILFIELDS.ID=NEW.OWNER;
END;

-- Header types for contacts, calendar, email
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1, "cntTimeZone", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (4, "cntFileAs", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (5, "cntWebPage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (6, "cntFirstName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (7, "cntMiddleName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (8, "cntLastName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (9, "cntTitle", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (10, "cntSuffix", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (11, "cntWorkStreet", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (12, "cntWorkCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (13, "cntWorkState", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (14, "cntWorkZip", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (15, "cntWorkCountry", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (16, "cntWorkPostOfficeBox", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (17, "cntHomeStreet", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (18, "cntHomeCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (19, "cntHomeState", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (20, "cntHomeZip", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (21, "cntHomeCountry", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (22, "cntHomePostOfficeBox", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (23, "cntOtherStreet", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (24, "cntOtherCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (25, "cntOtherState", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (26, "cntOtherZip", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (27, "cntOtherCountry", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (28, "cntOtherPostOfficeBox", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (29, "cntWorkPhone", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (30, "cntHomePhone", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (31, "cntFax", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (32, "cntMobile", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (33, "cntPager", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (34, "cntOther", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (35, "cntMain", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (36, "cntEmail", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (37, "cntNickName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (38, "cntSalutation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (39, "cntSpouse", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (40, "cntChildren", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (41, "cntBirthday", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (42, "cntAnniversary", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (43, "cntHobby", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (44, "cntGender", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (45, "cntLanguage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (46, "cntPersonalHomePage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (47, "cntCompanyName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (48, "cntJobTitle", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (49, "cntProfession", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (50, "cntDepartment", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (51, "cntOfficeLocation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (52, "cntAssistantName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (53, "cntAssistantTitle", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (54, "cntManagerName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (55, "cntComputerNetworkName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (56, "cntCustomerId", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (57, "cntGovernmentIdNumber", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (58, "cntOrganizationalIdNumber", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (59, "cntBusinessHomePage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (60, "cntFTPSite", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (61, "cntContactName2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (62, "cntContactTitle2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (63, "cntContactName3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (64, "cntContactTitle3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (65, "cntReferredBy", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (66, "cntBillingInformation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (67, "cntAccount", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (68, "cntStatus", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (69, "cntLastReach", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (70, "cntLastAttempt", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (71, "cntLastResults", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (72, "cntUser1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (73, "cntUser2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (74, "cntUser3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (75, "cntUser4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (76, "cntUser5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (77, "cntUser6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (78, "cntUser7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (79, "cntUser8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (80, "cntUser9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (81, "cntUser10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (82, "cntUser11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (83, "cntUser12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (84, "cntUser13", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (85, "cntUser14", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (86, "cntUser15", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (87, "cntPrivate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (88, "cntCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (89, "cntBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (90, "cntMileage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (91, "cntTelexNumber", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (92, "cntJournal", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (93, "cntSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (94, "cntISDNNumber", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (95, "cntYomiCompanyName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (96, "cntYomiFirstName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (97, "cntYomiLastName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (148, "cntSelectedMailingAddress", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (150, "cntTTYTDDNumber", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (190, "cntPhoneLabel1", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (191, "cntPhoneLabel2", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (192, "cntPhoneLabel3", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (193, "cntPhoneLabel4", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (194, "cntPhoneLabel5", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (199, "cntContacts", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (296, "cntCustom1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (297, "cntCustom2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (298, "cntCustom3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (299, "cntCustom4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (300, "cntCustom5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (301, "cntCustom6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (302, "cntCustom7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (303, "cntCustom8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (304, "cntCustom9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (305, "cntCustom10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (306, "cntCustom11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (307, "cntCustom12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (348, "cntPhoneLabel6", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (349, "cntPhoneLabel7", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (350, "cntPhoneLabel8", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (351, "cntChatLabel1", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (352, "cntChatLabel2", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (353, "cntAolMessengerID", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (354, "cntYahooMessengerID", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (355, "cntICQMessengerID", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (356, "cntMSNMessengerID", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (357, "cntInstantMessengerID", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (358, "cntAddressLabel1", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (359, "cntAddressLabel2", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (360, "cntAddressLabel3", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (361, "cntWorkStreet2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (362, "cntWorkCity2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (363, "cntWorkState2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (364, "cntWorkZip2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (365, "cntWorkCountry2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (366, "cntWorkStreet3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (367, "cntWorkCity3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (368, "cntWorkState3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (369, "cntWorkZip3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (370, "cntWorkCountry3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (371, "cntHomeStreet2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (372, "cntHomeCity2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (373, "cntHomeState2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (374, "cntHomeZip2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (375, "cntHomeCountry2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (376, "cntHomeStreet3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (377, "cntHomeCity3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (378, "cntHomeState3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (379, "cntHomeZip3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (380, "cntHomeCountry3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (381, "cntOtherStreet3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (382, "cntOtherCity3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (383, "cntOtherState3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (384, "cntOtherZip3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (385, "cntOtherCountry3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (386, "cntBirthdayReminder", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (387, "cntBirthdayReminderTime", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (388, "cntPicture", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (389, "cntPalmUnknownBlob", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (395, "cntOtherStreet2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (396, "cntOtherCity2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (397, "cntOtherState2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (398, "cntOtherZip2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (399, "cntOtherCountry2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1001, "cntYomiFullName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1002, "cntFullName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (2, "calReadySyncGo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (98, "calSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (99, "calBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (100, "calStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (101, "calEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (102, "calNoTime", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (103, "calPrivate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (104, "calCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (105, "calReminder", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (106, "calReminderTime", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (107, "calLocation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (108, "calRecurrenceType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (109, "calFrequency", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (110, "calDayOfWeekMask", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (111, "calRecurrenceEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (112, "calWeekNumber", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (127, "calExceptions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (147, "calBusyStatus", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (151, "calDayOfMonth", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (195, "calClassName", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (197, "calRepeatStartWeek", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (200, "calContacts", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (223, "calMeetingGuid", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (224, "calMeetingCreationDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (225, "calTo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (226, "calToStatus", 8195);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (227, "calToReplyDate", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (228, "calCC", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (229, "calCCStatus", 8195);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (230, "calCCReplyDate", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (231, "calBCC", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (232, "calBCCStatus", 8195);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (233, "calBCCReplyDate", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (234, "calRecipients", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (236, "calFrom", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (239, "calMeetingStatus", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (240, "calMeetingReplyDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (241, "calAdditions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (243, "calMeetingSentDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (244, "calMeetingCancelled", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (255, "calAppointmentType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (269, "calReminderDescription", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (270, "calChildFlights", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (271, "calParentTrip", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (278, "calPriority", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (280, "calRoom", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (282, "calTimeZone", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (284, "calCustom1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (285, "calCustom2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (286, "calCustom3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (287, "calCustom4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (288, "calCustom5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (289, "calCustom6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (290, "calCustom7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (291, "calCustom8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (292, "calCustom9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (293, "calCustom10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (294, "calCustom11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (295, "calCustom12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (345, "calSplitStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (346, "calParentGuid", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (347, "calSplitEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (390, "calPalmTZCountry", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (391, "calPalmTZCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (392, "calPalmUnknownBlob", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (393, "calUnknownTimeZone", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (400, "calParentStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (401, "calParentEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (406, "calMeetingApptId", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (408, "calFanned", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (409, "calOriginalStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (410, "calParent", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (411, "calGhost", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (415, "calParentServerKey", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (416, "calParentClientKey", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (420, "calIdentity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (113, "ntsBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (114, "ntsColor", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (115, "ntsCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (116, "ntsPrivate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (267, "ntsSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (308, "ntsCustom1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (309, "ntsCustom2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (310, "ntsCustom3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (311, "ntsCustom4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (312, "ntsCustom5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (313, "ntsCustom6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (314, "ntsCustom7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (315, "ntsCustom8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (316, "ntsCustom9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (317, "ntsCustom10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (318, "ntsCustom11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (319, "ntsCustom12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (3, "tskStatus", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (117, "tskSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (118, "tskBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (119, "tskDueDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (120, "tskStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (121, "tskPriority", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (122, "tskComplete", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (123, "tskDateCompleted", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (124, "tskPercentComplete", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (125, "tskTotalWork", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (126, "tskActualWork", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (128, "tskCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (129, "tskPrivate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (130, "tskBillingInformation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (131, "tskCompanies", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (132, "tskMileage", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (133, "tskContacts", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (134, "tskReminder", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (135, "tskReminderDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (149, "tskOwner", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (245, "tskRecurrenceType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (246, "tskFrequency", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (247, "tskDayOfWeekMask", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (248, "tskRecurrenceEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (249, "tskWeekNumber", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (250, "tskExceptions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (251, "tskDayOfMonth", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (252, "tskAdditions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (253, "tskOccurrencesRemaining", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (268, "tskReminderDescription", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (277, "tskAdvance", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (320, "tskCustom1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (321, "tskCustom2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (322, "tskCustom3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (323, "tskCustom4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (324, "tskCustom5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (325, "tskCustom6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (326, "tskCustom7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (327, "tskCustom8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (328, "tskCustom9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (329, "tskCustom10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (330, "tskCustom11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (331, "tskCustom12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (136, "expAmount", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (137, "expExpenseDate", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (138, "expExpenseType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (139, "expPaymentType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (140, "expCurrencyType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (141, "expVendor", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (142, "expCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (143, "expAttendees", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (144, "expNote", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (145, "expPrivate", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (146, "expCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (181, "favTitle", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (182, "favURL", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (183, "favPath", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (184, "favAddDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (185, "favLastVisit", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (186, "favLastModify", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (187, "favFileAttributes", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (188, "favIsDirectory", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (152, "emlDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (153, "emlTo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (154, "emlFrom", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (155, "emlSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (156, "emlCC", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (157, "emlBCC", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (158, "emlBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (159, "emlReplyTo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (160, "emlInReplyTo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (161, "emlReceived", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (162, "emlMessageID", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (163, "emlReturnPath", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (164, "emlComment", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (165, "emlEncrypted", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (166, "emlMimeVersion", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (167, "emlContentType", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (168, "emlRead", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (169, "emlCategories", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (170, "emlRichBody", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (173, "emlContentEncoding", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (174, "emlAttachmentBody", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (176, "emlRichHeaders", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (177, "emlAttachmentHeaders", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (179, "emlMailbox", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (180, "emlID", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (201, "emlPriority", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (202, "emlMeetingGuid", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (203, "emlMeetingCreationDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (204, "emlMeetingSentDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (205, "emlType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (206, "emlReadySyncGo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (207, "emlStartDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (208, "emlEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (209, "emlNoTime", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (210, "emlPrivate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (211, "emlReminder", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (212, "emlReminderTime", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (213, "emlLocation", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (214, "emlRecurrenceType", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (215, "emlFrequency", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (216, "emlDayOfWeekMask", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (217, "emlRecurrenceEndDate", 7);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (218, "emlBusyStatus", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (219, "emlDayOfMonth", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (220, "emlContacts", 8200);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (221, "emlWeekNumber", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (222, "emlTimeZone", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (242, "emlAdditions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (254, "emlSubfolder", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (256, "emlIsSilent", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (257, "emlDelegateMail", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (258, "emlIsException", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (259, "emlSingleInvite", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (260, "emlDowPref", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (261, "emlMaxEmailBody", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (263, "emlServerSize", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (266, "emlAttachmentsIncluded", 8203);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (272, "emlExceptions", 8199);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (273, "emlReminderDescription", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (274, "emlServerBodySize", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (275, "emlServerAttachmentHeaders", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (276, "emlParseItinerary", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (279, "emlMeetingUpdate", 11);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (281, "emlRoom", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (283, "emlSender", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (332, "emlCustom1", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (333, "emlCustom2", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (334, "emlCustom3", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (335, "emlCustom4", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (336, "emlCustom5", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (337, "emlCustom6", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (338, "emlCustom7", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (339, "emlCustom8", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (340, "emlCustom9", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (341, "emlCustom10", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (342, "emlCustom11", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (343, "emlCustom12", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (402, "emlFlags", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (403, "emlPalmUnknownBlob", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (404, "emlPalmTZCountry", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (405, "emlPalmTZCity", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (407, "emlMeetingApptId", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (414, "emlResponse", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1000, "emlMailboxAddress", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1003, "emlMeetingTo", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1004, "emlMeetingCC", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1005, "emlMeetingBody", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1006, "emlUnsupportedMeetingFields", 8209);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1007, "emlMeetingSequenceNumber", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1008, "emlMeetingSubject", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (1018, "emlSource", 3);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (2001, "Length", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (2002, "Filename", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (2003, "Type", 8);
INSERT INTO SFIELDTYPES (SFTYPE, TXTNAME, DATATYPE) VALUES
    (2004, "CHKSUM", 8);



-- Datatypes below have to be the integers used as variant tags in the wire protocol
-- Valid values are enumerated below. If NULL, string (8) is assumed
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (0, "EmptyVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (2, "ShortVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (3, "IntVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (5, "DoubleVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (7, "DateVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8, "StringVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (11, "BoolVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (17, "ByteVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8192, "ArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8194, "ShortArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8195, "IntArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8197, "DoubleArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8199, "DateArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8200, "StringArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8203, "BoolArrayVariantType");
INSERT INTO DATATYPES (ID, TXTNAME) VALUES
    (8209, "ByteArrayVariantType");

INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (1,"Inbox", NULL, 6);
INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (2,"Outbox", NULL, 6);
INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (3, "Calendar", NULL, 2);
INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (4,"Contacts", NULL, 1);
INSERT INTO FOLDERS (ID,NAME, PARENT, FTYPE) VALUES (5, "Sent Items", NULL, 6);
INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (6, "Drafts", NULL, 6);
-- INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (7, "Deleted items", NULL, 6);



-- This is like "NULL" folder, for messages (MSGS) that
-- are still being created
INSERT INTO FOLDERS (ID, NAME, PARENT, FTYPE) VALUES (1000, "nofolder", NULL, 255);

-- Remove message from the server
INSERT INTO EDITTYPES (ID, NAME) VALUES (1,  "ELOG_REMOVE_MSG");
-- Update the body of the message
INSERT INTO EDITTYPES (ID, NAME) VALUES (2,  "ELOG_UPDATE_MSG_HEADER");
-- Update one of the attachment"s headers
INSERT INTO EDITTYPES (ID, NAME) VALUES (3,  "ELOG_UPDATE_ATTACHMENT_HEADER");
-- Remove an attachment
INSERT INTO EDITTYPES (ID, NAME) VALUES (4,  "ELOG_REMOVE_ATTACHMENT");
-- Send message (new outgoing e-mail)
INSERT INTO EDITTYPES (ID, NAME) VALUES (5,  "ELOG_NEW_MSG");
-- Move message fromm one folder (or sub-folder) to another 
INSERT INTO EDITTYPES (ID, NAME) VALUES (6,  "ELOG_MOVE_TO_FOLDER");

--the data stored in VALUE will depend on the IKEY value
CREATE TABLE IMSSERVERSETTINGS 
(
	SERVERID INTEGER NOT NULL,
	IKEY INTEGER NOT NULL,
	VALUE TEXT NOT NULL,
    PRIMARY KEY (SERVERID, IKEY ) 
);

CREATE TABLE IMSUSERSERVERSETTINGS 
(
	SERVERID INTEGER NOT NULL,
	USERID INTEGER NOT NULL,
	IKEY INTEGER NOT NULL,
	VALUE TEXT NOT NULL,
    PRIMARY KEY (SERVERID, USERID, IKEY ) 
);

CREATE TABLE IMSSYSTEMSETTINGS 
(
	IKEY INTEGER NOT NULL,
	VALUE TEXT NOT NULL,
    PRIMARY KEY ( IKEY ) 
);

CREATE TABLE IMSSYSTEMSETTINGS_TYPES 
(
	IKEY_TYPE INTEGER PRIMARY KEY NOT NULL,
	IKEY_TYPENAME TEXT NOT NULL
);

--only storing the base value for the IKEY, so it is stripped of all of the including type, overide, etc.
--the only attribute it retains is the server, system, userserver part
CREATE TABLE IMSSYSTEMSETTINGS_NAMES
(
	IKEY_BASE INTEGER PRIMARY KEY NOT NULL,
	IKEY_NAME TEXT NOT NULL
);

CREATE VIEW IMSSERVERSETTINGS_HUMAN as
SELECT SERVERID as serverid, 
    (select IKEY_NAME from IMSSYSTEMSETTINGS_NAMES as n where s.IKEY & 4026597375 = n.IKEY_BASE) as IKEY_NAME, 
    (select IKEY_TYPENAME from IMSSYSTEMSETTINGS_TYPES as t where s.IKEY & 251658240 = t.IKEY_TYPE) as TYPE_NAME, 
    IKEY, VALUE from IMSSERVERSETTINGS as s;

CREATE VIEW IMSSYSTEMSETTINGS_HUMAN as
SELECT 
    (select IKEY_NAME from IMSSYSTEMSETTINGS_NAMES as n where s.IKEY & 4026597375 = n.IKEY_BASE) as IKEY_NAME, 
    (select IKEY_TYPENAME from IMSSYSTEMSETTINGS_TYPES as t where s.IKEY & 251658240 = t.IKEY_TYPE) as TYPE_NAME, 
    IKEY, VALUE from IMSSYSTEMSETTINGS as s;    

CREATE VIEW IMSUSERSERVERSETTINGS_HUMAN as
SELECT SERVERID as serverid, USERID as userid,
    (select IKEY_NAME from IMSSYSTEMSETTINGS_NAMES as n where s.IKEY & 4026597375 = n.IKEY_BASE) as IKEY_NAME, 
    (select IKEY_TYPENAME from IMSSYSTEMSETTINGS_TYPES as t where s.IKEY & 251658240 = t.IKEY_TYPE) as TYPE_NAME, 
    IKEY, VALUE from IMSUSERSERVERSETTINGS as s;    

--sqlite3 does not accept 0x00000000 notation for numbers
INSERT INTO IMSSYSTEMSETTINGS_TYPES  (IKEY_TYPE, IKEY_TYPENAME) VALUES
    (16777216, "SETTING_LONG"); 
INSERT INTO IMSSYSTEMSETTINGS_TYPES  (IKEY_TYPE, IKEY_TYPENAME) VALUES
    (33554432, "SETTING_STR"); 
INSERT INTO IMSSYSTEMSETTINGS_TYPES  (IKEY_TYPE, IKEY_TYPENAME) VALUES
    (67108864, "SETTING_TSTR"); 
INSERT INTO IMSSYSTEMSETTINGS_TYPES  (IKEY_TYPE, IKEY_TYPENAME) VALUES
    (134217728, "SETTING_BYTES"); 


INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1, "SETTING_SYSTEM_SOCKETCONNECTTIMEOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (2, "SETTING_SYSTEM_SOCKETREADTIMEOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (3, "SETTING_SYSTEM_SOCKETWRITETIMEOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (4, "SETTING_SYSTEM_RETRYCOUNT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (5, "SETTING_SYSTEM_DATACONNECTIONTIMEOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (6, "SETTING_SYSTEM_DATACONNECTIONRETRYCOUNT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (7, "SETTING_SYSTEM_DATACONNECTIONRETRYDELAY"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (8, "SETTING_SYSTEM_DATACONNECTIONDISCONNECTIMEOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (9, "SETTING_SYSTEM_IPADDRESS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (10, "SETTING_SYSTEM_DEVICETYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (11, "SETTING_SYSTEM_COMPRESSION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (12, "SETTING_SYSTEM_STREAM"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (13, "SETTING_SYSTEM_DEVICENAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (14, "SETTING_SYSTEM_URLS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (15, "SETTING_SYSTEM_USERS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (16, "SETTING_SYSTEM_MDN"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (17, "SETTING_SYSTEM_IMSI"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (18, "SETTING_SYSTEM_IMEI"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (19, "SETTING_SYSTEM_LOGLEVEL"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (20, "SETTING_SYSTEM_AUTOMATICDEVICEIDCREATION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (21, "SETTING_SYSTEM_LOGTOSTDOUT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (22, "SETTING_SYSTEM_LOGSTOKEEP"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (23, "SETTING_SYSTEM_LOGSIZE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (24, "SETTING_SYSTEM_SSL_CERTAUTH_FILE"); 



INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 1, "SETTING_SERVER_URL"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 2, "SETTING_SERVER_CONNECTIONNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 3, "SETTING_SERVER_CONNECTIONUSE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 4, "SETTING_SERVER_AUTHENTICATIONCHECKPAGE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 5, "SETTING_SERVER_CHUNKINGSIZE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 6, "SETTING_SERVER_SECUREGATEWAYVERSION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 7, "SETTING_SERVER_MOBILEGATEWAYVERSION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 8, "SETTING_SERVER_ACCEPTSSIMULTANEOUSGLOBSESS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 9, "SETTING_SERVER_HTTPREADREQUEST"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 10, "SETTING_SERVER_HTTPWRITEREQUEST"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 11, "SETTING_SERVER_HTTPMETHOD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 12, "SETTING_SERVER_TRYALLPROTOCOLS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 13, "SETTING_SERVER_PROXYSERVER"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 14, "SETTING_SERVER_ENTERPRISEID"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 15, "SETTING_SERVER_PROXYUSERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 16, "SETTING_SERVER_PROXYPASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 17, "SETTING_SERVER_REVERSEPROXYUSERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 18, "SETTING_SERVER_REVERSEPROXYPASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 19, "SETTING_SERVER_BYPASSLOCALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 20, "SETTING_SERVER_USEPROXY"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 21, "SETTING_SERVER_USEACTIVECONNECTION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (536870912 + 22, "SETTING_SERVER_ODS_HTTPURL"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 1, "SETTING_USERSERVER_DEVICEID"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 2, "SETTING_USERSERVER_SECURID"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 3, "SETTING_USERSERVER_DEVICEREGISTERED"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 4, "SETTING_USERSERVER_RETRYMODE_FIRSTRETRYTIME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 5, "SETTING_USERSERVER_RETRYMODE_SECONDRETRYTIME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 6, "SETTING_USERSERVER_PUSHWINDOW_PUSH"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 7, "SETTING_USERSERVER_PUSHWINDOW_SMSPUSH"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 8, "SETTING_USERSERVER_PUSHWINDOW_NETWORKPUSH"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 9, "SETTING_USERSERVER_PUSHWINDOW_BATTERYLEVEL"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 10, "SETTING_USERSERVER_PUSHWINDOW_BATTERYLEVEL_ENABLED"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 11, "SETTING_USERSERVER_PUSHWINDOW_STARTMINUTES"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 12, "SETTING_USERSERVER_PUSHWINDOW_ENDMINUTES"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 13, "SETTING_USERSERVER_PUSHWINDOW_DAYS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 14, "SETTING_USERSERVER_PUSHWINDOW_LIMITED"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 15, "SETTING_USERSERVER_READYSYNC_ENABLED"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 16, "SETTING_USERSERVER_READYSYNC_CANINITDATA"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 17, "SETTING_USERSERVER_READYSYNC_UPONCONNECTION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 18, "SETTING_USERSERVER_READYSYNC_FREQUENCY"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 19, "SETTING_USERSERVER_PUSHWINDOWREADYSYNC_CHANGED"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 20, "SETTING_USERSERVER_SYNC_DATANOTIFICATION"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 21, "SETTING_USERSERVER_NFYPASSCODE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 22, "SETTING_USERSERVER_WEBURL"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 23, "SETTING_USERSERVER_SERVERRSA"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 24, "SETTING_USERSERVER_NEEDSSECURID"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 25, "SETTING_USERSERVER_ENCRYPT"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 26, "SETTING_USERSERVER_SYNCEDTODAY"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 27, "SETTING_USERSERVER_ENCRYPTEDPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 28, "SETTING_USERSERVER_LASTMDN"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 29, "SETTING_USERSERVER_LASTIMEI"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 30, "SETTING_USERSERVER_LASTIMSI"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 31, "SETTING_USERSERVER_LASTIP"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 32, "SETTING_USERSERVER_LASTPINGSUCCESS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 33, "SETTING_USERSERVER_ALLOWOPENINGTIMEDINTERVALSYNC"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 34, "SETTING_USERSERVER_PUSHWINDOW_NOROAMING"); 




INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 80, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 81, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 82, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 83, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 84, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 85, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 86, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 87, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 88, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 89, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 90, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 91, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 92, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 93, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 94, "SETTING_USERSERVER_USERNAME"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 95, "SETTING_USERSERVER_USERNAME"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 112, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 113, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 114, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 115, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 116, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 117, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 118, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 119, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 120, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 121, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 122, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 123, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 124, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 125, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 126, "SETTING_USERSERVER_PASSWORD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 127, "SETTING_USERSERVER_PASSWORD"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 160, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 161, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 162, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 163, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 164, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 165, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 166, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 167, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 168, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 169, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 170, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 171, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 172, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 173, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 174, "SETTING_USERSERVER_CREDENTIALS"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 175, "SETTING_USERSERVER_CREDENTIALS"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 192 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 193 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 194 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 195 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 196 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 197 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 198 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 199 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 200 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 201 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 202 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 203 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 204 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 205 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 206 , "SETTING_USERSERVER_CREDENTIALSTYPE"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 207, "SETTING_USERSERVER_CREDENTIALSTYPE"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 256, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 257, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 258, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 259, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 260, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 261, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 262, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 263, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 264, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 265, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 266, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 267, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 268, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 269, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 270, "SETTING_USERSERVER_LASTUSR"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 271, "SETTING_USERSERVER_LASTUSR"); 

INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 288, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 289, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 290, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 291, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 292, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 293, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 294, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 295, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 296, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 297, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 298, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 299, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 300, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 301, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 302, "SETTING_USERSERVER_LASTPWD"); 
INSERT INTO IMSSYSTEMSETTINGS_NAMES  (IKEY_BASE, IKEY_NAME) VALUES
    (1073741824 + 303, "SETTING_USERSERVER_LASTPWD"); 




END TRANSACTION;


