#!/bin/sh

# maemo-optify-make-mountbind
#######################################################
# Copyright: (C) 2010 Nokia
# License:   DO WHAT YOU WANT TO PUBLIC LICENSE
# Authors:   Karpov Denis, ext-denis.2.karpov@nokia.com
#            Claudio Saavedra, csaavedra@igalia.com
#            Gary Birkett, gary.birkett@collabora.co.uk
#            Alban Crequy, alban.crequy@collabora.co.uk
#            Urho Konttori, urho.konttori@nokia.com
#            Sergey Yakubenko, EXT-Sergey.Yakubenko@nokia.com
#######################################################

# minimal script to convert the old style /opt symlink to a mountbind
# called from HAM rescue mode script which requires early upgrade during SSU

# ensure /opt is a mountbind
# replace/steamroller any symlink predecessor
# only called if we are on device itself (ie ssu)
if [ ! -e /targets/links/scratchbox.config ]; then
  if ! mount|grep "on /opt type" > /dev/null; then
    # no /opt mountbind yet exists

    # coerce required folders into the correct state

    if [ -L /opt ]; then
      # /opt is a symlink, remove link
      rm /opt
      sync
    fi

    if [ ! -d /opt ]; then
      # /opt is missing, create it!
      mkdir /opt
      sync
    fi

    if [ ! -d /home/opt ]; then
      # /home/opt is missing, create it!
      mkdir /home/opt
      sync
    fi

    # finally, mount bind it
    mount --bind /home/opt /opt

  fi 
fi


return 0

