#!/bin/sh
# Various functions to test for optification pre-requiremenmts

# this is THE limit for required free space in /home
HOME_SPACE_LIMIT=200

# Check the limit of the free space under mount point (dir)
# param: $1 - mount point
# returns: the amount of free space in MB
dfree()
{
  space=`/bin/busybox stat -ft /home | /bin/busybox awk '{print int($5*$9/(1024*1024)) }'`
  [ $? -ne 0 ] && return 0
  return $space
}

# Check if /home is mounted r/w
# param: $1 - mount point
# returns 0 - /home is mounted r/w, non-0 otherwise
test_home_mount()
{
  /bin/busybox grep -q "/home ext3 rw" /proc/mounts
  return $?
}

# Check if /home/pot is mount bound to /opt
# returns 0 - /home/opt is mount bound to /opt, non-0 otherwise
test_opt_mount()
{
  [ /opt -ef /home/opt ] && return 0
  return 1
}

# Logging facilities

# Yes, the log is in rootfs.
protocol="/var/log/maemo-optify-boottime.log"
session="`date +"%F %T"`"
max_log_size=12288

# Don't allow log to grow beyond max_log_size bytes
[ -e $protocol ] && \
  [ `/bin/busybox stat -t $protocol | /bin/busybox awk '{print $2}'` -gt $max_log_size ] && \
  rm -f $protocol

# Redirect stderr into the log file (don't forget to restore when exiting!)
exec 2>>"$protocol"

# Log a string with a timestamp to the logfile
log() {
  echo "$session :: $1" >> $protocol
}
