#!/bin/sh

# maemo-optify-firstboot
#######################################################
# Copyright: (C) 2010 Nokia
# License:   DO WHAT YOU WANT TO PUBLIC LICENSE
# Authors:   Adam Endrodi, adam.endrodi@blumsoft.eu
#            Alban Crequy, alban.crequy@collabora.co.uk
#            Claudio Saavedra, csaavedra@igalia.com
#            Gary Birkett, gary.birkett@collabora.co.uk
#            Denis Karpov, ext-denis.2.karpov@nokia.com
#            Urho Konttori, urho.konttori@nokia.com
#            Sergey Yakubenko, ext-sergey.yakubenko@nokia.com
#######################################################
# 20100324_1600 gb
#   applied cleanups suggested by Neil Macleod, bugzilla770@nmacleod.com
#######################################################

# minimal script to cleanup /home/opt under very specific circumstances.
# will copy contents of rootfs /opt to /home-opt to allow image to be optified.
# will only run if do-not-clean-home-opt does not exist.
# postinst will create this file if used within scratchbox.
# IMPORTANT! this is called from upstart scripts, so make sure there are no 
# error codes returned

set +e 

# save stderr descriptor
exec 3>&2

# ...but ALWAYS exit with 0
trap "exec 2>&3; exit 0" EXIT

# use a variable to store do-not-clean file location
optifyflagfile="/var/lib/maemo-optify-firstboot-do-not-clean-home-opt"

# include test_* functions 
. /usr/sbin/maemo-optify-lib.sh

#only clean the /home/opt if needed
[ -e $optifyflagfile ] &&  return 0

# if /home is not mounted r/w for some reason -- bail out
if ! test_home_mount
then
  log "opt-boottime :: /home is not mounted r/w, quitting."
  return 0
fi

# if the /opt->/home/opt mountbind exists -- bail out
if test_opt_mount
then
  # we have come back into this function AFTER the binding has occured
  log "opt-boottime :: mount /home/opt->/opt exists, already optified, quitting."
  touch $optifyflagfile
  sync
  return 0
fi

# clean up existing /home/opt
if [ -d /home/opt ] 
then
  log "opt-boottime :: cleaning old /home/opt contents."
  rm -rf /home/opt/*
else
  log "opt-boottime :: created empty /home/opt."
  mkdir /home/opt
fi
sync

# move /opt contents to /home/opt only if they exist
# ensure we update the donotclean flag now so we do not run again.
if [ ! -d /opt -o -z "`ls /opt`" ]
then
  log "opt-boottime :: /opt does not exist or empty, quitting."
  touch $optifyflagfile
  sync    
  return 0
fi

# contents exist in original /opt,  copy touch remove
log "opt-boottime :: optifying..."
cp -a /opt/* /home/opt/
touch $optifyflagfile
sync
rm -rf /opt/*
sync
log "opt-boottime :: 1st boottime optification done."

return 0
