#!/usr/bin/awk

# Small upstart replacement: find a "script" section in a
# event file. Call with -vwhat="pre-start" or "pre-stop" or
# whatever the script section might be called.
BEGIN {
	state = 0
	if (!what) what = "script"
}

state == 0 && $1 == "env" { print gensub("env", "", "") }
/script$/ && state == 0 && $1 == what { state++; next }
/^end script$/ && state == 1 { state++; next }

# instead of 'exec', append a '&' so that it goes backgrounds itself
state == 1 && $1 == "exec" {
        for (i = 2; i <= NF; i++)
                printf "%s ", $i
        printf "&\n"
        next
}

# skip lines with initctl
state == 1 && !/initctl/ { print gensub("getbootstate", "echo USER", "g") }

