/* my contract id */
const STARTUP_LATCH_CTRID =
    "@nokia.com/maps/startup-latch;1";
const STARTUP_LATCH_CID =
    Components.ID("{a23ce5f4-030c-4859-aac4-527f12c776ec}");

/* components used */
const OBSERVER_SERVICE_CTRID =
    "@mozilla.org/observer-service;1";
const CATMAN_CTRID = "@mozilla.org/categorymanager;1";

const nsICategoryManager = Components.interfaces.nsICategoryManager;
const nsIObserverService = Components.interfaces.nsIObserverService;
const nsIObserver = Components.interfaces.nsIObserver;
const nsISupports = Components.interfaces.nsISupports;
const nsIComponentRegistrar = Components.interfaces.nsIComponentRegistrar;

/* constructor */
function CStartupLatch( )
{

}

CStartupLatch.prototype = {
    constructor: CStartupLatch,
    latch: false,
    pluginReady: false,
    os: Components.classes[OBSERVER_SERVICE_CTRID].getService(nsIObserverService),

    /* nsIObserver */
    observe: function CStartupService_observe( aSubject, aTopic, aData )
    {
	switch ( aTopic )
	    {
	    case "app-startup":
		this.os.addObserver( this, "x-osso-top-application", false );
		this.os.addObserver( this, "x-maps-plugin-ready", false );
		break;

	    case "x-osso-top-application":
		this.latch = true;
		this.os.removeObserver( this, "x-osso-top-application" );
	    if ( this.pluginReady )
		{
		    this.os.notifyObservers( this, "x-maps-start-plugin", null );
		}
		break;

	    case "x-maps-plugin-ready":
	    //if ( !this.latch )
	    //    this.os.removeObserver( this, "x-osso-top-application" );
	    //this.os.removeObserver( this, "x-maps-plugin-ready" );
	    this.pluginReady = true;
	    if ( this.latch )
	    {
		this.os.notifyObservers( null, "x-maps-start-plugin", null );
	    }

	    break;
	    }
    },
    /* nsISupports */
    QueryInterface: function CStartupLatch_QueryInterface( aIID )
    {
	if ( aIID.equals( nsIObserver ) ||
	     aIID.equals( nsISupports ) )
	    return this;

	Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
	return null;
    },
};

/* factory */
CStartupLatchFactory = new Object( );
CStartupLatchFactory.createInstance =
    function slf_create( outer, iid )
{
    if ( outer )
	throw Components.results.NS_ERROR_NO_AGGREGATION;

    return new CStartupLatch( ).QueryInterface( iid );
};

var Module = new Object( );

Module.registerSelf =
    function registerSelf( compMgr, fileSpec, location, type )
{
    this.mContractID = STARTUP_LATCH_CTRID;
    this.mCategory ="StartupLatch";
    if ( compMgr instanceof nsIComponentRegistrar )
	compMgr.registerFactoryLocation( STARTUP_LATCH_CID,
					 "StartupLatch",
					 this.mContractID,
					 fileSpec,
					 location,
					 type );
    catman = Components.classes[CATMAN_CTRID].getService( nsICategoryManager );
    catman.addCategoryEntry("app-startup", this.mCategory, "service,"+ this.mContractID, true, true );
};

Module.unregisterSelf =
    function unregisterSelf( compMgr, fileSpec, location )
{
    compMgr = compMgr.QueryInterface( nsIComponentRegistrar );
    compMgr.unregisterFactoryLocation( STARTUP_LATCH_CTRID, fileSpec );
    catman = Components.classes[CATMAN_CTRID].getService( nsICategoryManager );
    catman.deleteCategoryEntry( "app-startup", this.mCategory, true );
};

Module.getClassObject =
    function getClassObject( compMgr, cid, iid )
{
    if ( !iid.equals( Components.interfaces.nsIFactory ) )
	throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if ( cid.equals( STARTUP_LATCH_CID ) )
	return CStartupLatchFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
};

Module.canUnLoad =
    function canUnLoad( compMgr )
{
    return true;
};


function NSGetModule( compMgr, fileSpec )
{
    return Module;
}