#!/bin/sh

# sanity check. DEVNAME should start with a /
[ "$DEVNAME" != "${DEVNAME#/}" ] || exit 0

# Lazily unmount drives which are removed, but still mounted
if [ "$ACTION" = remove ] \
   && (grep -q "^$DEVNAME" /proc/mounts || grep -q "^$DEVNAME" /etc/mtab); then
  if [ -x /usr/bin/pumount ] ; then 
    /usr/bin/pumount -l "$DEVNAME";
  else 
    /bin/umount -l "$DEVNAME";
  fi
fi

exit 0
