#!/bin/sh
#
# @file gen-obex-capability.sh 
# This script generates capability object to be used by obexd daemon
#
# Copyright (C) 2008 Nokia Corporation. All rights reserved.
#
# Contact: Biris Ilias <ilias.biris@nokia.com>
#
# This software, including documentation, is protected by copyright
# controlled by Nokia Corporation. All rights are reserved. Copying,
# including reproducing, storing, adapting or translating, any or all
# of this material requires the prior written consent of Nokia Corporation.
# This material also contains confidential information which may not be
# disclosed to others without the prior written consent of Nokia.
#

MAESYNC_DIR="$HOME/.maesync"
MMC_DIR="/media/mmc1"
CAPABILITY_FILE="$MAESYNC_DIR/capability.xml"
TMP_CAPABILITY_FILE="/tmp/maesync-capability.xml"
SUITECONF_FILE="$MAESYNC_DIR/SuiteConf.xml"
INSTALLED_SUITECONF_FILE="/usr/share/maesync/SuiteConf.xml"
REV_DATE="20100601T000000Z"

# get_capability function
# param None
# This function generates capability object
get_capability()
{
cat << END	
<?xml version="1.0" ?>
<!-- OBEX Capability Object -->
<!DOCTYPE Capability SYSTEM "obex-capability.dtd">
<Capability Version="1.0">
        <General>
                <Manufacturer>Nokia</Manufacturer>
                <Model>$OSSO_PRODUCT_HARDWARE</Model>
                <SN>$IMEI_NO</SN>
                <SW Version="$VERSION"  Date="$REV_DATE"/>
                <Language>en</Language>
                <Memory>
                        <MemType>DEV</MemType>
                        <Location>$MYDOCSDIR</Location>
                        <Free>$DEVM_FREE</Free>
                        <Used>$DEVM_USED</Used>
                        <FileNLen>256</FileNLen>
                </Memory>
                <Memory>
                        <MemType>MMC</MemType>
                        <Location>$MMC_DIR</Location>
                        <Free>$MMC_FREE</Free>
                        <Used>$MMC_USED</Used>
                        <FileNLen>256</FileNLen>
                </Memory>
	<Ext>
		<XNam>NetworkInfo</XNam>
		<XVal>CurrentNetwork=$OPERATOR_NAME</XVal>
		<XVal>CountryCode=$OPERATOR_COUNTRY_CODE</XVal>
		<XVal>NetworkID=$NETWORK_ID</XVal>
	</Ext>
	<Ext>
		<XNam>ModelName</XNam>
		<XVal>$OSSO_PRODUCT_NAME</XVal>
	</Ext>
	<Ext>
		<XNam>ProductCode</XNam>
	        <XVal>$PRODUCT_CODE</XVal>
	</Ext>
        </General>
        <Service>
                <Name>SyncML</Name>
                <UUID>SYNCML-SYNC</UUID>
                <Version>1.1</Version>
                <Object>
                        <Type>application/vnd.syncml+wbxml</Type>
                </Object>
        </Service>
        <Service>
                <Name>PCCS</Name>
                <UUID>F9EC7BC4-953c-11d2-984E-525400DC9E09</UUID>
                <Version>1.5</Version>
        </Service>
        <Service>
                <Name>PCSuite-Settings</Name>
                <Version>1.0</Version>
                <Ext>
                        <XNam>SuiteConf</XNam>
                        <XVal>File=.settings\SuiteConf.xml</XVal>
                </Ext>
        </Service>
        <Service>
		<Name>Folder-Browsing</Name>
		<UUID>F9EC7BC4-953c-11d2-984E-525400DC9E09</UUID>
		<Version>1.3</Version>
		<Object>
			<Type>x-obex/folder-listing</Type>
		</Object>
		<Ext>
			<XNam>Images</XNam>
			<XVal>Folder=Data\</XVal>
			<XVal>MemType=DEV</XVal>
		</Ext>
		<Ext>
			<XNam>Videos</XNam>
			<XVal>Folder=Data\</XVal>
			<XVal>MemType=DEV</XVal>
		</Ext>
		<Ext>
			<XNam>Music</XNam>
			<XVal>Folder=Data\</XVal>
			<XVal>MemType=DEV</XVal>
		</Ext>
		<Ext>
			<XNam>Graphics</XNam>
			<XVal>Folder=Data\</XVal>
			<XVal>MemType=DEV</XVal>
		</Ext>
	</Service>
        <Service>
                <Name>Text Messages</Name>
		<UUID>SYNCML-SYNC</UUID>
                <Version>1000.0</Version>
                <Object>
                        <Type>text/x-vMessage</Type>
                        <Name-Ext>sms</Name-Ext>
                </Object>
                <Ext>
                        <XNam>SyncProfile</XNam>
                        <XVal>HostAddress=PC Suite Data Sync</XVal>
                        <XVal>Database=sms</XVal>
                </Ext>
                <Ext>
                        <XNam>Databases</XNam>
                        <XVal>Drafts=./4097/4100/</XVal>
                        <XVal>Inbox=./4097/4098/</XVal>
                        <XVal>Outbox=./4097/4099/</XVal>
                        <XVal>SentItems=./4097/4101/</XVal>
                </Ext>
        </Service>
</Capability>
END
}

# Function to initialize following variables IMEI, VERSION, FREE, USED
#param None
#return None
init_values()
{
	IMEI_NO=`dbus-send --system --print-reply --dest=com.nokia.csd /com/nokia/csd/info com.nokia.csd.Info.GetIMEINumber | grep string | cut -d'"' -f2`
	if test -z "$IMEI_NO"
	then
	    # Temporary (?) modem problem, try again later
	    exit 2
	fi
	if test -z "$OSSO_VERSION" ; then
	    VERSION=`osso-product-info -q OSSO_VERSION`
	else
	    VERSION=$OSSO_VERSION
	fi
	PRODUCT_CODE=`sysinfo-tool --get /device/product-code`
	df_out=`df -k`
	DEVM_USED_K=`echo "$df_out" | awk -v d="$MYDOCSDIR" 'NR > 1 && $6 == d { print $3;}'`
	DEVM_FREE_K=`echo "$df_out" | awk -v d="$MYDOCSDIR" 'NR > 1 && $6 == d { print $4;}'`
	MMC_USED_K=`echo "$df_out" | awk -v d="$MMC_DIR" 'NR > 1 && $6 == d { print $3;}'`
	MMC_FREE_K=`echo "$df_out" | awk -v d="$MMC_DIR" 'NR > 1 && $6 == d { print $4;}'`

        #using perl to multiply to bytes
        #multiplication has to support large numbers
	if test -n "$DEVM_USED_K"
	then
	    DEVM_USED=`perl -e "print 1024*$DEVM_USED_K"`
	fi
	if test -n "$DEVM_FREE_K"
	then
	    DEVM_FREE=`perl -e "print 1024*$DEVM_FREE_K"`
	fi
	if test -n "$MMC_USED_K"
	then
	    MMC_USED=`perl -e "print 1024*$MMC_USED_K"`
	fi
	if test -n "$MMC_FREE_K"
	then
	    MMC_FREE=`perl -e "print 1024*$MMC_FREE_K"`
	fi

	CSD_NET=`dbus-send --system --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_registration_status | grep uint32`
	OPERATOR_COUNTRY_CODE=`echo -e $CSD_NET | awk 'NR < 2{ print $6 }' `
	OPERATOR_NETWORK_ID=`echo -e $CSD_NET | awk 'NR < 2{ print $4 }'`
	NETWORK_ID=$OPERATOR_NETWORK_ID
	# strip leading zero
	NETWORK_ID_STRIPPED=`echo $NETWORK_ID | sed 's/0*//'`
	# expand to three characters
	if [ `expr length $OPERATOR_NETWORK_ID` -eq 1 ]; then
		NETWORK_ID=00$OPERATOR_NETWORK_ID
	elif [ `expr length $OPERATOR_NETWORK_ID` -eq 2 ]; then
		NETWORK_ID=0$OPERATOR_NETWORK_ID
	fi
	OPERATOR_NAME=`dbus-send --system --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_operator_name byte:0 uint32:$OPERATOR_NETWORK_ID_STRIPPED uint32:$OPERATOR_COUNTRY_CODE | grep string | cut -d'"' -f2`
}



# Function to check if file has changed and if yes then update the same
#param None
#return None
check_capability_file_diff()
{
init_values
get_capability | tee  $TMP_CAPABILITY_FILE
if ! cmp -s "$TMP_CAPABILITY_FILE" "$CAPABILITY_FILE" ; then
	cp "$TMP_CAPABILITY_FILE" "$CAPABILITY_FILE".new &&
	mv "$CAPABILITY_FILE".new "$CAPABILITY_FILE" &&
	rm "$TMP_CAPABILITY_FILE"
fi	
}

check_suiteconf_file_diff()
{
if ! cmp -s "$INSTALLED_SUITECONF_FILE" "$SUITECONF_FILE" ; then
	cp "$INSTALLED_SUITECONF_FILE" "$SUITECONF_FILE".new &&
	mv "$SUITECONF_FILE".new "$SUITECONF_FILE" 
fi	
}

#check cached capability file already exists or not
if [ -f "$CAPABILITY_FILE" ]; then
        check_capability_file_diff 
else
	mkdir -p "$MAESYNC_DIR"
	init_values
	get_capability | tee $TMP_CAPABILITY_FILE
	cp "$TMP_CAPABILITY_FILE" "$CAPABILITY_FILE".new &&
	mv "$CAPABILITY_FILE".new "$CAPABILITY_FILE" &&
	rm "$TMP_CAPABILITY_FILE"
fi

if [  -f "$SUITECONF_FILE" ]; then
	check_suiteconf_file_diff
else
	cp "$INSTALLED_SUITECONF_FILE" "$SUITECONF_FILE".new &&
	mv "$SUITECONF_FILE".new "$SUITECONF_FILE" 
fi

exit 0

