/**
 * @file osso_fm_moveto.h
 *
 * This file contains routines for copy, move and delete operations 
 *
 * Copyright (C) 2005 Nokia Corporation
 */

#ifndef __MOVE_TO_H__
#define __MOVE_TO_H__

#include "osso_fm_utils.h"

#define SHORTEN_DIALOG_LENGTH MAX_PATH_LENGTH

typedef enum {
	STTS_OK = 0,
	STTS_MEMORY_ERR = -1,
	STTS_TGT_IN_SRC = -2,
	STTS_TGT_REPLACES_SRC = -3
} SrcToTgtStatus;

typedef struct {
	GList *source_list;
	GList *source_dir_list;
	GList *target_list;
	GList *target_dir_list;
	GList *long_names;
}XferCBDataFileLists;
typedef struct {
	gchar *button_text1;
	gchar *button_text2;
	gchar *final_result_text;
	gchar *final_result_note_button_text;
	gint final_result_show_type;
}XferCBDataResult;
typedef struct {
	gint errors;
	gint skipped;
	gint existing;
	gint non_existant;
	gint in_use;
} XferCBDataErrItemsCounts;
	
typedef struct {
	GnomeVFSAsyncHandle *async_handle;
	GtkWidget *status_window;
	GtkWidget *window;
	GtkProgressBar *progress_bar;
	gchar *progress_verb;
	XferCBDataResult res;
	XferCBDataErrItemsCounts item_counts;
	gint replace_query_status;	//-1 not yet queried 0 no 1 yes
	glong source_size;

	XferCBDataFileLists detlists;
	GList *partial_copied_file;
	GList *locked_files;
	GTimeVal prev_upd_time;
	gint last_index;
	gint prev_progress;
	TransferAction action;
	gboolean delete_sources;
	GTimer *watchdog_timer;
} XferCallbackData;

/*  
 * gint backup_started;
 * 1 backup started (any writes should be aborted)
 * 0 no back is happening can proced
*/
extern gint backup_started;

void xfer_init(XferCallbackData * cdata, GtkWindow * mainwindow);

void xfer_cleanup(XferCallbackData ** cdata);

void create_error_dialog(XferCallbackData * cdata);

void create_replace_dialog(XferCallbackData * cdata);


void xfer_uri(GList * source_uri_list,
	      GList * target_uri_list,
	      gpointer mainwindow, 
	      TransferAction oper, gint skippedfiles, gint non_existant, gboolean non_recursive);

void delete_uri(GList * uri_list, gpointer mainwindow);


SrcToTgtStatus check_source_to_target(GSList * sourceselection, GtkFilePath * targetpath);
gboolean match_parents_path(GSList * sourceselection, GtkFilePath * targetpath);

void
xfer_set_final_error_text(XferCallbackData * cdata, gint show_type,
			  gboolean reset_error, gchar * err_text, gchar * button_text);

#endif				//__MOVE_TO_H__
