/**
 * @file  osso_fm_support.c
 *
 * This file contains the header for support functions for filemanager
 *
 * Copyright (C) 2005 Nokia Corporation
 */


#include "osso_fm_generic.h"
#include "osso_fm_support.h"

/**
* Method to get the hooked widget from a widget.
* 
* @param widget is the widget to look upon 
* @param widget_name is name by which widget is looked
* 
* @return GtkWidget
*/
GtkWidget *lookup_widget(GtkWidget * widget, const gchar * widget_name)
{
	GtkWidget *found_widget = NULL;
	found_widget = (GtkWidget *) g_object_get_data(G_OBJECT(widget), widget_name);
	if (!found_widget)
		g_warning("Widget not found: %s", widget_name);
	return found_widget;
}

