/**
 * @file osso_fm_moveto.h
 *
 * This file contains routines for copy, move and delete operations 
 *
 * Copyright (C) 2005 Nokia Corporation
 */

#ifndef __OPERATIONS_H__
#define __OPERATIONS_H__

//BEG: New Folder related functions
/**
Creates a New Folder in the path specified.
@param window 	Pointer to the application main window.
@param path 	Represents the path where the New Folder is created.
@return void
*/
void create_new_folder(OSSOFileManager* ofm, GtkFilePath * path);

/**
   Invoked when a new folder options is selected from File Manager menu.
   @param window 	Pointer to the application's main window.
   @return void
*/
gboolean osso_fm_new_folder(OSSOFileManager* ofm, gboolean menucheck);


//END: New Folder related functions

//BEG: Rename related functions


/**
   Method to rename source path to target path..

   @param mainwindow Main file manager window
   @param sourcepath source path
   @param targetpath target path
   @return void
*/
gboolean
osso_fm_rename_path(GtkWidget * mainwindow, const gchar * sourcepath, const gchar * targetpath);

/**
   Rename operation is done.

   @param mainwindow : pointer to Main Window
   @param oldname  Old name which is to be renamed
   @param newname  The New name
   @return void
*/
gboolean
on_rename_dialog_okbutton_clicked(GtkWidget * mainwindow,
				  const gchar * oldname, const gchar * newname);

/**
   Method to create the Rename dialog
 
   @param mainwindow Main window pointer
   @param oldname oldname that needs to be renamed
*/
void osso_create_rename_dialog(GtkWidget * mainwindow, gchar * oldname);

gboolean osso_fm_rename_activate (OSSOFileManager *ofm, gboolean menucheck);

gboolean osso_fm_format_activate (OSSOFileManager *ofm, gboolean menucheck);

//END: Rename related functions



//BEG: Delete related functions

/**
 *  Validates the selection type  and creates
 *  the delete confirmation dialog
 *  
 * @param window Pointer to application window
 */

gboolean osso_fm_delete_activate(OSSOFileManager *ofm, gboolean menucheck);

//END: Delete related functions


//BEG: Sort Dialog related functions

/*
#define STR_SORTING_ORDER_ASCENDING _("ckdg_va_sort_ascending")
#define STR_SORTING_ORDER_DESCENDING _("ckdg_va_sort_descending")
*/


/**
* Method to invoke the sortdialog.
* 
* @param parent Main file manager window
* 
* @return void
*/
void sort_dialog(GtkWindow * parent);

//END: Sort Dialog related functions


//BEG: MoveTo Dialog related functions

void create_move_to_dialog(GtkWindow * window, HildonFileSelection * sourcefs);

//END: MoveTo Dialog related functions

#endif				//__OPERATIONS_H__
