/**
 * @file  osso_fm_main.c
 *
 * The main file of filemanager application.
 *
 * Copyright (C) 2005 Nokia Corporation
 */


/* Includes */
#include "osso_fm_generic.h"
#include "osso_fm_controller.h"
#include "osso_fm_callbacks.h"
#include "osso_fm_fmstate.h"
#include "osso_fm_utils.h"
#include <signal.h>
#include <dbus/dbus-glib.h>

//#include "osso_fm_fmstate.h"
gboolean fm_loading;
FILE *fp;
//HildonFileSystemModel *fsmodel = NULL;
clock_t start = 0;
clock_t end = 0;
FMToolbar * create_toolbar(OSSOFileManager* ofm);

/**
 * osso_fm_create_main_window:
 * This functions creates the main window(HildonApp) with the view(HildonAppView)
 * Attaches the toolbar to the app. This function updates the OSSOFileManager structure
 * the pointer to the app view and the toolbar.
 * 
 * @param fm pointer to OSSOFileManager
 * @return gboolean TRUE if successful FALSE in case of error
 */
gboolean osso_fm_create_main_window(OSSOFileManager *ofm)
{
	DEBUG_PRINT_START;

	ofm->prog = hildon_program_get_instance ();
	ofm->window = HILDON_WINDOW (hildon_window_new ());
	hildon_program_add_window (ofm->prog, ofm->window);
	
	gtk_window_set_title (GTK_WINDOW (ofm->window),
			      _("sfil_ap_file_manager"));
	
	FM_ULOG_INFO("App and View Created\n");
	ofm->fmtoolbar = create_toolbar(ofm);
	if (ofm->fmtoolbar != NULL) {
		hildon_window_add_toolbar (ofm->window,
					   ofm->fmtoolbar->toolbar);
	}
	FM_ULOG_INFO("ToolBar Created and attached\n");
	g_object_set(G_OBJECT(global_ofm->fmtoolbar->toolbar),
			 "visible", FALSE, NULL);
	gtk_widget_show_now((GtkWidget *) ofm->window);
	gtk_widget_show((GtkWidget *) ofm->window);
	g_signal_connect(G_OBJECT(ofm->window), "delete-event",
			 G_CALLBACK(fm_application_destroy_cb), NULL);
	DEBUG_PRINT_END;
	return TRUE;
}

/**
 * create_file_selection:
 * Method to create fileselection widget and set its properities.
 * @param ofm pointer to OSSOFileManager structute.
 * @return gboolean TRUE if successful FALSE in case of error
 */
gboolean create_file_selection(OSSOFileManager *ofm)
{
	HildonFileSelection *fs = NULL;
	HildonFileSystemModel *fsmodel = NULL;

	if (ofm->fs != NULL) {
		return FALSE;
	}

	fsmodel = g_object_new (HILDON_TYPE_FILE_SYSTEM_MODEL,
				"ref-widget", ofm->window,
				NULL);
	if (fsmodel == NULL) {
		FM_ULOG_ERR("Err:create_file_selection:fsmodel = NULL\n");
		return FALSE;
	}
	fs = g_object_new(HILDON_TYPE_FILE_SELECTION, "model", fsmodel, "drag-enabled", TRUE, NULL);
	if (fs == NULL) {
		FM_ULOG_ERR("Err:create_file_selection:fs = NULL\n");
		return FALSE;
	}
	/* enabling column header in Fileselection widget */
	hildon_file_selection_set_column_headers_visible(fs, TRUE);

	gtk_container_add(GTK_CONTAINER(ofm->window), GTK_WIDGET(fs));
	//HOOKUP_OBJECT(ofm->app, (GtkWidget *) fs, "FileSelection");// TODO LEGEACY
	ofm->fs=fs;
	g_object_get(fsmodel,"backend-object",&ofm->gtkfilesystem,NULL);
	if(ofm->gtkfilesystem == NULL)
	{
		FM_ULOG_ERR("ERROR getting GtkFileSystem from FSW\n");
		return FALSE;
	}

	update_fm_title((GtkWidget *) fs, ofm->window);
	GTK_WIDGET_UNSET_FLAGS(fs, GTK_CAN_FOCUS);
	gtk_widget_show_now((GtkWidget *) fs);

	return TRUE;
}

OSSOFileManager *global_ofm;
gboolean fm_closing;
/**
* main:
* @param argc is Number of command line arguments.
* @param argv is Command line argument strings.
* return gint 
*/
gint main(int argc, char *argv[])
{
	OSSOFileManager *ofm = NULL;
	gint timer_handler = 0;
	DBusConnection *sess_bus = NULL;
	gchar *match_rule = NULL;
	fm_closing = FALSE;
	//g_thread_init(NULL);
	if(!g_thread_supported()) {
		g_thread_init(NULL);
	}
	dbus_g_thread_init();
	gdk_threads_init(); 
	gdk_threads_enter();
	      

	ofm = g_new0(OSSOFileManager,1);//TODO should be replaced with gobject new
	global_ofm = ofm;
	if(ofm == NULL)
	{
		FM_ULOG_ERR("Error Creating OSSOFileManager\n");
		return -1;
	}
	start = clock();
	//This part of the program sponsered by Application Framework
	fm_app_ctx = NULL;
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);
	ofm->keyfile = NULL;

	g_set_application_name(_("sfil_ap_file_manager"));

	fm_app_ctx = osso_fm_initialize(APP_NAME, APP_VER, TRUE, NULL);
	if (fm_app_ctx == NULL) {
		FM_ULOG_ERR("%s: Failed to initialize context\n", APP_NAME);
		//return 1;
	} else {
		//FM_ULOG_DEBUG1("%s", "FM OSSO Initialise successful\n");
		if (osso_rpc_set_default_cb_f(fm_app_ctx,
					      osso_fm_rpc_callback_handler, NULL) != OSSO_OK) {
			FM_ULOG_ERR(" File Manager rpc cb register failed ..");
			osso_deinitialize(fm_app_ctx);
		}
		sess_bus = osso_get_dbus_connection(fm_app_ctx);
		match_rule = g_strdup_printf("type='signal', interface='com.nokia.backup'");
		dbus_bus_add_match(sess_bus, match_rule, NULL);
		dbus_connection_add_filter(sess_bus, backup_signal_cb, NULL, NULL);
		dbus_connection_flush(sess_bus);
		g_free(match_rule);
	}
	FM_ULOG_INFO("OSSO Context Init Successful\n");

	/**
	* initialize everything needed to operate the toolkit 
	* and parses some standard command line options
	*/
	gtk_init(&argc, &argv);
	fm_loading=TRUE;
	FM_ULOG_INFO("Gtk Initilized\n");
	ofm->si = g_new0(SelectionInfo,1);
	selection_info_init(ofm->si);
	//Creating main window
	if(!osso_fm_create_main_window(ofm)) {
		FM_ULOG_ERR("main:Error creating main window\n");
		return 1;
	}
	global_ofm->cur_operation = OPER_NONE;
	timer_handler = gtk_timeout_add(APP_STARTUP_TIMER_SPEED, on_fm_timer, ofm);
	end = clock();

	signal(SIGINT, on_fm_exit_signal);
	/* Runs the main loop */
	FM_ULOG_INFO("Entering Gtk Main Loop\n");
	gtk_main();

	gtk_timeout_remove(timer_handler);

	osso_fm_save_key_file();
	osso_fm_close_key_file();

	gdk_threads_leave();
	FM_ULOG_DEBUG1("Closed");

	/* osso fm context deinitalize */
	osso_fm_deinitialize(fm_app_ctx);
	LOG_CLOSE();

	DEBUG_PRINT_END;
	return 0;
}



/** 
 * create_toolbar:
 * This function creates the toolbar adds the buttons and connets the signal handlers
 * to the toolbar buttons. This fills the FMToolbar Structure and returns it.
 *
 * @param app - pointer to the OSSOFileManager
 *
 * @returns pointer to the FMToolbar structure
*/
FMToolbar * create_toolbar(OSSOFileManager* ofm)
{
	FMToolbar *fmtb = NULL;

	GtkWidget *image = NULL;
	GtkToolItem *button = NULL;
	GtkToolItem *vseparator = NULL;
	GtkToolItem *showlist = NULL;
	GtkToolItem *showthumbnail = NULL;
	gint left_margin = 0;
	gint right_margin = 0;
	gint button_gap = 0;
	GSList *listgroup = NULL;
	
	fmtb = g_new0(FMToolbar,1);

	left_margin = TOOLBAR_LEFT_MARGIN;
	right_margin = TOOLBAR_RIGHT_MARGIN;
	button_gap = TOOLBAR_MARGIN_BTW_BUTTONS;

	fmtb->toolbar = (GtkToolbar *) gtk_toolbar_new();
	gtk_toolbar_set_style((GtkToolbar *) fmtb->toolbar, GTK_ORIENTATION_HORIZONTAL);
	GTK_WIDGET_UNSET_FLAGS(fmtb->toolbar, GTK_CAN_FOCUS);	

	/*alignment = (GtkAlignment *) gtk_alignment_new(1, 1, 1, 1);
	GTK_WIDGET_UNSET_FLAGS(alignment, GTK_CAN_FOCUS);
	gtk_alignment_set_padding(alignment, 0, 0, left_margin, right_margin);
	gtk_container_add((GtkContainer *) fmtb->toolbar, (GtkWidget *) alignment);


	hbox1 = gtk_hbox_new(TRUE, button_gap);
	GTK_WIDGET_UNSET_FLAGS(hbox1, GTK_CAN_FOCUS);
	gtk_container_add((GtkContainer *) alignment, hbox1);*/

	image = gtk_image_new_from_icon_name("qgn_toolb_gene_findbutton", HILDON_ICON_SIZE_TOOLBAR);
	button = gtk_tool_button_new(image, NULL);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(on_toolbar_find_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) button, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, button,-1);
	gtk_tool_item_set_expand(button,TRUE);
	fmtb->find_button=button;

	image = gtk_image_new_from_icon_name("qgn_toolb_gene_newfldrbutton", HILDON_ICON_SIZE_TOOLBAR);
	button = gtk_tool_button_new(image, NULL);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(on_toolbar_newfolder_clicked), (gpointer) ofm);
	g_signal_connect(G_OBJECT(button), "insensitive_press",
			 G_CALLBACK(on_toolbar_newfolder_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) button, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, button,-1);
	gtk_tool_item_set_expand(button,TRUE);
	fmtb->new_button=button;

	image = gtk_image_new_from_icon_name("qgn_toolb_gene_movetofldr", HILDON_ICON_SIZE_TOOLBAR);
	button = gtk_tool_button_new(image, NULL);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(on_toolbar_moveto_clicked), (gpointer) ofm);
	g_signal_connect(G_OBJECT(button), "insensitive_press",
			 G_CALLBACK(on_toolbar_moveto_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) button, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, button,-1);
	gtk_tool_item_set_expand(button,TRUE);
	fmtb->moveto_button=button;


	image = gtk_image_new_from_icon_name("qgn_toolb_gene_detailsbutton", HILDON_ICON_SIZE_TOOLBAR);
	button = gtk_tool_button_new(image, NULL);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(on_toolbar_detail_clicked), (gpointer) ofm);
	g_signal_connect(G_OBJECT(button), "insensitive_press",
			 G_CALLBACK(on_toolbar_detail_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) button, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, button,-1);
	gtk_tool_item_set_expand(button,TRUE);
	fmtb->details_button=button;

	image = gtk_image_new_from_icon_name("qgn_toolb_gene_deletebutton", HILDON_ICON_SIZE_TOOLBAR);
	button = gtk_tool_button_new(image, NULL);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(on_toolbar_delete_clicked), (gpointer) ofm);
	g_signal_connect(G_OBJECT(button), "insensitive_press",
			 G_CALLBACK(on_toolbar_delete_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) button, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, button,-1);
	gtk_tool_item_set_expand(button,TRUE);
	fmtb->delete_button=button;

	vseparator = gtk_separator_tool_item_new();
	gtk_toolbar_insert(fmtb->toolbar, vseparator,-1);
	gtk_tool_item_set_expand(vseparator,TRUE);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) vseparator, FALSE, FALSE, 0);

	image = gtk_image_new_from_icon_name("qgn_toolb_filemanager_listview", HILDON_ICON_SIZE_TOOLBAR);
	showlist = gtk_radio_tool_button_new(NULL);
	GTK_WIDGET_UNSET_FLAGS(showlist, GTK_CAN_FOCUS);
	gtk_tool_button_set_icon_widget((GtkToolButton *) showlist, image);
	g_signal_connect(G_OBJECT(showlist), "clicked",
			 G_CALLBACK(on_toolbar_listview_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) showlist, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, showlist,-1);
	gtk_tool_item_set_expand(showlist,TRUE);
	fmtb->listview_button=showlist;


	image = gtk_image_new_from_icon_name("qgn_toolb_filemanager_thumbnailview",
					     HILDON_ICON_SIZE_TOOLBAR);
	listgroup = gtk_radio_tool_button_get_group((GtkRadioToolButton *) showlist);
	showthumbnail = gtk_radio_tool_button_new_from_widget(GTK_RADIO_TOOL_BUTTON(showlist));
	GTK_WIDGET_UNSET_FLAGS(showthumbnail, GTK_CAN_FOCUS);

	gtk_tool_button_set_icon_widget((GtkToolButton *) showthumbnail, image);
	g_signal_connect(G_OBJECT(showthumbnail), "clicked",
			 G_CALLBACK(on_toolbar_thumbview_clicked), (gpointer) ofm);
	//gtk_box_pack_start(GTK_BOX(hbox1), (GtkWidget *) showthumbnail, FALSE, FALSE, 0);
	gtk_toolbar_insert(fmtb->toolbar, showthumbnail,-1);
	gtk_tool_item_set_expand(showthumbnail,TRUE);
	fmtb->thumbview_button=showthumbnail;
	g_object_ref(fmtb->toolbar);
	return fmtb;
}


OSSOFileManager *osso_file_manager_init()
{
	OSSOFileManager *ofm = NULL;
	//ofm = g_new0(OSSOFileManager,1);
	return ofm;
}

//NEW CODE BEGINS

/**
 * osso_fm_create_main_menu:
 * This function creates the main menu.
 *
 * @param app  - Pointer to the HildonApp
 * @param view - Pointer to the HildonAppView
 * @param fs   - File selection widget, pointer to the HildonFileSelection
 *
 * @return GtkWidget representing the main menu
 */

static void
add_ctrl_shortcut (GtkWidget *item, GtkAccelGroup *accel_group,
		   guint key)
{
  gtk_widget_add_accelerator (item, "activate",
			      accel_group,
			      key, GDK_CONTROL_MASK,
			      GTK_ACCEL_VISIBLE);
}

static void
add_shortcut (GtkWidget *item, GtkAccelGroup *accel_group,
	      guint key)
{
  gtk_widget_add_accelerator (item, "activate",
			      accel_group,
			      key, 0,
			      GTK_ACCEL_VISIBLE);
}

FMMainMenu *
osso_fm_create_main_menu (HildonProgram *prog, HildonWindow *window,
			  HildonFileSelection *fs)
{
        GtkAccelGroup *accel_group;
	GSList *menu_view_list_group = NULL;
	FMMainMenu *fmmm = NULL;

	accel_group = gtk_accel_group_new ();
	gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

	fmmm = g_new0(FMMainMenu,1);
	fmmm->file = g_new0(FMMenuFile,1);
	fmmm->edit = g_new0(FMMenuEdit,1);
	fmmm->view = g_new0(FMMenuView,1);
	fmmm->tools = g_new0(FMMenuTools,1);

	fmmm->self = gtk_menu_new ();
	fmmm->file->self = gtk_menu_item_new_with_label(_("hfil_me_file"));
	gtk_menu_append(fmmm->self, fmmm->file->self);
	fmmm->file->menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmmm->file->self), fmmm->file->menu);
	g_signal_connect((gpointer) fmmm->file->self, "activate",
			 G_CALLBACK(refresh_file_menu_items), (gpointer) global_ofm);

	fmmm->file->new_folder = gtk_menu_item_new_with_label(_("hfil_me_new_folder"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->new_folder);
	g_signal_connect((gpointer) fmmm->file->new_folder, "activate",
			 G_CALLBACK(on_menu_file_new_folder_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->new_folder, "insensitive_press",
			 G_CALLBACK(on_menu_file_new_folder_activate), (gpointer) global_ofm);
	add_ctrl_shortcut (fmmm->file->new_folder, accel_group, 'n');
	
	fmmm->file->open = gtk_menu_item_new_with_label(_("hfil_me_open"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->open);
	g_signal_connect((gpointer) fmmm->file->open, "activate",
			 G_CALLBACK(on_menu_file_open_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->open, "insensitive_press",
			 G_CALLBACK(on_menu_file_open_activate), (gpointer) global_ofm);

	fmmm->file->rename = gtk_menu_item_new_with_label(_("hfil_me_rename"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->rename);
	g_signal_connect((gpointer) fmmm->file->rename, "activate",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);
	g_signal_connect((gpointer) fmmm->file->rename, "insensitive_press",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);

	fmmm->file->delete = gtk_menu_item_new_with_label(_("hfil_me_delete"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->delete);
	g_signal_connect((gpointer) fmmm->file->delete, "activate",
			 G_CALLBACK(on_menu_file_delete_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->delete, "insensitive_press",
			 G_CALLBACK(on_menu_file_delete_activate), (gpointer) global_ofm);
	add_shortcut (fmmm->file->delete, accel_group, GDK_BackSpace);

	fmmm->file->separator1 = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->file->menu), fmmm->file->separator1);
	gtk_widget_set_sensitive(fmmm->file->separator1, FALSE);
	
	fmmm->file->send = gtk_menu_item_new_with_label(_("hfil_me_send_files"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->send);
	fmmm->file->send_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmmm->file->send), fmmm->file->send_menu);

	fmmm->file->send_as_email = gtk_menu_item_new_with_label(_("hfil_me_send_email"));
	gtk_menu_append(fmmm->file->send_menu, fmmm->file->send_as_email);
	g_signal_connect((gpointer) fmmm->file->send_as_email, "activate",
			 G_CALLBACK(on_menu_send_as_email_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->send_as_email, "insensitive_press",
			 G_CALLBACK(on_menu_send_as_email_activate), (gpointer) global_ofm);
	fmmm->file->send_via_bluetooth = gtk_menu_item_new_with_label(_("hfil_me_send_bluetooth"));
	gtk_menu_append(fmmm->file->send_menu, fmmm->file->send_via_bluetooth);
	g_signal_connect((gpointer) fmmm->file->send_via_bluetooth,  "activate",
		G_CALLBACK(on_menu_send_via_bluetooth_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->send_via_bluetooth,  "insensitive_press",
		G_CALLBACK(on_menu_send_via_bluetooth_activate), (gpointer) global_ofm);
	fmmm->file->details = gtk_menu_item_new_with_label(_("hfil_me_details"));
	gtk_menu_append(fmmm->file->menu, fmmm->file->details);
	g_signal_connect((gpointer) fmmm->file->details, "activate",
			 G_CALLBACK(on_menu_details_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->file->details, "insensitive_press",
			 G_CALLBACK(on_menu_details_activate), (gpointer) global_ofm);

	fmmm->edit->self = gtk_menu_item_new_with_label(_("hfil_me_edit"));
	gtk_menu_append(fmmm->self,fmmm->edit->self);
	fmmm->edit->menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmmm->edit->self),fmmm->edit->menu);
	g_signal_connect((gpointer) fmmm->edit->self, "activate",
			 G_CALLBACK(refresh_edit_menu_items), (gpointer) global_ofm);

	fmmm->edit->cut = gtk_menu_item_new_with_label(_("hfil_me_cut"));
	gtk_menu_append(fmmm->edit->menu, fmmm->edit->cut);
	g_signal_connect((gpointer) fmmm->edit->cut, "activate",
			 G_CALLBACK(on_menu_edit_cut_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->edit->cut, "insensitive_press",
			 G_CALLBACK(on_menu_edit_cut_activate), (gpointer) global_ofm);
	add_ctrl_shortcut (fmmm->edit->cut, accel_group, 'x');

	fmmm->edit->copy = gtk_menu_item_new_with_label(_("hfil_me_copy"));
	gtk_menu_append(fmmm->edit->menu, fmmm->edit->copy);
	g_signal_connect((gpointer) fmmm->edit->copy, "activate",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->edit->copy, "insensitive_press",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);
	add_ctrl_shortcut (fmmm->edit->copy, accel_group, 'c');

	fmmm->edit->paste = gtk_menu_item_new_with_label(_("hfil_me_paste"));
	gtk_menu_append(fmmm->edit->menu, fmmm->edit->paste);
	g_signal_connect((gpointer) fmmm->edit->paste, "activate",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->edit->paste, "insensitive_press",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);
	add_ctrl_shortcut (fmmm->edit->paste, accel_group, 'v');

	fmmm->edit->select_all = gtk_menu_item_new_with_label(_("hfil_me_select_all"));
	gtk_menu_append(fmmm->edit->menu, fmmm->edit->select_all);
	g_signal_connect((gpointer) fmmm->edit->select_all, "activate",
			 G_CALLBACK(on_menu_mark_all_activate), (gpointer) fs);
	g_signal_connect((gpointer) fmmm->edit->select_all, "insensitive_press",
			 G_CALLBACK(on_menu_mark_all_activate), (gpointer) fs);
	add_ctrl_shortcut (fmmm->edit->select_all, accel_group, 'a');

	fmmm->edit->separator1= gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->edit->menu), fmmm->edit->separator1);
	gtk_widget_set_sensitive(fmmm->edit->separator1, FALSE);

	fmmm->edit->move_to = gtk_menu_item_new_with_label(_("hfil_me_move_to"));
	gtk_menu_append(fmmm->edit->menu,fmmm->edit->move_to);
	g_signal_connect((gpointer) fmmm->edit->move_to, "activate",
			 G_CALLBACK(on_menu_move_to_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->edit->move_to, "insensitive_press",
			 G_CALLBACK(on_menu_move_to_activate), (gpointer) global_ofm);

	fmmm->edit->duplicate = gtk_menu_item_new_with_label(_("hfil_me_duplicate"));
	gtk_menu_append(fmmm->edit->menu, fmmm->edit->duplicate);
	g_signal_connect((gpointer) fmmm->edit->duplicate, "activate",
			 G_CALLBACK(on_menu_duplicate_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmmm->edit->duplicate, "insensitive_press",
			 G_CALLBACK(on_menu_duplicate_activate), (gpointer) global_ofm);

	fmmm->view->self = gtk_menu_item_new_with_label(_("hfil_me_view"));
	gtk_menu_append(fmmm->self,fmmm->view->self);
	fmmm->view->menu = gtk_menu_new();
	gtk_menu_item_set_submenu((GtkMenuItem *) fmmm->view->self, (GtkWidget *)fmmm->view->menu);
	g_signal_connect((gpointer) fmmm->view->self, "activate",
			 G_CALLBACK(refresh_view_menu_items), (gpointer) global_ofm);

	fmmm->view->list =
	    gtk_radio_menu_item_new_with_label(menu_view_list_group, _("hfil_me_list_view"));
	menu_view_list_group = gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmmm->view->list));
	gtk_menu_append(fmmm->view->menu, fmmm->view->list);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *) fmmm->view->list, TRUE);

	g_signal_connect((gpointer) fmmm->view->list, "activate",
			 G_CALLBACK(on_menu_view_list_activate), (gpointer) global_ofm);

	fmmm->view->thumbnail =
	    gtk_radio_menu_item_new_with_label(menu_view_list_group, _("hfil_me_thumbnail_view"));
	menu_view_list_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmmm->view->thumbnail));
	gtk_menu_append(fmmm->view->menu, fmmm->view->thumbnail);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *) fmmm->view->thumbnail, FALSE);

	g_signal_connect((gpointer) fmmm->view->thumbnail, "activate",
			 G_CALLBACK(on_menu_view_thumbnail_activate), (gpointer) global_ofm);

	fmmm->view->separator1 = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->view->menu), fmmm->view->separator1);
	gtk_widget_set_sensitive(fmmm->view->separator1, FALSE);

	fmmm->view->sort = gtk_menu_item_new_with_label(_("hfil_me_sort"));
	gtk_menu_append(fmmm->view->menu, fmmm->view->sort);
	g_signal_connect((gpointer) fmmm->view->sort, "activate",
			 G_CALLBACK(on_menu_sort_activate), (gpointer) fs);
	g_signal_connect((gpointer) fmmm->view->sort, "insensitive_press",
			 G_CALLBACK(on_menu_sort_activate), (gpointer) fs);

	fmmm->view->separator2 = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->view->menu), fmmm->view->separator2);
	gtk_widget_set_sensitive(fmmm->view->separator2, FALSE);

	fmmm->view->full_screen = gtk_check_menu_item_new_with_label(_("hfil_me_optimized"));
	gtk_container_add(GTK_CONTAINER(fmmm->view->menu), fmmm->view->full_screen);

	fmmm->view->separator3 = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->view->menu), fmmm->view->separator3);
	gtk_widget_set_sensitive(fmmm->view->separator3, FALSE);

	fmmm->view->show_tool_bar = gtk_menu_item_new_with_label(_("hfil_me_show_toolbar"));
	gtk_menu_append(fmmm->view->menu, fmmm->view->show_tool_bar);

	fmmm->view->show_tool_bar_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmmm->view->show_tool_bar), fmmm->view->show_tool_bar_menu);
	fmmm->view->normal_mode = gtk_check_menu_item_new_with_mnemonic(_("hfil_me_toolbar_normal_mode"));
	gtk_menu_append(fmmm->view->show_tool_bar_menu, fmmm->view->normal_mode);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *) fmmm->view->normal_mode, TRUE);

	fmmm->view->fullscreen_mode =
	    gtk_check_menu_item_new_with_mnemonic(_("hfil_me_toolbar_optimized"));
	gtk_check_menu_item_set_active((GtkCheckMenuItem *) fmmm->view->fullscreen_mode, TRUE);
	gtk_menu_append(fmmm->view->show_tool_bar_menu, fmmm->view->fullscreen_mode);
	
	fmmm->tools->self = gtk_menu_item_new_with_label(_("hfil_me_tools"));
	gtk_menu_append(fmmm->self, fmmm->tools->self);
	fmmm->tools->menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmmm->tools->self), fmmm->tools->menu);

	fmmm->tools->back_up_restore = gtk_menu_item_new_with_label(_("hfil_me_back_up"));
	gtk_menu_append(fmmm->tools->menu, fmmm->tools->back_up_restore);
	g_signal_connect((gpointer) fmmm->tools->back_up_restore, "activate",
			 G_CALLBACK(on_menu_tools_back_up_restore_activate), NULL);

	fmmm->tools->find = gtk_menu_item_new_with_label(_("hfil_me_find"));
	gtk_menu_append(fmmm->tools->menu, fmmm->tools->find);
	g_signal_connect((gpointer) fmmm->tools->find, "activate",
			 G_CALLBACK(on_menu_tools_find_activate), NULL);
	add_ctrl_shortcut (fmmm->tools->find, accel_group, 'e');

	fmmm->tools->format = gtk_menu_item_new_with_label(_("hfil_me_format_memory_card"));
	gtk_menu_append(fmmm->tools->menu, fmmm->tools->format);
	g_signal_connect((gpointer) fmmm->tools->format, "activate",
			 G_CALLBACK(on_menu_tools_format_activate),
			 (gpointer) prog);
	g_signal_connect((gpointer) fmmm->tools->format, "insensitive_press",
			 G_CALLBACK(on_menu_tools_format_activate),
			 (gpointer) prog);

	fmmm->tools->separator1 = gtk_menu_item_new();
	gtk_container_add(GTK_CONTAINER(fmmm->tools->menu), fmmm->tools->separator1);
	gtk_widget_set_sensitive(fmmm->tools->separator1, FALSE);

	fmmm->tools->help = gtk_menu_item_new_with_label(_("hfil_me_help"));
	gtk_menu_append(fmmm->tools->menu, fmmm->tools->help);
	g_signal_connect((gpointer) fmmm->tools->help, "activate",
			 G_CALLBACK(on_menu_tools_help_activate), prog);

	fmmm->close = gtk_menu_item_new_with_label(_("hfil_me_close"));
	gtk_menu_append(fmmm->self, fmmm->close);
	g_signal_connect((gpointer)fmmm->close, "activate",
			 G_CALLBACK(on_menu_close_fm_activate), (gpointer) prog);
	add_ctrl_shortcut (fmmm->close, accel_group, 'q');

	hildon_window_set_menu (window, GTK_MENU(fmmm->self));

	return fmmm;
}


/**
 * osso_fm_create_popup_menu:
 *
 * This function creates the popup menu
 *
 * @param app - Pointer to the  HildonApp
 * @param view - Pointer to the HildonAppView
 * @param fs - Pointer to the File selection widget
 *
 * @return GtkWidget representing the popup menu
 */

FMPopupMenu *
osso_fm_create_popup_menu(OSSOFileManager *ofm)
{
	HildonProgram *prog = NULL;
	HildonFileSelection * fs = NULL;
	GtkWidget *separator;
	GSList *menu_view_list_group = NULL;
	GSList *menu_view_sort_group = NULL;
	FMPopupMenu *fmpm = NULL;

	DEBUG_PRINT_START;
	
	prog=ofm->prog;
	fs=ofm->fs;
	fmpm = g_new0(FMPopupMenu,1);
	fmpm->edit = g_new0(FMPMenuEdit,1);
	fmpm->view = g_new0(FMPMenuView,1);

	fmpm->menu = gtk_menu_new();
	DEBUG_PRINT;
	fmpm->file_open = gtk_menu_item_new_with_label(_("hfil_me_open"));
	gtk_menu_append(fmpm->menu, fmpm->file_open);
	g_signal_connect((gpointer) fmpm->file_open, "activate",
			 G_CALLBACK(on_menu_file_open_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->file_open, "insensitive_press",
			 G_CALLBACK(on_menu_file_open_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->sep_1 = gtk_menu_item_new();
	gtk_menu_append(fmpm->menu, fmpm->sep_1);
	gtk_widget_set_sensitive(fmpm->sep_1, FALSE);

	DEBUG_PRINT;
	fmpm->copy = gtk_menu_item_new_with_label(_("hfil_me_copy"));
	gtk_menu_append(fmpm->menu,fmpm->copy);
	g_signal_connect((gpointer) fmpm->copy, "activate",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer)fmpm->copy, "insensitive_press",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->paste = gtk_menu_item_new_with_label(_("hfil_me_paste"));
	gtk_menu_append(fmpm->menu, fmpm->paste);
	g_signal_connect((gpointer) fmpm->paste, "activate",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->paste, "insensitive_press",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->edit->self = gtk_menu_item_new_with_label(_("hfil_me_edit"));
	gtk_menu_append(fmpm->menu, fmpm->edit->self);
	fmpm->edit->menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmpm->edit->self),fmpm->edit->menu);

	DEBUG_PRINT;
	fmpm->edit->cut = gtk_menu_item_new_with_label(_("hfil_me_cut"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->cut);
	g_signal_connect((gpointer) fmpm->edit->cut, "activate",
			 G_CALLBACK(on_menu_edit_cut_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->edit->cut, "insensitive_press",
			 G_CALLBACK(on_menu_edit_cut_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->edit->copy = gtk_menu_item_new_with_label(_("hfil_me_copy"));
	gtk_menu_append(fmpm->edit->menu,fmpm->edit->copy);
	g_signal_connect((gpointer) fmpm->edit->copy, "activate",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer)fmpm->edit->copy, "insensitive_press",
			 G_CALLBACK(on_menu_edit_copy_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->edit->paste = gtk_menu_item_new_with_label(_("hfil_me_paste"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->paste);
	g_signal_connect((gpointer) fmpm->edit->paste, "activate",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->edit->paste, "insensitive_press",
			 G_CALLBACK(on_menu_edit_paste_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->edit->move_to = gtk_menu_item_new_with_label(_("hfil_me_move_to"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->move_to);
	g_signal_connect((gpointer) fmpm->edit->move_to, "activate",
			 G_CALLBACK(on_menu_move_to_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->edit->move_to, "insensitive_press",
			 G_CALLBACK(on_menu_move_to_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->edit->duplicate = gtk_menu_item_new_with_label(_("hfil_me_duplicate"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->duplicate);
	g_signal_connect((gpointer) fmpm->edit->duplicate, "activate",
			 G_CALLBACK(on_menu_duplicate_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->edit->duplicate, "insensitive_press",
			 G_CALLBACK(on_menu_duplicate_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	separator = gtk_menu_item_new();
	gtk_menu_append(fmpm->edit->menu, separator);
	gtk_widget_set_sensitive(separator, FALSE);

	DEBUG_PRINT;
	fmpm->edit->rename = gtk_menu_item_new_with_label(_("hfil_me_rename"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->rename);
	g_signal_connect((gpointer) fmpm->edit->rename, "activate",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);
	g_signal_connect((gpointer) fmpm->edit->rename, "insensitive_press",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);

	DEBUG_PRINT;
	fmpm->edit->delete = gtk_menu_item_new_with_label(_("hfil_me_delete"));
	gtk_menu_append(fmpm->edit->menu, fmpm->edit->delete);
	g_signal_connect((gpointer) fmpm->edit->delete, "activate",
			 G_CALLBACK(on_menu_file_delete_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->edit->delete, "insensitive_press",
			 G_CALLBACK(on_menu_file_delete_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->select_all = gtk_menu_item_new_with_label(_("hfil_me_select_all"));
	gtk_menu_append(fmpm->menu, fmpm->select_all);
	g_signal_connect((gpointer) fmpm->select_all, "activate",
			 G_CALLBACK(on_menu_mark_all_activate), (gpointer) fs);
	g_signal_connect((gpointer) fmpm->select_all, "insensitive_press",
			 G_CALLBACK(on_menu_mark_all_activate), (gpointer) fs);

	DEBUG_PRINT;
	fmpm->sep_3 = gtk_menu_item_new();
	gtk_menu_append(fmpm->menu, fmpm->sep_3);
	gtk_widget_set_sensitive(fmpm->sep_3, FALSE);

	fmpm->rename = gtk_menu_item_new_with_label(_("hfil_me_rename"));
	gtk_menu_append(fmpm->menu, fmpm->rename);
	g_signal_connect((gpointer) fmpm->rename, "activate",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);
	g_signal_connect((gpointer) fmpm->rename, "insensitive_press",
			 G_CALLBACK(on_menu_file_rename_activate), (gpointer) prog);

	fmpm->format = gtk_menu_item_new_with_label(_("hfil_me_format_memory_card"));
	gtk_menu_append(fmpm->menu, fmpm->format);
	g_signal_connect((gpointer) fmpm->format, "activate",
			 G_CALLBACK(on_menu_tools_format_activate), (gpointer) prog);
	g_signal_connect((gpointer) fmpm->format, "insensitive_press",
			 G_CALLBACK(on_menu_tools_format_activate), (gpointer) prog);

	fmpm->sep_2 = gtk_menu_item_new();
	gtk_menu_append(fmpm->menu, fmpm->sep_2);
	gtk_widget_set_sensitive(fmpm->sep_2, FALSE);

	fmpm->send = gtk_menu_item_new_with_label(_("hfil_me_send_files"));
	gtk_menu_append(fmpm->menu, fmpm->send);
	fmpm->send_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(fmpm->send), fmpm->send_menu);
	
	fmpm->send_as_email = gtk_menu_item_new_with_label(_("hfil_me_send_email"));
	gtk_menu_append(fmpm->send_menu, fmpm->send_as_email);
	g_signal_connect((gpointer) fmpm->send_as_email, "activate",
			 G_CALLBACK(on_menu_send_as_email_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->send_as_email, "insensitive_press",
			 G_CALLBACK(on_menu_send_as_email_activate), (gpointer) global_ofm);

	fmpm->send_via_bluetooth = gtk_menu_item_new_with_label(_("hfil_me_send_bluetooth"));
	gtk_menu_append(fmpm->send_menu, fmpm->send_via_bluetooth);
	g_signal_connect((gpointer) fmpm->send_via_bluetooth,  "activate",
		G_CALLBACK(on_menu_send_via_bluetooth_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->send_via_bluetooth,  "insensitive_press",
		G_CALLBACK(on_menu_send_via_bluetooth_activate), (gpointer) global_ofm);
	fmpm->details = gtk_menu_item_new_with_label(_("hfil_me_details"));
	gtk_menu_append(fmpm->menu, fmpm->details);
	g_signal_connect((gpointer) fmpm->details, "activate",
			 G_CALLBACK(on_menu_details_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->details, "insensitive_press",
			 G_CALLBACK(on_menu_details_activate), (gpointer) global_ofm);

	DEBUG_PRINT;
	fmpm->sep_4 = gtk_menu_item_new();
	gtk_menu_append(fmpm->menu, fmpm->sep_4);
	gtk_widget_set_sensitive(fmpm->sep_4, FALSE);

	DEBUG_PRINT;
	fmpm->newfolder = gtk_menu_item_new_with_label(_("hfil_me_new_folder"));
	gtk_menu_append(fmpm->menu, fmpm->newfolder);
	g_signal_connect((gpointer)fmpm->newfolder, "activate",
			 G_CALLBACK(on_menu_file_new_folder_activate), (gpointer) global_ofm);
	g_signal_connect((gpointer) fmpm->newfolder, "insensitive_press",
			 G_CALLBACK(on_menu_file_new_folder_activate), (gpointer) global_ofm);

	/*separator = gtk_menu_item_new();
	gtk_menu_append(fmpm->menu, separator);
	gtk_widget_set_sensitive(separator, FALSE);*/

	DEBUG_PRINT;
	fmpm->view->self = gtk_menu_item_new_with_label(_("hfil_me_view"));
	gtk_menu_append(fmpm->menu, fmpm->view->self);
	fmpm->view->menu = gtk_menu_new();
	gtk_menu_item_set_submenu((GtkMenuItem *) fmpm->view->self,
				  (GtkWidget *) fmpm->view->menu);

	DEBUG_PRINT;
	fmpm->view->sort_by_type =
	    gtk_radio_menu_item_new_with_label(menu_view_sort_group, 
			    dgettext(HILDON_FM_L10N_PACKAGE, "sfil_me_sort_type"));
	menu_view_sort_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->sort_by_type));
	gtk_menu_append(fmpm->view->menu, fmpm->view->sort_by_type);
	g_signal_connect((gpointer) fmpm->view->sort_by_type, "activate",
			 G_CALLBACK(osso_fm_sort_by_type), (gpointer) fs);

	DEBUG_PRINT;
	fmpm->view->sort_by_name =
	    gtk_radio_menu_item_new_with_label(menu_view_sort_group, 
			    dgettext(HILDON_FM_L10N_PACKAGE, "sfil_me_sort_name"));
	menu_view_sort_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->sort_by_name));
	gtk_menu_append(fmpm->view->menu, fmpm->view->sort_by_name);
	g_signal_connect((gpointer) fmpm->view->sort_by_name, "activate",
			 G_CALLBACK(osso_fm_sort_by_name), (gpointer) fs);

	DEBUG_PRINT;
	fmpm->view->sort_by_date =
	    gtk_radio_menu_item_new_with_label(menu_view_sort_group, 
			    dgettext(HILDON_FM_L10N_PACKAGE, "sfil_me_sort_date"));
	menu_view_sort_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->sort_by_date));
	gtk_menu_append(fmpm->view->menu, fmpm->view->sort_by_date);
	g_signal_connect((gpointer) fmpm->view->sort_by_date, "activate",
			 G_CALLBACK(osso_fm_sort_by_modified), (gpointer) fs);

	DEBUG_PRINT;
	fmpm->view->sort_by_size =
	    gtk_radio_menu_item_new_with_label(menu_view_sort_group, 
			    dgettext(HILDON_FM_L10N_PACKAGE, "sfil_me_sort_size"));
	menu_view_sort_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->sort_by_size));
	gtk_menu_append(fmpm->view->menu, fmpm->view->sort_by_size);
	g_signal_connect((gpointer) fmpm->view->sort_by_size, "activate",
			 G_CALLBACK(osso_fm_sort_by_size), (gpointer) fs);
	
	DEBUG_PRINT;
	separator = gtk_menu_item_new();
	gtk_menu_append(fmpm->view->menu, separator);
	gtk_widget_set_sensitive(separator, FALSE);

	fmpm->view->list =
	    gtk_radio_menu_item_new_with_label(menu_view_list_group,_("hfil_me_list_view"));
	menu_view_list_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->list));
	gtk_menu_append(fmpm->view->menu, fmpm->view->list);
	g_signal_connect((gpointer) fmpm->view->list, "activate",
			 G_CALLBACK(on_menu_view_list_activate), (gpointer) global_ofm);

	fmpm->view->thumbnails =
	    gtk_radio_menu_item_new_with_label(menu_view_list_group, _("hfil_me_thumbnail_view"));
	menu_view_list_group =
	    gtk_radio_menu_item_get_group(GTK_RADIO_MENU_ITEM(fmpm->view->thumbnails));
	gtk_menu_append(fmpm->view->menu, fmpm->view->thumbnails);
	g_signal_connect((gpointer) fmpm->view->thumbnails, "activate",
			 G_CALLBACK(on_menu_view_thumbnail_activate), (gpointer) global_ofm);
	fmpm->help = gtk_menu_item_new_with_label(_("hfil_me_help"));
	gtk_menu_append(fmpm->menu, fmpm->help);
	g_signal_connect((gpointer) fmpm->help, "activate",
			 G_CALLBACK(on_menu_tools_help_activate), (gpointer) prog);

	gtk_widget_show_all(fmpm->menu);
	DEBUG_PRINT_END;
	return fmpm;
}


//NEW CODE ENDS
