/**
 * @file  osso_fm_generic.h
 *
 * This file contains most of the .h files to be included in the filemanager .c
 * files. It also contains some #defines and macros.
 *
 * Copyright (C) 2005 Nokia Corporation
 */

#ifndef OSSO_FM_GENERIC_H__
#define OSSO_FM_GENERIC_H__
#define DBUS_API_SUBJECT_TO_CHANGE
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glib.h>
#include <string.h>

#include <locale.h>
#include <libintl.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>

#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-sort-dialog.h>
#include <hildon/hildon-note.h>
#include <hildon/hildon-file-selection.h>
#include <hildon/hildon-file-system-info.h>
#include <hildon/hildon-file-system-model.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <hildon/hildon-file-system-common.h>

#include <hildon/hildon-fm1-compat.h>

#include <hildon-thumbnail/hildon-thumbnail-factory.h>

#include <osso-log.h>
#include "log-functions.h"
//#include "md5.h"

#include <bt-gconf.h>
#include <gconf/gconf.h>
#include <gconf/gconf-value.h>
#include <gconf/gconf-client.h>

#include <conbtdialogs-dbus.h>

#define HAVE_770 /* Hacker addition */

#define USB_CONNECTED_GCONF_VAR "/system/osso/af/usb-cable-attached"
#define MMC_CARD_PRESENT_VAR "/system/osso/af/mmc-device-present"
#define INT_MMC_CARD_PRESENT_VAR "/system/osso/af/internal-mmc-device-present"
#define MMC_CARD_USED_OVER_USB_VAR "/system/osso/af/mmc-used-over-usb"
#define INT_MMC_CARD_USED_OVER_USB_VAR "/system/osso/af/internal-mmc-used-over-usb"
#define SWAP_ON_INTERNAL_MMC "/system/osso/af/internal-mmc-swap"
#define SWAP_ON_MMC "/system/osso/af/mmc-swap"
#define MMC_STATUS_KEYS_DIR "/system/osso/af"

//Dbus service related
#define TASK_NAV_SERVICE                    "com.nokia.tasknav"
/* NOTICE: Keep these in sync with values in hildon-navigator/windowmanager.c! */
#define APP_LAUNCH_BANNER_METHOD_INTERFACE  "com.nokia.tasknav.app_launch_banner"
#define APP_LAUNCH_BANNER_METHOD_PATH       "/com/nokia/tasknav/app_launch_banner"
#define APP_LAUNCH_BANNER_METHOD            "app_launch_banner"

//localization related defines
#define HILDON_COMMON_STRINGS_L10N_PACKAGE "hildon-common-strings"
#define HILDON_FM_L10N_PACKAGE "hildon-fm"
#define HILDON_LIBS_L10N_PACKAGE "hildon-libs"
#define KE_RECV_L10N_PACKAGE "ke-recv"
#define OSSO_APPLET_MEMORY_L10N_PACKAGE "osso-applet-memory"

//#include "osso_fm_callbacks.h"
#include "osso_fm_support.h"
//#include "osso_fm_controller.h"

/* API for common error code  */
/* Filemanager doesn't use libosso-common-error anymore */
/* #include "osso-common-error.h" */

#define _(String) dgettext(PACKAGE, String)
//#define _(String) fakelocale(String)
//#define _(String) ui_get_localized_string(String)

#define HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define HOOKUP_OBJECT_NO_REF(component,widget,name) \
g_object_set_data (G_OBJECT (component), name, widget)


#define DEBUG TRUE 

#ifdef DEBUG
/*#define DEBUG_PRINT_START FM_ULOG_INFO("[%s] [%s] Starts [%d]\n", \
__FILE__, __FUNCTION__, __LINE__);

#define DEBUG_PRINT_END FM_ULOG_INFO("[%s] [%s] Ends [%d]\n", \
__FILE__, __FUNCTION__, __LINE__);

#define DEBUG_PRINT FM_ULOG_INFO("[%s] [%s] [%d]\n", \
__FILE__, __FUNCTION__, __LINE__);*/
#endif

/*#ifndef DEBUG*/
#define DEBUG_PRINT_START ;
#define DEBUG_PRINT_END ;
#define DEBUG_PRINT ;
/*#endif*/

#define MAX_MMC_NAME_LENGTH 11
#define MAX_FOLDER_LENGTH 64
#define MAX_FILE_LENGTH 255
#define MAX_PATH_LENGTH 255
#define ERROR_CHARSET "<>@!~#$%^&+=,()\"/\\|:?.*"

//#define TOOLBAR_MARGIN_BTW_BUTTONS 33
//#define TOOLBAR_LEFT_MARGIN 27
//#define TOOLBAR_RIGHT_MARGIN 26
//#define TOOLBAR_BUTTON_WIDTH 48

#define THUMBNAIL_CLEAN_TIME (24*60*60)	// 24 hours
#define APP_NAME "osso_filemanager"
#define APP_VER "0.4.6"

#define LOCALEDIR "/usr/share/locale"

#define APP_STARTUP_TIMER_SPEED 50
#define G_TIMEOUT  500
#define G_INFO_TIMEOUT 150

#define RESERVED_SPACE (2408 * 1024)

#define MAX_STR_LEN(str1,str2) \
( \
   strlen(str1)>strlen(str2)?strlen(str1):strlen(str2) \
)

#define DEVICE_MODEL "N800"
#define DEVICE_MANUFACTURER "NOKIA"
#define DEVICE_MODEL_TYPE "N800"



#define GLOBAL_SEARCH_APP 	"osso_global_search"
#define SEARCH_FILES 		"search_file"

#define BACKUP_APP 		"backup"
#define BACKUP_METHOD_ACTIVATE 	"activate"

#define HELP_APP 		"osso_help"
#define HELP_ACTIVATE 		"link_activated"



//#define GW_INVOKE_APPLICATION "osso_connectivity_ui_gwwizard"
#define GW_INVOKE_METHOD	"activate"	//TODO: method name is to be checked.

#ifdef HAVE_770
#define MMC_PATH "/media/mmc2"	//TODO : to be changed to the correct path
#define INTERNAL_MMC_PATH "/media/mmc1"	//TODO : to be changed to the correct path
#else
#define MMC_PATH "/media/mmc1"	//TODO : to be changed to the correct path
#define INTERNAL_MMC_PATH "/media/mmc2"	//TODO : to be changed to the correct path
#endif
#define GATEWAY_PATH "obex://"
#define UPNP_PATH "upnpav://"

#define MMC_FORMAT_SERVICE	"com.nokia.ke_recv"
#define MMC_FORMAT_OBJECT_PATH	"/com/nokia/ke_recv/format"
#define MMC_FORMAT_METHOD	"format"

#define MMC_RENAME_OBJECT_PATH	"/com/nokia/ke_recv/rename"
#define MMC_RENAME_METHOD	"rename"

#define INTERNAL_MMC_FORMAT_OBJECT_PATH	"/com/nokia/ke_recv/internal_format"
#define INTERNAL_MMC_FORMAT_METHOD	"internal_format"

#define INTERNAL_MMC_RENAME_OBJECT_PATH	"/com/nokia/ke_recv/internal_rename"
#define INTERNAL_MMC_RENAME_METHOD	"internal_rename"


#define DELTA 2
#define TOOLBAR_MARGIN_BTW_BUTTONS 35+DELTA
#define TOOLBAR_LEFT_MARGIN 35
#define TOOLBAR_RIGHT_MARGIN 36

#define DELTA_FULLSCREEN 2
#define TOOLBAR_MARGIN_BTW_BUTTONS_FULLSCREEN 44 + DELTA_FULLSCREEN
#define TOOLBAR_LEFT_MARGIN_FULLSCREEN 44
#define TOOLBAR_RIGHT_MARGIN_FULLSCREEN 44

//struct FMClipboard
//{
//      gint operation;
//      GSList *cliplist;
//} fmclipboard;

// HildonFileSystemModel *fsmodel = NULL;

/*
gchar *ui_get_localized_string(gchar *key);
gchar *fakelocale(gchar *lgname);
gchar *getvalue(FILE *fp, gchar *lgname);
gboolean ui_read_settings_from_file();
gboolean ui_are_locale_settings_initialized ();	
void ui_destroy_hash_tables (void);
*/

//osso_context_t* fm_app_ctx;
typedef enum {

	SIT_NO_ITEM_SELECTED,

	SIT_SINGLE_FILE_SELECTED,
	SIT_SINGLE_FOLDER_SELECTED,

	SIT_MULTIPLE_FILES_SELECTED,
	SIT_MULTIPLE_FOLDERS_SELECTED,

	SIT_SINGLE_SAFE_FOLDER_SELECTED,
	SIT_MULTIPLE_SAFE_FOLDERS_SELECTED,

	SIT_DEVICE_SELECTED,
	SIT_MMC_SELECTED,

	SIT_MULTIPLE_ITEMS_SELECTED,

	SIT_ERROR_IN_GETTING_INFO
} SelectionInfoType;

//Operations performed from menu or toolbar
typedef enum {
	OPER_OPEN = 1,
	OPER_NEWFOLDER = 2,
	OPER_RENAME = 3,
	OPER_DELETE = 4,
	OPER_MAIL = 5,
	OPER_DETAILS = 6,
	OPER_CUT = 7,
	OPER_COPY = 8,
	OPER_PASTE = 9,
	OPER_MOVE = 10,
	OPER_DUPLICATE = 11,
	OPER_LISTVIEW = 12,
	OPER_THUMBNAIL = 13,
	OPER_SORT = 14,
	OPER_FULLSCREEN = 15,
	OPER_TOOLBAR = 16,
	OPER_MMCFORMAT = 17,
	OPER_MMCRENAME = 18,
	OPER_BACKUP = 19,
	OPER_SEARCH = 20,
	OPER_HELP = 21,
	OPER_CLOSE = 22,
	OPER_SENDVIABT = 23,
	OPER_NONE = 24
} MenuOperation;

typedef struct 
{
	GtkToolbar *toolbar;
	GtkToolItem *find_button;
	GtkToolItem *new_button;
	GtkToolItem *moveto_button;
	GtkToolItem *details_button;
	GtkToolItem *delete_button;
	GtkToolItem *listview_button;
	GtkToolItem *thumbview_button;
}FMToolbar;

typedef struct{
	GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *cut;
	GtkWidget *copy;
	GtkWidget *paste;
	GtkWidget *move_to;
	GtkWidget *duplicate;
	GtkWidget *rename;
	GtkWidget *delete;
}FMPMenuEdit;

typedef struct{
	GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *sort_by_type;
	GtkWidget *sort_by_name;
	GtkWidget *sort_by_date;
	GtkWidget *sort_by_size;
	GtkWidget *list;
	GtkWidget *thumbnails;
}FMPMenuView;


typedef struct{
	GtkWidget *menu;
	GtkWidget *file_open;
        GtkWidget *sep_1;
        GtkWidget *copy;
        GtkWidget *paste;
	FMPMenuEdit *edit;
	GtkWidget *select_all;
        GtkWidget *sep_3;
        GtkWidget *rename;
        GtkWidget *format;
        GtkWidget *sep_2;
	GtkWidget *send;
	GtkWidget *send_menu;
	GtkWidget *send_as_email;
	GtkWidget *send_via_bluetooth;
	GtkWidget *details;
        GtkWidget *sep_4;
	GtkWidget *newfolder;
	FMPMenuView *view;
	GtkWidget *help;	
}FMPopupMenu;

typedef struct{
        GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *open;
	GtkWidget *new_folder;	
	GtkWidget *rename;
	GtkWidget *delete;
	GtkWidget *separator1;
	GtkWidget *send;
	GtkWidget *send_menu;
	GtkWidget *send_as_email;
	GtkWidget *send_via_bluetooth;
	GtkWidget *details;
}FMMenuFile;

typedef struct{
	GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *cut;
	GtkWidget *copy;
	GtkWidget *paste;
	GtkWidget *select_all;
	GtkWidget *separator1;
	GtkWidget *move_to;
	GtkWidget *duplicate;
}FMMenuEdit;

typedef struct{
	GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *list;
	GtkWidget *thumbnail;
	GtkWidget *separator1;
	GtkWidget *sort;
	GtkWidget *separator2;
	GtkWidget *full_screen;
	GtkWidget *separator3;
	GtkWidget *show_tool_bar;
	GtkWidget *show_tool_bar_menu;
	GtkWidget *normal_mode;
	GtkWidget *fullscreen_mode;
}FMMenuView;

typedef struct{
	GtkWidget *self;
	GtkWidget *menu;
	GtkWidget *back_up_restore;
        GtkWidget *format;
	GtkWidget *find;
	GtkWidget *separator1;
	GtkWidget *help;
}FMMenuTools;

typedef struct{
	GtkWidget *self;
	FMMenuFile *file;
	FMMenuEdit *edit;
	FMMenuView *view;
	FMMenuTools *tools;	
	GtkWidget *close;
}FMMainMenu;

typedef struct {
	GtkFilePath *path;
        char *extra;
	HildonFileSystemModelItemType type;
	gboolean readonly;
}OSSOFMFileInfo;

typedef struct {
	gboolean selection;
	gboolean ronly_parent;
	gint no_files;
	gint no_folders;
	gint no_ronly_files;
	gint no_ronly_folders;
	gint no_safe_folders;
	gint no_devices;
	gint no_mmc;
	GtkFilePath *current_folder;
	GSList *current_selection;		//list of GtkFilePath
	GSList *current_selection_withinfo;	//list of OSSOFMFileInfo
	gboolean needs_update;
	gboolean ro_status_needs_update;
	gboolean selected_all;
	gboolean just_selected_all;
	gboolean selection_in_gateway;
	gboolean selection_in_mmc;
	gboolean selection_in_media_server;
} SelectionInfo;

typedef struct 
{
	HildonProgram *prog;
	HildonWindow *window;
	GtkFileSystem *gtkfilesystem;
	FMToolbar *fmtoolbar;
	FMMainMenu *fmmmenu;
	FMPopupMenu *fmpmenu;
	HildonFileSelection *fs;
	SelectionInfo *si;
	MenuOperation cur_operation;
	gboolean operation_started;
	gpointer xfer_callback_data;
	gint gnomevfs_watchdog_timer_source;
	GtkWidget *open_dialog_ptr;
	gboolean open_dialog_sel_change_sensitive;
	GSList *open_dialog_sensitive_on_selection;
	gboolean fullscreen_key_pressed;
	GKeyFile *keyfile;
}OSSOFileManager;

extern OSSOFileManager *global_ofm; //TODO REMOVE THIS AFTER TOTAL CLEANUP
extern gboolean fm_loading;
#endif				//OSSO_FM_GENERIC_H__
