/**
 * @file  osso_fm_fmstate.h
 *
 * This file contains the declarations for the state management of
 * file manager application.
 *
 * Copyright (C) 2005 Nokia Corporation
 */


#ifndef __FMSTATE_H__
#define __FMSTATE_H__

G_BEGIN_DECLS
#define PREFERENCES_FILE "~/.osso/OSSO_FILEMANAGER/Folderstate"
#define PREFERENCES_FILE_PATH "~/.osso/OSSO_FILEMANAGER"
#define FOLDER_STATE_GROUP "FOLDER STATE"
    struct FMState {
	//gint sortorder;         //current sort order in file selection
	//gint selectiondevice;       // for LOCAL, MMC, GW ... next phase
	//gint selectiontype; //Selection state of File selection widget
	//gboolean thumbnail;     //TRUE if view state is thumbnail view
	//gboolean viewnormal;    //TRUE if view mode is normal
} fmstate;
enum Operation {
	OPERATION_CUT = 1,
	OPERATION_COPY = 2,
	OPERATION_PASTE = 3,
	OPERATION_NONE = 4
} operation;


typedef enum {
	OPEN_DIALOG_NONE = 0,
	OPEN_DIALOG_DETAILS = 1,
} CurrnetOpenDialog;

typedef enum {
	ERR_NO_ERROR = 0,
	ERR_ALLOCATING_MEMORY = 1,
	ERR_READING_FILE_INFO = 2
} FMError;

typedef enum {

	SINGLE_FILE_SELECTED,
	SINGLE_RONLY_FILE_SELECTED,
	SINGLE_PRONLY_FILE_SELECTED,

	SINGLE_FOLDER_SELECTED,
	SINGLE_RONLY_FOLDER_SELECTED,
	SINGLE_PRONLY_FOLDER_SELECTED,

	MULTIPLE_FILES_SELECTED,
	MULTIPLE_RONLY_FILES_SELECTED,
	MULTIPLE_PRONLY_FILES_SELECTED,
	MULTIPLE_FILES_WITH_RONLY_SELECTED,

	MULTIPLE_FOLDERS_SELECTED,
	MULTIPLE_RONLY_FOLDERS_SELECTED,
	MULTIPLE_PRONLY_FOLDERS_SELECTED,
	MULTIPLE_FOLDERS_WITH_RONLY_SELECTED,

	SINGLE_FILE_SINGLE_FOLDER_SELECTED,
	SINGLE_FILE_SINGLE_FOLDER_WITH_RONLY_SELECTED,
	SINGLE_FILE_SINGLE_FOLDER_WITH_PRONLY_SELECTED,

	SINGLE_FILE_MULTIPLE_FOLDERS_SELECTED,
	SINGLE_FILE_MULTIPLE_FOLDERS_WITH_RONLY_SELECTED,
	SINGLE_FILE_MULTIPLE_FOLDERS_WITH_PRONLY_SELECTED,

	MULTIPLE_FILES_SINGLE_FOLDER_SELECTED,
	MULTIPLE_FILES_SINGLE_FOLDER_WITH_RONLY_SELECTED,
	MULTIPLE_FILES_SINGLE_FOLDER_WITH_PRONLY_SELECTED,

	MULTIPLE_FILES_MULTIPLE_FOLDERS_SELECTED,
	MULTIPLE_FILES_MULTIPLE_FOLDERS_WITH_RONLY_SELECTED,
	MULTIPLE_FILES_MULTIPLE_FOLDERS_WITH_PRONLY_SELECTED,

	NO_ITEM_SELECTED,

	SAFE_FOLDER_SELECTED,

	DEVICE_SELECTED,
	RONLY_DEVICE_SELECTED,

	MMC_SELECTED,
	RONLY_MMC_SELECTED,

	ERROR_ALLOCATING_MEMORY,
	ERROR_READING_FILE_INFO,
	ERROR_INPUT_PARAMETERS
} SelectionType;


//User selection is divided into the following structure for 
//appropriate menu and toolbar enabling
typedef struct {
	gboolean selection;
	gboolean ronly_parent;
	gint no_files;
	gint no_folders;
	gint no_ronly_files;
	gint no_ronly_folders;
	gint no_safe_folders;
	gint no_devices;
	gint no_mmc;
	FMError error;
} SelectionState;

SelectionState selectionstate;

//state of main window
typedef struct {
	gchar *currentselection;	//Current selected file or folder name
	GSList *selection;
	CurrnetOpenDialog opendialog;
	gboolean viewnormal;
	gboolean fullscreen;
	gboolean phonebook;
	gboolean checkselection;
	SelectionType selection_type;
} MainWindow;

typedef struct {
	gboolean userclosed;
	gchar *param1;
	gchar *param2;
} PopupDialog;

struct AppState {
	MainWindow mainwindow;
	PopupDialog popupdailog;
	gboolean application_untopped;
} appstate;

/*Loads fm tate from the file*/
void load_fm_state();

/*saves fmstate ot file*/
void save_fm_state();

/**
* Saves default file manager state to the file
* @param void
* @return void
*/
void clear_fm_state();

void set_appliaction_state(gboolean nav_pane_active);

void osso_fm_set_currentselection(const gchar * newcursel);


void selection_info_init(SelectionInfo *si);
void selection_info_members_free(SelectionInfo *si);
void selection_info_reset(SelectionInfo *si);
void selection_info_set_current_folder(SelectionInfo *si,GtkFilePath *cur_folder);
void selection_info_set_current_selection(SelectionInfo *si,GSList *cur_sel);
gboolean selection_info_update(OSSOFileManager *ofm,gboolean real);
SelectionInfoType selection_info_get_selection_type(SelectionInfo *si);

G_END_DECLS
#endif				//__FMSTATE_H__
