/**
 * @file osso_fm_details.h
 * 
 * This file contains the Folder Details dialog info formatting modules
 *
 * Copyright (C) 2005 Nokia Corporation
 * 
 */


#ifndef __OSSO_FM_DETAILS_H__
#define __OSSO_FM_DETAILS_H__

#include "osso_fm_generic.h"
#include "osso_fm_utils.h"

#define TIME_STRING_LENGTH 40
#define DATE_STRING_LENGTH 35

/* Structure to have Directory Info */
typedef struct _FolderDetailsCounts {
	GnomeVFSFileSize total_size;	/* Total Size of directory */

	guint total_files;	/* Total number of files inside directory  */

	guint total_folders;	/* Total number of directories inside the direcctory */

} FolderDetailsCounts;


typedef struct _fileMemData {
	gint64 totalsize;
	gint64 usedsize;
	gint64 files_usedsize;
	gint64 freesize;
	gint imagesize;
	gint audiosize;
	gint videosize;
	gint htmlsize;
	gint docsize;
	gint emailsize;
	gint contactsize;
	gint appsize;
	gint othersize;
	gint fileno;
	gint folderno;
} fileMemData;

gboolean osso_fm_details_activate(OSSOFileManager * ofm, gboolean menucheck);


#endif
