/**
 * @file osso_fm_callbacks.h
 *
 * This file contains declaration of all the callback routines.
 *
 * Copyright (C) 2005 Nokia Corporation
 */


#ifndef __OSSO_FM_CALLBACKS_H__
#define __OSSO_FM_CALLBACKS_H__

#include <gtk/gtk.h>
#include "osso_fm_fmstate.h"

#include <dbus/dbus.h>

extern gboolean fm_closing;
/**
Method to update the title bar of the application.

@param file_sel_widget is file selection widget.
@param view HildonAppView

@return void
*/
void update_fm_title(GtkWidget * file_sel_widget, HildonWindow *window);



void on_fm_exit_signal(int signal);



/**
Method called when open menu option is clicked

@param menuitem Pointer to GtkMenuItem
@param window Pointer to File selection widget

@return void
*/
void on_menu_file_open_activate(GtkMenuItem * menuitem, gpointer window);


/**
New folder dialog is created.

@param menuitem Pointer to GtkMenuItem
@param app Pointer to HildonApp

@return void
*/
void on_menu_file_new_folder_activate(GtkMenuItem * menuitem, gpointer app);



/**
File rename dialog is created

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_file_rename_activate(GtkMenuItem * menuitem, gpointer window);



/**
File delete operation is invoked.

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_file_delete_activate(GtkMenuItem * menuitem, gpointer window);



/**
Send selected files as an attachment to email.

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_send_as_email_activate(GtkMenuItem * menuitem, gpointer window);

void on_menu_send_via_bluetooth_activate(GtkMenuItem * menuitem, gpointer window);


/**
Details dialog is created as per the user selection

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_details_activate(GtkMenuItem * menuitem, gpointer window);



/**
Cut the selected file path to the clipboard.

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_edit_cut_activate(GtkMenuItem * menuitem, gpointer data);


/**
Cut the selected file path to the clipboard.

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer
@param menucheck TRUE if teh function is called in scilent mode (used for operation validation)

@return TRUE if operation is succesful else FALSE
*/
gboolean on_cut_activate(OSSOFileManager *ofm, gboolean menucheck);



/**
Copy the selected paths to clipboard

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_edit_copy_activate(GtkMenuItem * menuitem, gpointer data);



/**
Copy the selected paths to clipboard

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer
@param menucheck TRUE for the opearation in silent mode. (used in validation menu items)

@return TRUE if operation is succesful else FALSE
*/
gboolean on_copy_activate(OSSOFileManager *ofm, gboolean menucheck);



/**
Paste the clipboard path to the current selected path

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection

@return void
*/
void on_menu_edit_paste_activate(GtkMenuItem * menuitem, gpointer data);



/**
Paste the clipboard path to the current selected path

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection
@param 

@return TRUE if operation is succesful else FALSE
*/
gboolean on_paste_activate(OSSOFileManager *ofm, gboolean menucheck);


/**
 * Method to select unselect folder items in content pane.
 *
 * @param menuitem GtkMenuItem from which the event is triggered
 * @param filesection Pointer to HildonFileSelection
 */
void on_edit_menu_select_items(GtkMenuItem * menuitem, gpointer fileselection);


/**
 * Method to validate the selection menu item
 *
 * @param fileselection Pointer to HIldonFileSelection
 * menucheck TRUE to execute function for vlidating menu items
 *
 * return TRUE if operation suceeds else FALSE;
 */
gboolean on_edit_menu_select_activate(HildonFileSelection * fileselection, gboolean menucheck);



/**
Marks all the selected file or olders on the list pane

@param fileselection Pointer to HildonFileSelection widget
@param menucheck gboolean representing menu checking

@return gboolean.
*/
gboolean on_mark_all_activate(gpointer fileselection, gboolean menucheck);

/**
Marks all the selected file or olders on the list pane

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection widget 

@return void.
*/
void on_menu_mark_all_activate(GtkMenuItem * menuitem, gpointer fileselection);


gboolean osso_fm_moveto (OSSOFileManager *ofm, gboolean menucheck);

/**
For a valid selection creates Moveto dialog  
otherwise pops up an error message window

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_move_to_activate(GtkWidget * menuitem, gpointer window);


/**
For a valid selection creates Moveto dialog  
otherwise pops up an error message window

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
gboolean on_move_to_activate(GtkWidget * menuitem, gpointer window, gboolean menucheck);


/**
Duplicates the selected files and folders

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer

@return void
*/
void on_menu_duplicate_activate(GtkMenuItem * menuitem, gpointer window);


/**
Duplicates the selected files and folders

@param menuitem GtkMenuItem from which the event is triggered
@param window HildonApp pointer
@param menucheck TRUE to run the operation in silent mode.

@return TRUE if operation is succesful 
*/
gboolean on_duplicate_activate(OSSOFileManager *ofm, gboolean menucheck);



/**
 * Funtion will save the current path preferences for future reference
 *
 * @param fileselection HildonFileSelection
 */
void osso_fm_save_path_preferences(HildonFileSelection * fileselection);


/**
 * Method to set the mode for file selection widget
 *
 * @param fileselection HildonFileSelection
 * @param thumbnail TRUE if thumbnail view is to be set.
 */
void osso_fm_set_mode(HildonFileSelection * fileselection, gboolean thumbnail);



/**
set the file and folder view as list.

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection widget

@return void
*/
void on_menu_view_list_activate(GtkMenuItem * menuitem, gpointer fileselection);



/**
set the file and folder view as thumbnail

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection widget

@return void
*/
void on_menu_view_thumbnail_activate(GtkMenuItem * menuitem, gpointer fileselection);


/**
Sorts the item

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection widget
@param menucheck boolean representing menucheck status

@return boolean
*/
gboolean on_sort_activate(gpointer fileselection, gboolean menucheck);

/**
Sorts the item

@param menuitem GtkMenuItem from which the event is triggered
@param fileselection Pointer to HildonFileSelection widget

@return void
*/
void on_menu_sort_activate(GtkMenuItem * menuitem, gpointer fileselection);


/**
 * Method to set sort for file selection widget
 *
 * @param fs HildonFileSelectionWidget
 * @param key Represents the column by which sort has to be performed
 * @param order sorting order ascending or descending
 */
void osso_fm_sort(HildonFileSelection * fs, HildonFileSelectionSortKey key, GtkSortType order);


/**
 * Method to sort by name
 *
 * @param widget Source widget from which the event is raised.
 * @param fs HildonFileSelection widget
 */
void osso_fm_sort_by_name(GtkWidget * widget, HildonFileSelection * fs);


/**
 * Method to sort by type
 *
 * @param widget Source widget from which the event is raised.
 * @param fs HildonFileSelection widget
 */
void osso_fm_sort_by_type(GtkWidget * widget, HildonFileSelection * fs);


/**
 * Method to sort by modified time
 *
 * @param widget Source widget from which the event is raised.
 * @param fs HildonFileSelection widget
 */
void osso_fm_sort_by_modified(GtkWidget * widget, HildonFileSelection * fs);


/**
 * Method to sort by size
 *
 * @param widget Source widget from which the event is raised.
 * @param fs HildonFileSelection widget
 */
void osso_fm_sort_by_size(GtkWidget * widget, HildonFileSelection * fs);


void on_menu_tools_find_activate(GtkMenuItem * menuitem, gpointer user_data);
void on_menu_tools_format_activate(GtkMenuItem * menuitem, gpointer user_data);



void on_menu_tools_help_activate(GtkMenuItem * menuitem, gpointer user_data);



void on_menu_tools_back_up_restore_activate(GtkMenuItem * menuitem, gpointer user_data);



/**
Closes the FM application 

@param menuitem GtkMenuItem from which the event is triggered
@param user_data HildonApp pointer

@return void
*/
void on_menu_close_fm_activate(GtkMenuItem * menuitem, gpointer user_data);


/**
 * Method called when popupmenu is activated from content pane.
 *
 * @param view HildonFileSelection Widget
 * @param app HildonApp pointer representing the application window
 */
void on_content_popup_menu_activate(GtkWidget * view, gpointer app);


/**
 * Method called when popup menu is activated from navigation pane.
 *
 * @param view HildonFileSelection Widget
 * @param app HildonApp representing the application window
 */
void on_navigation_popup_menu_activate(GtkWidget * view, gpointer app);



/**
Method called to invoke popup menu

@param view HildonFileSelection widget 
@param app HildonApp pointer

@return void
*/
void on_popup_menu_activate(OSSOFileManager *ofm, gboolean contentpane);



/**
Method called to when user drags and drops the selection

@param fs HildonFileSelection where the selected items are dropped.
@param destination GtkFilePath represention the path where the 
selected file/folder items are dropped
@param sources GSList representing the selection

@return void
*/
void
on_file_selection_items_dropped(HildonFileSelection * fs,
				GtkFilePath * destination, GSList * sources);



/**
 * on_buttonFind_clicked()

 * @param button pointer to GtkButton  
 * @param user_data HildonApp pointer
 *
 * TODO: Find the selected item.
 */
void on_buttonFind_clicked(GtkButton * button, gpointer user_data);



/**
validates the selection and deletes selected list.

@param button pointer to GtkButton 
@param app HildonApp pointer

@return void
*/
void on_buttonDelete_clicked(GtkButton * button, gpointer app);



/**
validates the selection and create new folder

@param button pointer to GtkButton
@param app HildonApp pointer

@return void
*/
void on_button_newfolder_clicked(GtkButton * button, gpointer app);



/**
validates the selection and moves selected list.

@param button pointer to GtkButton
@param app HildonApp pointer

@return void
*/
void on_button_moveto_clicked(GtkWidget * button, gpointer app);



/**
validates the selection and deletes selected list.

@param button pointer to GtkButton
@param app HildonApp pointer

@return void
*/
void on_button_detail_clicked(GtkButton * button, gpointer app);



/**
List View is shown

@param button pointer to GtkButton 
@param app HildonApp pointer

@return void
*/
void on_buttonList_clicked(GtkButton * button, gpointer app);



/**
Thumbnail view is shown

@param button pointer to GtkButton 
@param app HildonApp pointer

@return void
*/
void on_buttonThumb_clicked(GtkButton * button, gpointer app);



///**
//Validates the selected source list and target list
//If valid the moves the source list to the specfied target location.
//
//@param move_dialog pointer to Moveto dialog 
//@param sourcefs Pointer to the File Selection widget
//
//@return gboolean
//*/
//gint on_move_dialog_okbutton_clicked(GtkWidget * move_dialog, gpointer sourcefs);



/**
For a specified time lapse, progress window is shown.

@param progresswindow pointer to progresswindow

@return gint
*/
gint on_operation_progress_timeout(gpointer progresswindow);


/**
 * Application un topped
 * 
 * @param app HildonApp for the application
 */
void fm_application_untopped_cb(gpointer app);

/**
 * Application topped
 * 
 * @param app HildonApp for the application
 */
void fm_application_topped_cb(gpointer app);


/**
 * Application destroy event callback
 *
 * @param widget Application window
 * @param userdata NULL
 */
gboolean fm_application_destroy_cb(GtkWidget *window, GdkEvent *,
				   gpointer userdata);


/**
 * Event invoked on hard key signal
 *
 * @param widget Widget from which the event is generated.
 * @param event Event key
 * @param app Application main window
 *
 * @return FALSE
 */
gboolean on_file_selection_key_release(GtkWidget * widget, GdkEvent * event, gpointer app);
gboolean on_file_selection_key_press (GtkWidget * widget, GdkEvent * event, gpointer app);

GtkWidget *create_popup_menu (HildonProgram *prog, HildonWindow *window,
			      HildonFileSelection *fs);

GtkMenu *create_main_menu (HildonProgram *prog, HildonWindow *window,
			   HildonFileSelection *fs);

/**
 * Invoked on application startup timer event
 *
 * @param app HildonApp
 *
 * @return TRUE to continue timer event, FALSE to abort
 */
gboolean on_fm_timer(gpointer app);


/** Starts GW invocation wizard at startup
 */
void invoke_gw_wizard();

DBusHandlerResult
backup_signal_cb(DBusConnection * connection, DBusMessage * message, void *user_data);


gboolean send_wait_message(gpointer app);

//BEG: Toolbar buttons callback functions

/**
 * on_toolbar_find_clicked:
 * SP+
 */
void on_toolbar_find_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_newfolder_clicked:
 * SP+
 */
void on_toolbar_newfolder_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_moveto_clicked:
 * SP+
 */
void on_toolbar_moveto_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_detail_clicked:
 * SP+
 */
void on_toolbar_detail_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_delete_clicked:
 * SP+
 */
void on_toolbar_delete_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_listview_clicked:
 * SP+
 */
void on_toolbar_listview_clicked (GtkButton * button, gpointer data);

/**
 * on_toolbar_thumbview_clicked:
 * SP+
 */
void on_toolbar_thumbview_clicked (GtkButton * button, gpointer data);

//END: Toolbar buttons callback functions

void osso_fm_mmc_format (const char *device);
void osso_fm_mmc_rename (OSSOFileManager* ofm,
			 const char *uri, const char *device);

void osso_fm_setup_fullscreening_signals ();

#endif
