/* -*- mode: C; c-file-style: "stroustrup"; indent-tabs-mode: nil; -*- */

/**
 * @file hildon-shorten-names-dialog.h
 *
 * This file contains the API declarations for shorten file names dialog.
 *
 * Copyright (C) 2005 Nokia Corporation
 */


#ifndef __HILDON_SHORTEN_NAMES_DIALOG_H__
#define __HILDON_SHORTEN_NAMES_DIALOG_H__

#include <gtk/gtkliststore.h>
#include <gtk/gtkdialog.h>
#include <glib.h>

G_BEGIN_DECLS
#define HILDON_TYPE_SHORTEN_NAMES_DIALOG \
( hildon_shorten_names_dialog_get_type() )
#define HILDON_SHORTEN_NAMES_DIALOG(obj) \
  (GTK_CHECK_CAST (obj, HILDON_TYPE_SHORTEN_NAMES_DIALOG,\
HildonShortenNamesDialog))
#define HILDON_SHORTEN_NAMES_DIALOG_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), HILDON_TYPE_SHORTEN_NAMES_DIALOG, \
HildonShortenNamesDialogClass))
#define HILDON_IS_SHORTEN_NAMES_DIALOG(obj) \
(GTK_CHECK_TYPE (obj, HILDON_TYPE_SHORTEN_NAMES_DIALOG))
#define HILDON_IS_SHORTEN_NAMES_DIALOG_CLASS(klass) \
(GTK_CHECK_CLASS_TYPE ((klass), HILDON_TYPE_SHORTEN_NAMES_DIALOG))
typedef struct _HildonShortenNamesDialog HildonShortenNamesDialog;
typedef struct _HildonShortenNamesDialogClass
 HildonShortenNamesDialogClass;

struct _HildonShortenNamesDialog {
	GtkDialog parent;
};

struct _HildonShortenNamesDialogClass {
	GtkDialogClass parent_class;
};

GType hildon_shorten_names_dialog_get_type(void);

/* here should be a gtkListStore parameter */
GtkWidget *hildon_shorten_names_dialog_new(GtkWindow * parent);

void hildon_shorten_names_dialog_set_model(HildonShortenNamesDialog *
					   dialog, GtkListStore * store, gint max_length);
GtkTreeModel *hildon_shorten_names_dialog_get_model(HildonShortenNamesDialog * dialog);
gboolean hildon_shorten_names_dialog_get_automatic(HildonShortenNamesDialog * dialog);

G_END_DECLS
#endif
