import os
import time
import dbus
import subprocess

device = 'device'

VOLUME_HEADPHONE = 85

HOOKDET_DETECT_INTERVAL = 50
HOOKDET_POLL_LIMIT = 600
HOOKDET_CONFIDENCE_THRESHOLD = 10

MVI_GCONF_PATH = "/apps/osso/sound/master_volume"

GPIO_HEADPHONE_STATE = "/sys/devices/platform/gpio-switch/headphone/state"
RETU_ENABLE     = "/sys/devices/platform/retu-headset/enable"
RETU_ENABLE_DET = "/sys/devices/platform/retu-headset/enable_det"
RETU_HOOKDET    = "/sys/devices/platform/retu-headset/hookdet"

server_object_path = \
    "/com/nokia/osso_hp_ls_controller"
HP_LS_CONTROLLER_DBUS_INTERFACE_NAME = \
    "com.nokia.osso_hp_ls_controller"
HP_LS_CONTROLLER_DBUS_LOUDSPEAKER_INTERFACE_NAME = \
    "com.nokia.osso_hp_ls_controller.loudspeaker"
HP_LS_CONTROLLER_DBUS_HEADSET_INTERFACE_NAME = \
    "com.nokia.osso_hp_ls_controller.headset"
HP_LS_CONTROLLER_DBUS_ERROR_INTERFACE_NAME = \
    "com.nokia.osso_hp_ls_controller.error"
HP_LS_SERVICE_NAME = \
    "com.nokia.osso_hp_ls_controller"

HEADSET_BUTTON_SERVICE     = "com.nokia.osso_hp_ls_controller"
AUDIO_PM_SERVICE           = "com.nokia.osso_audio_pm"
HEADSET_BUTTON_RESOURCE    = "/com/nokia/osso/headset/button"
AUDIO_PM_PLAYBACK_RESOURCE = "/com/nokia/osso/pm/audio/playback"
AUDIO_PM_RECORD_RESOURCE   = "/com/nokia/osso/pm/audio/record"

RESOURCE_INTERFACE    = "com.nokia.osso_resource_manager"

hss_obj  = dbus.SessionBus().get_object(HP_LS_CONTROLLER_DBUS_INTERFACE_NAME,
                                        server_object_path)

rec_obj  = dbus.SystemBus().get_object(AUDIO_PM_SERVICE,
                                       AUDIO_PM_RECORD_RESOURCE)
play_obj = dbus.SystemBus().get_object(AUDIO_PM_SERVICE,
                                       AUDIO_PM_PLAYBACK_RESOURCE)
btn_obj  = dbus.SystemBus().get_object(HEADSET_BUTTON_SERVICE,
                                       HEADSET_BUTTON_RESOURCE)

loudspeaker = dbus.Interface(hss_obj,
                             HP_LS_CONTROLLER_DBUS_LOUDSPEAKER_INTERFACE_NAME)
headset     = dbus.Interface(hss_obj,
                             HP_LS_CONTROLLER_DBUS_HEADSET_INTERFACE_NAME)

record   = dbus.Interface(rec_obj,  RESOURCE_INTERFACE)
playback = dbus.Interface(play_obj, RESOURCE_INTERFACE)
button   = dbus.Interface(btn_obj,  RESOURCE_INTERFACE)

def command(cmd):
    opts = []
    if os.environ.has_key('FAKED_MODE'):
        # fakeroot - must specify config and identity files
        home = os.environ['HOME']
        opts = [ '-F', '%s/.ssh/config' % home,
                 '-o', 'UserKnownHostsFile %s/.ssh/known_hosts' % home ]
        for f in [ '%s/.ssh/identity' % home,
                   '%s/.ssh/id_rsa'   % home,
                   '%s/.ssh/id_dsa'   % home ]:
            if os.path.exists(f):
                opts += ['-i', f]

    if not os.environ.has_key('LAUNCHWRAPPER_NICE'):
        # use ssh unless we appear to be running on the device
        opts = ['ssh', '-t', '-q'] + opts + [device]

    p = subprocess.Popen(opts + [cmd],
                         stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT)

    stdout, stderr = p.communicate()
    firstline = (stdout+'\n').splitlines()[0]
    assert p.returncode == 0, 'command failed: %s' % firstline
    return stdout

def test_capture_switch():
    output = command('./amixer -D master sget Capture')
    if output.find('[on]') >= 0: return True
    if output.find('[off]') >= 0: return False
    assert False, "couldn't parse amixer output"

def get_master_volume():
    return int(command('gconftool --get %s' % MVI_GCONF_PATH))

def set_master_volume(volume):
    command('gconftool --type int --set %s %d' % (MVI_GCONF_PATH, volume))
    return get_master_volume()

def get_sysfs(name):
    return command('cat %s' % name)

def set_sysfs(name, value):
    command('echo %s >%s' % (value, name))

def headphone_state():
    return get_sysfs(GPIO_HEADPHONE_STATE).strip()

def wait_headphones(state):
    while not headphone_state() == state:
        time.sleep(1)
