#ifndef ROUTE_H_
# define ROUTE_H_

#include <glib.h>
#include "dsp.h"

#define ROUTE_GCONF_MASTER_VOLUME_PATH	"/apps/osso/sound/master_volume"

gboolean		route_initialize		(dsp_info_t	*dspinfo);
void			route_deinitialize		(void);

gboolean		route_force_loudspeaker		(gboolean	force);
gboolean		route_force_bt			(gboolean	force);
void			route_set_hp_plugged		(gboolean	plugged);

void			route_set_gconf_volume		(int volume);
int			route_get_gconf_volume		(void);

/* accessory functions should moved elsewhere */
void			mic_set_powersave		(gboolean	powersave);
void			hp_set_poll_button		(gboolean	poll_button);

#endif /* ROUTE_H_ */
