/**
 * Copyright (C) 2005 Nokia Corporation
 * Contact: Makoto Sugano <makoto.sugano@nokia.com>
 */
#ifndef _RESOURCE_H_
# define _RESOURCE_H_

typedef enum {
  RESOURCE_STATUS_OK
} ResourceStatus;

typedef struct {
  ResourceStatus  status;
  gint            handle;
  const gchar    *reason;
} ResourceResult;

typedef enum {
  RESOURCE_ACTION_REQUEST,
  RESOURCE_ACTION_RELEASE,
  RESOURCE_ACTION_UNREGISTER
} ResourceAction;

/* handler must return TRUE if the resource is recoginzed */
typedef gboolean (*ResourceHandler)	(ResourceAction    action, const gchar      *resource,
					 ResourceResult   *result, gpointer         *args);

gboolean  resource_init			(DBusConnection   *bus);

gboolean  resource_manage		(const gchar      *name,
					 const gchar      *path,
					 const gchar      *signature,
					 ResourceHandler   handler);
gboolean  resource_request_wrapper	(const gchar      *resource,
					 const gchar      *sender,
					 ResourceHandler   handler);
gboolean  resource_release_wrapper	(const gchar      *resource,
					 const gchar      *sender);

/* not part of resource API, here for compatibility */
gboolean record_resource_handler		(ResourceAction  action,
						 const gchar    *resource,
						 ResourceResult *result,
						 gpointer       *args);
gboolean button_resource_handler		(ResourceAction		action,
						 const gchar *		resource,
						 ResourceResult *	result,
						 gpointer *		args);

#endif /* _RESOURCE_H_ */
