#ifndef MVI_H_
# define MVI_H_
#include <glib.h>

#define INVALID      0
#define HEADSET      1
#define HEADPHONE    2
#define LOUDSPEAKER  3

int		MVI_open		(void);
void		MVI_setMicMute		(int state);
int		MVI_close		(void);
int		MVI_setBT		(int enable);
int		MVI_getBT		(void);

/* Sets the output (`state') to either HEADPHONE, HEADSET or
 * LOUDSPEAKER. `fd_in' is a dummy parameter. Returns
 * a negative value on failure. */
int MVI_setState(int state_in);

/* Sets the volume, which must be in the range [-101:100].
 * Returns a negative value on failure. */
int MVI_setVolume(int volume_in);
int MVI_getVolume(void);

const char *	mvi_get_snd_card_name	(void);

#endif /* MVI_H_ */
