/**
 * GConf handling functions.
 * Copyright (C) 2005-2007 Nokia Corporation
 * Contact: Makoto Sugano <makoto.sugano@nokia.com>
 */
#include <glib.h>
#include <stdio.h>
#include <gconf/gconf-client.h>
#include <osso-log.h>

#include "gconf.h"

static void
gconf_volume_changed_cb (GConfClient* client, guint cnxn_id,
                         GConfEntry* entry, gpointer user_data)
{
  int			*vol = user_data;

  g_return_if_fail (vol != NULL);
  ULOG_DEBUG("gconf_volume_changed_cb");

  if (gconf_entry_get_value (entry) != NULL && gconf_entry_get_value (entry)->type == GCONF_VALUE_INT) {
    *vol = gconf_value_get_int(gconf_entry_get_value (entry));
    ULOG_DEBUG ("volume changed - %d", *vol);
  }
}

static void
gconf_mv_changed_cb (GConfClient* client, guint cnxn_id,
                     GConfEntry* entry, gpointer user_data)
{
  ias_data_s *ias_data = (ias_data_s *) user_data;

  g_return_if_fail (ias_data != NULL);

  if (gconf_entry_get_value (entry) != NULL && gconf_entry_get_value (entry)->type == GCONF_VALUE_INT) {
    ias_data->muted = (gconf_value_get_int (gconf_entry_get_value(entry)) < 0);
  }
}

const char *
gconf_get_string        (const char *path)
{
  GConfClient *client = gconf_client_get_default();
  return gconf_client_get_string(client, path, NULL);
}


int
gconf_get_int           (const char *path)
{
  GConfClient *client = gconf_client_get_default();
  return gconf_client_get_int(client, path, NULL);
}

void
gconf_setup_callbacks   (ias_data_s *ias_data)
{
  ULOG_DEBUG("gconf_setup_callbacks");

  GConfClient* client = gconf_client_get_default ();
  g_return_if_fail (ias_data != NULL);

  gconf_client_add_dir (client, INTERACTION_GCONF_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);

  ias_data->ts_volume_gconf_id = gconf_client_notify_add (client, TS_VOLUME_GCONF_PATH,
							  gconf_volume_changed_cb, &ias_data->ts_volume,
							  NULL, NULL);
    
  ias_data->kb_volume_gconf_id = gconf_client_notify_add (client, KB_VOLUME_GCONF_PATH,
							  gconf_volume_changed_cb, &ias_data->kb_volume,
							  NULL, NULL);

  ias_data->master_volume_gconf_id = gconf_client_notify_add (client, MASTER_VOLUME_GCONF_PATH,
							      gconf_mv_changed_cb, ias_data,
							      NULL, NULL);
}

void
gconf_remove_callbacks	(ias_data_s *ias_data)
{
  ULOG_DEBUG("gconf_remove_callbacks");

  GConfClient* client = gconf_client_get_default();
  g_return_if_fail (ias_data != NULL);

  if (ias_data->kb_volume_gconf_id != -1) {
    gconf_client_notify_remove (client, ias_data->kb_volume_gconf_id);
    ias_data->kb_volume_gconf_id = -1;
  }

  if (ias_data->ts_volume_gconf_id != -1) {
    gconf_client_notify_remove (client, ias_data->ts_volume_gconf_id);
    ias_data->ts_volume_gconf_id = -1;
  }

  if (ias_data->master_volume_gconf_id) {
    gconf_client_notify_remove(client, ias_data->master_volume_gconf_id);
    ias_data->master_volume_gconf_id = 0;
  }
}

