/**
 * Copyright (C) 2007 Nokia Corporation
 * Contact: Marc-Andre Lureau <marc-andre.lureau@nokia.com>
 */
#ifndef EVDEV_H_
# define EVDEV_H_

#include <linux/input.h>
#include <glib.h>

#define EVDEV_MAX_NAME_LEN	256
#define EVDEV_BASENAME_FORMAT	"/dev/input/event%d"

typedef struct evdev_s {
  gchar		name[EVDEV_MAX_NAME_LEN];
  char		bitmask[EV_MAX/8 + 1];
  gchar	*	filename;
  int		fd;
  GIOChannel *	io_channel;
  int		ref_count;
} evdev_t;


typedef gboolean		(* evdev_func)				(evdev_t *evdev, gpointer data);

evdev_t	*			evdev_new				(char *filename);
int				evdev_open				(evdev_t *evdev, int flags);
const char *			evdev_get_name				(evdev_t *evdev);
const char *			evdev_get_filename			(evdev_t *evdev);
GIOChannel *			evdev_get_io_channel			(evdev_t *evdev);
gboolean			evdev_get_absinfo			(evdev_t *evdev, guint32 *min, guint32 *max, guint32 *fuzz, guint32 *flat);  
gboolean			evdev_has_type				(evdev_t *evdev, const int ev_type);
evdev_t *			evdev_ref				(evdev_t *evdev);
void				evdev_unref				(evdev_t *evdev);
void				evdev_foreach				(evdev_func func, gpointer data);

#endif	/* !EVDEV_H_ */
