/**
 * Copyright (C) 2005-2007 Nokia Corporation
 * Contact: Makoto Sugano <makoto.sugano@nokia.com>
 */
#ifndef DSP_H_
#define DSP_H_

#include <glib.h>
#include "common.h"

#define DSP_VOLUME_DEFAULT  0xFFFF
#define DSP_VOLUME_MAX      0xFFFF
#define DSP_NODE_NAME "/dev/dsptask/pcm0"
#define DSP_TIMER_TIMEOUT   10*1000

dsp_info_s *		ias_dsp_initialize			(gchar *name);
void			ias_dsp_close				(dsp_info_s *dspinfo);
gboolean		ias_dsp_reset				(dsp_info_s *dsp);
void			ias_dsp_set_sleep			(dsp_info_s *dsp, gboolean mode);
void			ias_dsp_timer_handle_timer		(dsp_info_s *dsp);
gboolean		ias_dsp_play_sample			(dsp_info_s *dspinfo, gchar *sample,
								 gulong sample_len, gint volume);
#endif /* DSP_H_ */
