/**
 * Copyright (C) 2005-2007 Nokia Corporation
 * Contact: Makoto Sugano <makoto.sugano@nokia.com>
 */
#ifndef COMMON_H_
#define  COMMON_H_

#include <glib.h>
#include <tslib.h>
#include "wav.h"

#define INTERACTION_GCONF_PATH "/apps/osso/sound"
#define TS_VOLUME_GCONF_PATH "/apps/osso/sound/touchscreen_volume"
#define KB_VOLUME_GCONF_PATH "/apps/osso/sound/keypad_volume"
#define MASTER_VOLUME_GCONF_PATH "/apps/osso/sound/master_volume"

#define TS_SAMPLE_PATH "/usr/share/sounds/ui-pen_down.wav"
#define KB_SAMPLE_PATH "/usr/share/sounds/ui-key_press.wav"

#define DSP_MAX_INIT_ITER 10
#define DSP_INIT_SLEEP 2

typedef struct {
  gchar *	name;
  int		write_pending;
  int		fd;
  int		curr_volume;
  int 		dsp_sample_buffer_size;
  int 		dsp_mmap_buffer_size;
  int 		dsp_write_size;
  short int *	mmap_buf_addr;
  gboolean	sleeping;
  gboolean	timeout_pending;
  guint		timeout_id;
} dsp_info_s;

typedef struct {
  dsp_info_s *	dsp;
  gboolean	running;
  gboolean	locked;
  gboolean	muted;
  guint		ts_volume_gconf_id;
  guint		kb_volume_gconf_id;
  guint		master_volume_gconf_id;
  struct tsdev *ts_dev;
  gboolean	ts_dev_pressed;
  GSList *	evdev_list;
  wav_info_t *	ts_wav;
  gint		ts_volume;
  wav_info_t *	kb_wav;
  gint		kb_volume;
  gint		touchscreen_io_timeout_id;
} ias_data_s;

#endif /* COMMON_H_ */
