#include <dsp/interface_common.h>
#include <dsp/audiopp_dsptask.h>

#define HAVE_770

#ifdef HOST_ARM
# ifdef HAVE_770
MUSICDRC_RUNTIME_PARAMS musicdrc_ihf = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007E89,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00002448, 0x00002448 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x00000F5C, 0xFFFFE667, 0xFFFFCCCE, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x000023D7, 0xFFFFB334, 0xFFFFC001, 0xFFFFD99B, 0xFFFF8001 },
        { 0x00000000, 0x00001C29, 0xFFFFCCCE, 0xFFFFB334, 0xFFFFE667, 0xFFFF8001 },
        { 0x00000000, 0x0000170A, 0xFFFFCCCE, 0xFFFFC001, 0xFFFFE667, 0xFFFF8001 },
        { 0x00000000, 0x0000147B, 0xFFFFCCCE, 0xFFFFC001, 0xFFFFE667, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3EA98A05, 0x3F800000, 0x3F21866C, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3D9B5B50, 0x3F21866C, 0x3F4B5918, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E06FD4F, 0x3F642905, 0x3F0FF59A, 0x3F642905, 0x3F8F9E4D },
        { 0x3F800000, 0x3E431E82, 0x3F353BEF, 0x3F0FF59A, 0x3F4B5918, 0x3FA12478 },
        { 0x3F800000, 0x3E6A95B9, 0x3F21866C, 0x3F004DCE, 0x3F353BEF, 0x3FB4CE08 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_hp = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007215,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_hs48 = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007215,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_bt = {
  .dsp_cmd		= DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS, 
  .alignment		= 1, 
  .use_mumdrc		= 0, 
  .linkCoeffSelf	= 16384, 
  .linkCoeffOthers	= 0, 
  .lim_attCoeff		= 0x0022, 
  .lim_relCoeff		= 0x0A3B, 
  .limiterThreshold	= 0x00007215, 
  .limGain		= 0x00000000, 
  /* For attack and release time filtering. attCoeff[NUM_BANDS],
   * and relCoeff[NUM_BANDS]
   */ 
  .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
  .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
  /* For the average amplitude to gain calculation. 
   *  levelLimits[NUM_BANDS][LINE_SEGMENT_COUNT]
   *   K[NUM_BANDS][LINE_SEGMENT_COUNT+1]
   *   A[NUM_BANDS][LINE_SEGMENT_COUNT+1]
   */ 
  .levelLimits = {
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
  },
  .K = {
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 }
  },
  .A = {
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 }
  }, 
};
# else
MUSICDRC_RUNTIME_PARAMS musicdrc_ihf = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .mode             = MUSICDRC_MODE_IHF,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007E89,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00002448, 0x00002448 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x0000040C, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x00000F5C, 0xFFFFE667, 0xFFFFCCCE, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x000023D7, 0xFFFFB334, 0xFFFFC001, 0xFFFFD99B, 0xFFFF8001 },
        { 0x00000000, 0x00001C29, 0xFFFFCCCE, 0xFFFFB334, 0xFFFFE667, 0xFFFF8001 },
        { 0x00000000, 0x0000170A, 0xFFFFCCCE, 0xFFFFC001, 0xFFFFE667, 0xFFFF8001 },
        { 0x00000000, 0x0000147B, 0xFFFFCCCE, 0xFFFFC001, 0xFFFFE667, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3EA98A05, 0x3F800000, 0x3F21866C, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3D9B5B50, 0x3F21866C, 0x3F4B5918, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E06FD4F, 0x3F642905, 0x3F0FF59A, 0x3F642905, 0x3F8F9E4D },
        { 0x3F800000, 0x3E431E82, 0x3F353BEF, 0x3F0FF59A, 0x3F4B5918, 0x3FA12478 },
        { 0x3F800000, 0x3E6A95B9, 0x3F21866C, 0x3F004DCE, 0x3F353BEF, 0x3FB4CE08 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_hp = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .mode             = MUSICDRC_MODE_HP,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007215,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFE667, 0x00000000, 0x00000000, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F21866C, 0x3F800000, 0x3F800000, 0x3F800000 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_hs48 = {
    .dsp_cmd          = DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS,
    .mode             = MUSICDRC_MODE_HS,
    .use_mumdrc       = 1,
    .linkCoeffSelf    = 16384,
    .linkCoeffOthers  = 0,
    .lim_attCoeff     = 0x0022,
    .lim_relCoeff     = 0x0A3B,
    .limiterThreshold = 0x00007215,
    .limGain          = 0x00000000,
    .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
    .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
    .levelLimits = {
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
        { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
    },
    .K = {
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
        { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 }
    },
    .A = {
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
        { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 }
    },
};

const MUSICDRC_RUNTIME_PARAMS musicdrc_bt = {
  .dsp_cmd		= DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS, 
  .alignment		= 1, 
#  ifdef MUSICDRC_MODE_BT
  .mode			= MUSICDRC_MODE_BT,
#  else
  .mode			= MUSICDRC_MODE_HS,
#  endif
  .use_mumdrc		= 0, 
  .linkCoeffSelf	= 16384, 
  .linkCoeffOthers	= 0, 
  .lim_attCoeff		= 0x0022, 
  .lim_relCoeff		= 0x0A3B, 
  .limiterThreshold	= 0x00007215, 
  .limGain		= 0x00000000, 
  /* For attack and release time filtering. attCoeff[NUM_BANDS],
   * and relCoeff[NUM_BANDS]
   */ 
  .attCoeff = { 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50, 0x00001C50 },
  .relCoeff = { 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3, 0x000000A3 },
  /* For the average amplitude to gain calculation. 
   *  levelLimits[NUM_BANDS][LINE_SEGMENT_COUNT]
   *   K[NUM_BANDS][LINE_SEGMENT_COUNT+1]
   *   A[NUM_BANDS][LINE_SEGMENT_COUNT+1]
   */ 
  .levelLimits = {
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 },
    { 0x00000003, 0x00000068, 0x00000CCD, 0x0000287A, 0x00008000 }
  },
  .K = {
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 },
    { 0x00000000, 0x0000199A, 0xFFFFF334, 0xFFFFE667, 0xFFFFF334, 0xFFFF8001 }
  },
  .A = {
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 },
    { 0x3F800000, 0x3E224B06, 0x3F8F9E4D, 0x3F642905, 0x3F800000, 0x3F800000 }
  }, 
};
# endif
#else
const MUSICDRC_RUNTIME_PARAMS musicdrc_ihf;
const MUSICDRC_RUNTIME_PARAMS musicdrc_hp;
const MUSICDRC_RUNTIME_PARAMS musicdrc_hs48;
const MUSICDRC_RUNTIME_PARAMS musicdrc_bt;
#endif

const MUSICDRC_HPFILTER_COEFFS hpfilter_ihf = {
    .dsp_cmd = DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS,
    .use_hpfilt = 1,
    .coeffs = {
        1, 9, -1, 0, -7361, -9418, -2, 1, -9247, 18522, 3, 6851, 14419, 17529,
        9120, -16539, 16384
    }
};

const MUSICDRC_HPFILTER_COEFFS hpfilter_hp = {
    .dsp_cmd = DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS,
    .use_hpfilt = 0,
    .coeffs = {
        0, 5, -10, 1, -14941, 31259, 10, 15646, -31292, 15646,
    }
};

const MUSICDRC_HPFILTER_COEFFS hpfilter_hs48 = {
    .dsp_cmd = DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS,
    .use_hpfilt = 1,
    .coeffs = {
        0x0001, 0x0009, 0xfff7, 0x0000, 0x4bee, 0x33ca, 0x0003, 0x0001, 0xe343,
        0x41ad, 0x0006, 0xc142, 0xd604, 0x6b34, 0x2756, 0xa964, 0x4000
    }
};
