/**
 * Copyright (C) 2005-2007 Nokia Corporation
 * Contact: Makoto Sugano <makoto.sugano@nokia.com>
 */

#ifndef DSP_H_
# define DSP_H_

#include <glib.h>

#ifdef HOST_ARM
# define DSP_TASK_PATH		"/dev/dsptask/audiopp"
#else
# define DSP_TASK_PATH		"/dev/null"
#endif

#define DSP_MAX_INIT_ITER	10
#define DSP_INIT_SLEEP		2

typedef struct	dsp_info_s {
  gchar		*name;
  int		fd;
} dsp_info_t;

enum e_dsp_mode {
  DSP_MODE_HS,
  DSP_MODE_HP,
  DSP_MODE_IHF,
  DSP_MODE_BT
};

enum e_dsp_rx {
  DSP_RX_NONE,
  DSP_RX_34,
  DSP_RX_44
};

dsp_info_t*	dsp_initialize					(const gchar *path, enum e_dsp_rx rx);
void		dsp_close					(dsp_info_t *dspinfo);
void		dsp_set_mode					(dsp_info_t *dsp, enum e_dsp_mode dspmode);

#endif /* !DSP_H_ */
