/*
** Bluez audio/headset proxy
** (c) Nokia MM 2007
*/

#ifndef BLUEZ_AUDIO_PROXY_H_
# define BLUEZ_AUDIO_PROXY_H_

#include <glib.h>

enum bt_audio_state_e {
  BT_AUDIO_STATE_NONE,
  BT_AUDIO_STATE_DISCONNECTED,
  BT_AUDIO_STATE_CONNECTED,
  BT_AUDIO_STATE_STOPPED,
  BT_AUDIO_STATE_PLAYING_PM,
  BT_AUDIO_STATE_PLAYING,
};

enum bluez_headset_flags_e {
  BLUEZ_HEADSET_AUTO_PLAY	= 1 << 0,
  BLUEZ_HEADSET_PM		= 1 << 1,
  BLUEZ_HEADSET_MUTED		= 1 << 2,
/*   BLUEZ_HEADSET_DEFAULT		= 1 << 2, */
  BLUEZ_HEADSET_LAST		= 1 << 6,
};

enum bluez_headset_notify_e {
  BLUEZ_HEADSET_NOTIFY_STATE,
  BLUEZ_HEADSET_NOTIFY_VOLUME,
/*   BLUEZ_HEADSET_NOTIFY_FLAGS,  */
};

typedef enum bt_audio_state_e		bt_audio_state_t;
typedef enum bluez_headset_flags_e	bluez_headset_flags_t;
typedef enum bluez_headset_notify_e	bluez_headset_notify_t;
typedef struct bluez_headset_proxy_s	bluez_headset_proxy_t;
typedef struct bluez_audio_proxy_s	bluez_audio_proxy_t;

typedef void (* headset_func_t) (bluez_headset_proxy_t *headset, gpointer data);
typedef void (* headset_updated_func_t) (bluez_headset_proxy_t *headset, bluez_headset_notify_t field, gpointer data);

struct bluez_audio_proxy_s {
  int					refcount;
  DBusConnection *			sysbus;
  char *				audio_service;
  GHashTable *				headsets;
  bluez_headset_flags_t 		headset_default_flags;
  headset_updated_func_t		headset_updated_cb;
  gpointer				headset_state_data;
};


struct bluez_headset_proxy_s {
  int					refcount;
  bluez_audio_proxy_t *			audio_proxy;
  char *				path;
  bt_audio_state_t			state;
  bluez_headset_flags_t			flags;
  unsigned char				volume;
  signed char				req_volume;
};

bluez_audio_proxy_t *	bluez_audio				(DBusConnection *system_bus);
gboolean		bluez_audio_is_active			(bluez_audio_proxy_t *proxy);
void			bluez_audio_unref			(bluez_audio_proxy_t *proxy);
bluez_audio_proxy_t *	bluez_audio_ref				(bluez_audio_proxy_t *proxy);
bluez_headset_proxy_t *	bluez_audio_headset_get			(bluez_audio_proxy_t *proxy, const char *path);
bluez_headset_proxy_t *	bluez_audio_headset_get_default		(bluez_audio_proxy_t *proxy);
void			bluez_audio_headset_foreach		(bluez_audio_proxy_t *proxy, headset_func_t func, 
								 gpointer user_data, GDestroyNotify destroy_notify);
void			bluez_audio_headset_set_default_flags	(bluez_audio_proxy_t *proxy, bluez_headset_flags_t flags, gboolean override_all);
bluez_headset_flags_t	bluez_audio_headset_get_default_flags   (bluez_audio_proxy_t *proxy);
void			bluez_audio_headset_set_updated_cb	(bluez_audio_proxy_t *proxy, headset_updated_func_t cb, gpointer data);

bluez_headset_proxy_t * bluez_headset_ref			(bluez_headset_proxy_t *headset);
void			bluez_headset_unref			(bluez_headset_proxy_t *headset);
void			bluez_headset_call			(bluez_headset_proxy_t *headset, const gchar *method);
void			bluez_headset_set_state			(bluez_headset_proxy_t *headset, bt_audio_state_t state);
void			bluez_headset_set_volume		(bluez_headset_proxy_t *headset, unsigned char volume);
void			bluez_headset_set_flags			(bluez_headset_proxy_t *headset, bluez_headset_flags_t flags);
bt_audio_state_t	bluez_headset_get_state			(bluez_headset_proxy_t *headset);
unsigned char		bluez_headset_get_volume		(bluez_headset_proxy_t *headset);
bluez_headset_flags_t	bluez_headset_get_flags			(bluez_headset_proxy_t *headset);

#endif	/* !BLUEZ_AUDIO_PROXY_H_ */
