#ifndef _STORAGE_DEVICE_H_
#define _STORAGE_DEVICE_H_

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _StorageDeviceClass  StorageDeviceClass;
typedef struct _StorageDevice       StorageDevice;
typedef enum   _StorageDeviceKey    StorageDeviceKey;
typedef enum   _StorageDeviceStatus StorageDeviceStatus;

enum _StorageDeviceKey
{
  STORAGE_DEVICE_NONE,
  STORAGE_DEVICE_FLASH,
  STORAGE_DEVICE_INTERNAL_MMC,
  STORAGE_DEVICE_EXTERNAL_MMC
};

GType storage_device_key_get_type(void);
#define STORAGE_DEVICE_KEY_TYPE_STRING "StorageDeviceKey"
#define STORAGE_DEVICE_KEY_TYPE (storage_device_key_get_type())

enum _StorageDeviceStatus
{
  STORAGE_DEVICE_AVAILABLE,
  STORAGE_DEVICE_UNAVAILABLE,
  STORAGE_DEVICE_USB_OBSCURED,
  STORAGE_DEVICE_COVER_OPEN,
  STORAGE_DEVICE_CORRUPTED
};

GType storage_device_status_get_type(void);
#define STORAGE_DEVICE_STATUS_TYPE_STRING "StorageDeviceStatus"
#define STORAGE_DEVICE_STATUS_TYPE (storage_device_status_get_type())

struct _StorageDeviceClass
{
  GObjectClass parent_class;
};

struct _StorageDevice
{
  GObject parent_instance;
};

GType storage_device_get_type(void);

#define STORAGE_DEVICE_TYPE_STRING "StorageDevice"
#define STORAGE_DEVICE_TYPE (storage_device_get_type())
#define STORAGE_DEVICE(object) (G_TYPE_CHECK_INSTANCE_CAST((object), STORAGE_DEVICE_TYPE, StorageDevice))

G_END_DECLS

#endif /* !_STORAGE_DEVICE_H_ */
