#include <stdlib.h>
#include <gtk/gtk.h>
#include <libosso.h>
#include <hildon/hildon.h>
#include <hildon/hildon-help.h>
#include "storagedevice.h"
#include "deviceinfo.h"
#include "swap_ui.h"
#include "oam.h"
#include "i18n.h"

static void create_memory_applet(MemoryApplet *applet, GtkWindow *parent, osso_context_t *osso);
static void extend_notify_active(GtkWidget *checkbox, GParamSpec *pspec, GtkWidget *caption);
static void internal_mmc_changed(StorageDevice *internal_mmc, GParamSpec *pspec, MemoryApplet *applet);
static void applet_notebook_switch_page(GtkWidget *notebook, GtkNotebookPage *page, guint page_num, MemoryApplet *applet);
osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated);

//#define ADD_DIALOG_BUTTON_PRESS
#ifdef ADD_DIALOG_BUTTON_PRESS
static gboolean
dialog_button_press(GtkWidget *dialog, GdkEventButton *button, gpointer null)
{
  gint x, y;

  gdk_window_get_position(dialog->window, &x, &y);
  gdk_window_move(dialog->window, x, y + 1);
  //g_print("[%dx%d]\n", dialog->requisition.width, dialog->requisition.height);
  return FALSE;
}
#endif /* ADD_DIALOG_BUTTON_PRESS */

static gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer null)
{
  return TRUE;
}

osso_return_t
execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
  MemoryApplet memory_applet;
  gboolean updated_swap = TRUE;
  
  (void) bindtextdomain(PACKAGE, LOCALEDIR);
  create_memory_applet(&memory_applet, GTK_WINDOW(data), osso);
#ifdef ADD_DIALOG_BUTTON_PRESS
  gtk_widget_add_events(memory_applet.dialog, GDK_BUTTON_PRESS_MASK);
  g_signal_connect(memory_applet.dialog, "button-press-event", (GCallback)dialog_button_press, NULL);
#endif /* ADD_DIALOG_BUTTON_PRESS */

  while (GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(memory_applet.dialog))) {

    if (getenv("OSSO_SWAP")) {
      /* Don't want the swap page updating spuriously */
      g_signal_handlers_block_by_func(memory_applet.internal_mmc, internal_mmc_changed, &memory_applet);
      updated_swap = maybe_update_swap(&memory_applet);
      g_signal_handlers_unblock_by_func(memory_applet.internal_mmc, internal_mmc_changed, &memory_applet);

      if (updated_swap)
        break;
      else {
        StorageDeviceStatus status;

        g_object_get(G_OBJECT(memory_applet.internal_mmc), "status", &status, NULL);
        swap_page_update(&memory_applet, status);
      }
    } else {
      break;
    }
  }

  gtk_widget_destroy(memory_applet.dialog);

  return OSSO_OK;
}

#ifdef RUN_STANDALONE
int
main (int argc, char **argv)
{
  osso_context_t *osso = NULL;

  osso = osso_initialize("oam", "0.0.1", TRUE, NULL);

  gtk_init(&argc, &argv);
  /* gtk_thread_init() should not be necessary */
  g_thread_init(NULL);

  bind_textdomain_codeset(PACKAGE, "UTF-8");
  textdomain(PACKAGE);

  execute(osso, NULL, FALSE);

  osso_deinitialize(osso);

  return 0;
}
#endif /* RUN_STANDALONE */

static void
create_memory_applet(MemoryApplet *applet, GtkWindow *parent, osso_context_t *osso)
{
  GtkCellRenderer *cr = NULL;
  GtkSizeGroup *sg = NULL;
  GtkWidget *vbox = NULL, *vbox1 = NULL;
  GtkWidget *caption = NULL;

  applet->osso = osso;
  applet->dialog_parent = GTK_WIDGET(parent);

  /* Dialog =======================*/
  applet->dialog = gtk_dialog_new_with_buttons(_("memo_ti_memory"), parent, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_NO_SEPARATOR, NULL);
  g_signal_connect(G_OBJECT(applet->dialog), "delete-event", (GCallback)delete_event, NULL);
  gtk_dialog_add_buttons(GTK_DIALOG(applet->dialog), _("memo_bd_ok"), GTK_RESPONSE_OK, _("memo_bd_cancel"), GTK_RESPONSE_CANCEL, NULL);
  hildon_help_dialog_help_enable(GTK_DIALOG(applet->dialog), STORAGE_HELP_KEY, osso);
  /*gtk_widget_set_size_request(applet->dialog, 400, 350);*/


    /* Notebook =====================*/
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(applet->dialog)->vbox),
      applet->notebook = g_object_new(GTK_TYPE_NOTEBOOK, "visible", TRUE, NULL));

      /* Page 1 vbox ==================*/
      gtk_container_add_with_properties(GTK_CONTAINER(applet->notebook),
        vbox = g_object_new(GTK_TYPE_TABLE, "visible", TRUE, "row-spacing", HILDON_MARGIN_DOUBLE, "homogeneous", TRUE, "border-width", HILDON_MARGIN_DEFAULT, NULL),
        "position", MEM_APPLET_STORAGE_PAGE, "tab-label", _("memo_ti_memorynote_storage"), NULL);
      gtk_notebook_set_tab_label_packing(GTK_NOTEBOOK(applet->notebook), vbox, TRUE, TRUE, GTK_PACK_START);

        /* Flash deviceinfo =============*/
        gtk_container_add_with_properties(GTK_CONTAINER(vbox),
          g_object_new(GTK_TYPE_ALIGNMENT, "visible", TRUE, "xalign", 0.0, "yalign", 0.0, "xscale", 1.0, "yscale", 0.0,
            "child", applet->flash_info = g_object_new(DEVICE_INFO_TYPE, "visible", TRUE, "osso-context", osso,
              "storage-device", g_object_new(STORAGE_DEVICE_TYPE, "key", STORAGE_DEVICE_FLASH, NULL), NULL), NULL),
          "left-attach", 0, "right-attach", 1, "top-attach", 0, "bottom-attach", 1, "x-options", GTK_EXPAND | GTK_FILL, "y-options", 0, NULL);
        /* Flash deviceinfo =============*/

        /* Internal mmc deviceinfo ======*/
        gtk_container_add_with_properties(GTK_CONTAINER(vbox),
          g_object_new(GTK_TYPE_ALIGNMENT, "visible", TRUE, "xalign", 0.0, "yalign", 0.5, "xscale", 1.0, "yscale", 0.0,
            "child", applet->internal_mmc_info = g_object_new(DEVICE_INFO_TYPE, "visible", TRUE, "osso-context", osso,
              "storage-device", applet->internal_mmc = g_object_new(STORAGE_DEVICE_TYPE, "key", STORAGE_DEVICE_EXTERNAL_MMC, NULL), NULL), NULL),
          "left-attach", 0, "right-attach", 1, "top-attach", 1, "bottom-attach", 2, "x-options", GTK_EXPAND | GTK_FILL, "y-options", 0, NULL);
        /* Internal mmc deviceinfo ======*/

        /* External mmc deviceinfo ======*/
        gtk_container_add_with_properties(GTK_CONTAINER(vbox),
          g_object_new(GTK_TYPE_ALIGNMENT, "visible", TRUE, "xalign", 0.0, "yalign", 1.0, "xscale", 1.0, "yscale", 0.0,
            "child", applet->external_mmc_info = g_object_new(DEVICE_INFO_TYPE, "visible", TRUE, "osso-context", osso,
              "storage-device", g_object_new(STORAGE_DEVICE_TYPE, "key", STORAGE_DEVICE_INTERNAL_MMC, NULL), NULL), NULL),
          "left-attach", 0, "right-attach", 1, "top-attach", 2, "bottom-attach", 3, "x-options", GTK_EXPAND | GTK_FILL, "y-options", 0, NULL);
        /* External mmc deviceinfo ======*/
      /* Page 1 vbox ==================*/

      if (getenv("OSSO_SWAP")) {
        /* Page 2 vbox ==================*/
        sg = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
        gtk_container_add_with_properties(GTK_CONTAINER(applet->notebook),
          vbox = g_object_new(GTK_TYPE_VBOX, "visible", TRUE, "spacing", HILDON_MARGIN_DEFAULT, NULL),
          "position", MEM_APPLET_VIRTUAL_PAGE, "tab-label", _("memo_ti_memorynote_virtual"), NULL);
        gtk_notebook_set_tab_label_packing(GTK_NOTEBOOK(applet->notebook), vbox, TRUE, TRUE, GTK_PACK_START);

          /* Message label ================*/
          gtk_container_add_with_properties(GTK_CONTAINER(vbox),
            g_object_new(GTK_TYPE_LABEL, "visible", TRUE, "xalign", 0.0, "yalign", 0.0, "wrap", TRUE, "justify", GTK_JUSTIFY_LEFT, "label", _("memo_ia_virtual_memory_card"), NULL),
            "expand", FALSE, NULL);
          /* Message label ================*/

          /* Swap settings alignment ======*/
          gtk_container_add_with_properties(GTK_CONTAINER(vbox),
            applet->swap_settings_alignment = g_object_new(GTK_TYPE_ALIGNMENT, "visible", TRUE, "xalign", 0.5, "yalign", 0.5, "xscale", 0.0, "yscale", 0.0, 
              "child", vbox1 = g_object_new(GTK_TYPE_VBOX, "visible", TRUE, NULL), NULL),
            "expand", TRUE, "fill", TRUE, NULL);

            /* Swap status label ============*/
            gtk_container_add_with_properties(GTK_CONTAINER(vbox1),
              applet->swap_settings_status_label = g_object_new(GTK_TYPE_LABEL, "visible", TRUE, NULL),
              "expand", FALSE, "fill", TRUE, NULL);
            /* Swap status label ============*/

            /* Swap settings vbox ===========*/
            gtk_container_add_with_properties(GTK_CONTAINER(vbox1),
              applet->swap_settings_vbox = g_object_new(GTK_TYPE_VBOX, "spacing", HILDON_MARGIN_DEFAULT, NULL),
              "expand", FALSE, "fill", TRUE, NULL);
            /* Note that this widget is made visible by swap_page_update. Either this is visible or the swap_settings_status_label is
               visible. If neither is visible, that's because swap_permitted() is FALSE */

              /* Available size label =========*/
              gtk_container_add_with_properties(GTK_CONTAINER(applet->swap_settings_vbox),
                g_object_new(HILDON_TYPE_CAPTION, "visible", TRUE, "size-group", sg, "label", _("memo_fi_virtual_available"),
                  "child", applet->available_label = g_object_new(GTK_TYPE_LABEL, "visible", TRUE, "xalign", 0.0, "yalign", 0.5, "justify", GTK_JUSTIFY_LEFT, "label", "128 MB", NULL),
                  NULL),
                "expand", FALSE, NULL);
              /* Available size label =========*/

              /* Extend check button ==========*/
              gtk_container_add_with_properties(GTK_CONTAINER(applet->swap_settings_vbox),
                g_object_new(HILDON_TYPE_CAPTION, "visible", TRUE, "size-group", sg, "label", _("memo_fi_virtual_memory_extend"),
                  "child", applet->extend_checkbox = g_object_new(GTK_TYPE_CHECK_BUTTON, "visible", TRUE, NULL),
                  NULL),
                "expand", FALSE, NULL);
              hildon_helper_set_insensitive_message(applet->extend_checkbox, _("memr_ib_not_enough_memory_on_card"));
              /* Extend check button ==========*/

              /* Sizes combo box ==============*/
              gtk_container_add_with_properties(GTK_CONTAINER(applet->swap_settings_vbox),
                caption = g_object_new(HILDON_TYPE_CAPTION, "visible", TRUE, "size-group", sg, "label", _("memo_fi_virtual_size"), "sensitive", FALSE, 
                  "child", applet->size_combo = g_object_new(GTK_TYPE_COMBO_BOX, "visible", TRUE, NULL),
                  NULL),
                "expand", FALSE, NULL);
              gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(applet->size_combo), cr = gtk_cell_renderer_text_new(), TRUE);
              gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(applet->size_combo), cr, "text", 0);
              /* Sizes combo box ==============*/
            /* Swap settings vbox ===========*/
          /* Swap settings alignment ======*/
        /* Page 2 vbox ==================*/
      }
    /* Notebook =====================*/
  /* Dialog =======================*/

  if (getenv("OSSO_SWAP"))
    g_signal_connect(G_OBJECT(applet->extend_checkbox), "notify::active", (GCallback)extend_notify_active, caption);
  g_signal_connect(G_OBJECT(applet->notebook), "switch-page", (GCallback)applet_notebook_switch_page, applet);

  g_signal_connect(G_OBJECT(applet->internal_mmc), "notify::status", (GCallback)internal_mmc_changed, applet);
  g_signal_connect(G_OBJECT(applet->internal_mmc), "notify::free-size", (GCallback)internal_mmc_changed, applet);
  g_signal_connect(G_OBJECT(applet->internal_mmc), "notify::swap-enabled", (GCallback)internal_mmc_changed, applet);
  g_object_notify(G_OBJECT(applet->internal_mmc), "status");
}

static void
applet_notebook_switch_page(GtkWidget *notebook, GtkNotebookPage *page, guint page_num, MemoryApplet *applet)
{
  if (MEM_APPLET_STORAGE_PAGE == page_num)
    hildon_help_dialog_help_enable(GTK_DIALOG(applet->dialog), STORAGE_HELP_KEY, applet->osso);
  else
  if (MEM_APPLET_VIRTUAL_PAGE == page_num)
    hildon_help_dialog_help_enable(GTK_DIALOG(applet->dialog), VIRTUAL_HELP_KEY, applet->osso);
}

static void
internal_mmc_changed(StorageDevice *storage_device, GParamSpec *pspec, MemoryApplet *applet)
{
  StorageDeviceStatus status;

  if (NULL == storage_device) return;

  g_object_get(G_OBJECT(storage_device), "status", &status, NULL);

  swap_page_update(applet, status);
}

static void
extend_notify_active(GtkWidget *checkbox, GParamSpec *pspec, GtkWidget *caption)
{
  gboolean value;

  g_object_get(G_OBJECT(checkbox), "active", &value, NULL);
  g_object_set(G_OBJECT(caption), "sensitive", value, NULL);
}
