/**
 * @file mcetool.h
 * Headers for the mcetool
 * <p>
 * Copyright © 2005-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCETOOL_H_
#define _MCETOOL_H_

#include <glib.h>
#include <locale.h>

#ifdef ENABLE_NLS
#include <libintl.h>
/** _() to use when NLS is enabled */
#define _(__str)		gettext(__str)
#else
#undef bindtextdomain
/** Dummy bindtextdomain to use when NLS is disabled */
#define bindtextdomain(__domain, __directory)
#undef textdomain
/** Dummy textdomain to use when NLS is disabled */
#define textdomain(__domain)
/** Dummy _() to use when NLS is disabled */
#define _(__str)		__str
#endif /* ENABLE_NLS */

/** Path to the GConf entry for the devicelock autolock setting */
#define SYSTEMUI_GCONF_DEVICE_AUTOLOCK_ENABLED_PATH "/system/systemui/devlock/devicelock_autolock_enabled"

/** The mcetool DBus service */
#define MCETOOL_SERVICE			"com.nokia.mcetool"

/** The mcetool DBus Request interface */
#define MCETOOL_REQUEST_IF		"com.nokia.mcetool.request"
/** The mcetool DBus Signal interface */
#define MCETOOL_REQUEST_PATH		"/com/nokia/mcetool/request"

/** Name of DBus callback to provide to Powerkey Menu SystemUI */
#define MCETOOL_POWERKEY_CB_REQ		"powerkey_callback"
/** Name of DBus callback to provide to Device Lock SystemUI */
#define MCETOOL_DEVLOCK_CB_REQ		"devlock_callback"
/** Name of DBus callback to provide to Touchscreen/Keypad Lock SystemUI */
#define MCETOOL_TKLOCK_CB_REQ		"tklock_callback"
/** Name of DBus callback to provide to Modechange SystemUI */
#define MCETOOL_MODECHG_CB_REQ		"modechange_callback"
/** Name of DBus callback to provide to Alarm SystemUI */
#define MCETOOL_ALARM_CB_REQ		"alarm_callback"

// FIXME: Adapt to alarmd
/* at present these are not exported by the alarm daemon */
#ifndef ALARMDAEMON_DBUS_SERVICE
/** Temporary define for name of the alarm daemon DBus service */
#define ALARMDAEMON_DBUS_SERVICE	"com.nokia.osso_alarm"
#endif /* ALARMDEAEMON_DBUS_SERVICE */

#ifndef ALARMDAEMON_DBUS_PATH
/** Temporary define for name of the alarm daemon DBus path */
#define ALARMDAEMON_DBUS_PATH		"/com/nokia/osso_alarm"
#endif /* ALARMDAEMON_DBUS_PATH */

#ifndef ALARMDAEMON_DBUS_IFACE
/** Temporary define for name of the alarm daemon DBus interface */
#define ALARMDAEMON_DBUS_IFACE		"com.nokia.osso_alarm"
#endif /* ALARMDAEMON_DBUS_IFACE */

#ifndef SET_ALARM_REQ
/** Temporary define for the name of the DBus method call to set the alarm */
#define SET_ALARM_REQ			"set_alarm"
#endif /* SET_ALARM_REQ */

#ifndef REMOVE_ALARM_REQ
/** Temporary define for the name of the DBus method call to remove an alarm */
#define REMOVE_ALARM_REQ		"remove_alarm"
#endif /* REMOVE_ALARM_REQ */

#ifndef LAUNCH_ALARM_REQ
/** Temporary define for the name of the DBus method call to launch an alarm */
#define LAUNCH_ALARM_REQ		"launch_alarm"
#endif /* LAUNCH_ALARM_REQ */

#endif /* _MCETOOL_H_ */
