/**
 * @file tklock.h
 * Headers for the touchscreen/keypad lock component
 * of the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _KEYPADLOCK_H_
#define _KEYPADLOCK_H_

#include <glib.h>

#ifndef MCE_GCONF_LOCK_PATH
/** Path to the GConf settings for the touchscreen/keypad lock */
#define MCE_GCONF_LOCK_PATH		"/system/osso/dsm/locks"
#endif /* MCE_GCONF_LOCK_PATH */

/** Path to the SysFS interface for enabling/disabling the keypad */
#define MCE_KEYPAD_SYSFS_DISABLE_PATH			"/sys/devices/platform/omap2_mcspi.1/spi1.0/disable_kp"
#define MCE_KEYBOARD_SYSFS_DISABLE_PATH			"/sys/devices/platform/i2c_omap.2/i2c-0/0-0045/disable_kp"
/** Path to the SysFS interface for enabling/disabling the touchscreen */
#define MCE_TOUCHSCREEN_SYSFS_DISABLE_PATH		"/sys/devices/platform/omap2_mcspi.1/spi1.0/disable_ts"

/** Default fallback setting for the touchscreen/keypad autolock */
#define DEFAULT_TK_AUTOLOCK		FALSE		/* FALSE / TRUE */

/** Path to the touchscreen/keypad autolock GConf setting */
#define MCE_GCONF_TK_AUTOLOCK_ENABLED_PATH	MCE_GCONF_LOCK_PATH "/touchscreen_keypad_autolock_enabled"

/** Name of D-Bus callback to provide to Touchscreen/Keypad Lock SystemUI */
#define MCE_TKLOCK_CB_REQ		"tklock_callback"
/** Delay before the touchscreen/keypad is unlocked */
#define MCE_TKLOCK_UNLOCK_DELAY		500		/**< 0.5 seconds */

#ifndef MCE_CONF_TKLOCK_GROUP
/** Name of Touchscreen/Keypad lock configuration group */
#define MCE_CONF_TKLOCK_GROUP		"TKLock"
#endif /* MCE_CONF_TKLOCK_GROUP */

/** Name of configuration key for touchscreen/keypad immediate blanking */
#define MCE_CONF_BLANK_IMMEDIATELY	"BlankImmediately"

/** Name of configuration key for touchscreen/keypad immediate dimming */
#define MCE_CONF_DIM_IMMEDIATELY	"DimImmediately"

/** Name of configuration key for touchscreen/keypad dim timeout */
#define MCE_CONF_DIM_DELAY		"DimDelay"

/** Name of configuration key for touchscreen immediate disabling */
#define MCE_CONF_TS_OFF_IMMEDIATELY	"DisableTSImmediately"

/** Name of configuration key for keypad immediate disabling */
#define MCE_CONF_KP_OFF_IMMEDIATELY	"DisableKPImmediately"

/** Default fallback setting for tklock immediate blanking */
#define DEFAULT_BLANK_IMMEDIATELY	FALSE		/* FALSE / TRUE */

/** Default fallback setting for tklock immediate dimming */
#define DEFAULT_DIM_IMMEDIATELY		FALSE		/* FALSE / TRUE */

/** Default delay before the display dims */
#define DEFAULT_DIM_DELAY		3000		/**< 3 seconds */

/** Default fallback setting for touchscreen immediate disabling */
#define DEFAULT_TS_OFF_IMMEDIATELY	TRUE		/* FALSE / TRUE */

/** Default fallback setting for keypad immediate disabling */
#define DEFAULT_KP_OFF_IMMEDIATELY	FALSE		/* FALSE / TRUE */

/* when MCE is made modular, this will be handled differently
 */
gboolean mce_tklock_init(void);
void mce_tklock_exit(void);

#endif /* _KEYPADLOCK_H_ */
