/**
 * @file powerkey.h
 * Headers for the power key logic for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _POWERKEY_H_
#define _POWERKEY_H_

#include <glib.h>

/** Action to perform on [power] keypress */
typedef enum {
	DEFAULT_POWERKEY_DOUBLE_ACTION = 0,	/**< Default for double press */
	POWER_DISABLED = 0,			/**< No action */
	DEFAULT_POWERKEY_SHORT_ACTION = 1,	/**< Default for short press */
	POWER_MENU = 1,				/**< Show device menu */
	DEFAULT_POWERKEY_LONG_ACTION = 2,	/**< Default for long press */
	POWER_POWEROFF = 2,			/**< Shutdown */
	POWER_SOFT_POWEROFF = 3			/**< Soft poweroff */
} poweraction_t;

/** Name of D-Bus callback to provide to Powerkey Menu SystemUI */
#define MCE_POWERKEY_CB_REQ		"powerkey_callback"

/** Name of D-Bus callback to provide to Modechange SystemUI */
#define MCE_MODECHG_CB_REQ		"modechange_callback"

/** Name of Powerkey configuration group */
#define MCE_CONF_POWERKEY_GROUP		"PowerKey"

/** Name of configuration key for medium [power] press delay */
#define MCE_CONF_POWERKEY_MEDIUM_DELAY	"PowerKeyMediumDelay"

/** Name of configuration key for long [power] press delay */
#define MCE_CONF_POWERKEY_LONG_DELAY	"PowerKeyLongDelay"

/** Name of configuration key for double [power] press delay */
#define MCE_CONF_POWERKEY_DOUBLE_DELAY	"PowerKeyDoubleDelay"

/** Name of configuration key for short [power] press action */
#define MCE_CONF_POWERKEY_SHORT_ACTION	"PowerKeyShortAction"

/** Name of configuration key for long [power] press action */
#define MCE_CONF_POWERKEY_LONG_ACTION	"PowerKeyLongAction"

/** Name of configuration key for double [power] press action */
#define MCE_CONF_POWERKEY_DOUBLE_ACTION	"PowerKeyDoubleAction"

/** Long delay for the [power] button in milliseconds */
#define DEFAULT_POWER_LONG_DELAY	1500		/**< 1.5 seconds */

/** Medium delay for the [power] button in milliseconds */
#define DEFAULT_POWER_MEDIUM_DELAY	1000		/**< 1 second */

/** Double press timeout for the [power] button in milliseconds */
#define DEFAULT_POWER_DOUBLE_DELAY	1000		/**< 1 second */

/* When MCE is made modular, this will be handled differently */
gboolean mce_powerkey_init(void);
void mce_powerkey_exit(void);

#endif /* _POWERKEY_H_ */
