/**
 * @file homekey.h
 * Headers for the [home] key module for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _HOMEKEY_H_
#define _HOMEKEY_H_

#include <glib.h>

/** Action to perform on [home] keypress */
typedef enum {
	HOME_DISABLED = 0,			/**< No action */
	DEFAULT_HOMEKEY_SHORT_ACTION = 1,	/**< Default for short press */
	HOME_SHORTSIGNAL = 1,			/**< Send short press signal */
	DEFAULT_HOMEKEY_LONG_ACTION = 2,	/**< Default for long press */
	HOME_LONGSIGNAL = 2			/**< Send long press signal */
} homeaction_t;

/** Name of Homekey configuration group */
#define MCE_CONF_HOMEKEY_GROUP		"HomeKey"

/** Name of configuration key for long [home] press delay */
#define MCE_CONF_HOMEKEY_LONG_DELAY	"HomeKeyLongDelay"

/** Name of configuration key for short [home] press action */
#define MCE_CONF_HOMEKEY_SHORT_ACTION	"HomeKeyShortAction"

/** Name of configuration key for long [home] press action */
#define MCE_CONF_HOMEKEY_LONG_ACTION	"HomeKeyLongAction"

/** Long delay for the [home] button in milliseconds */
#define DEFAULT_HOME_LONG_DELAY		800		/**< 0.8 seconds */

#endif /* _HOMEKEY_H_ */
