/**
 * @file filter-brightness-als.h
 * Headers for the Ambient Light Sensor level adjusting filter module
 * for display backlight, key backlight, and LED brightness
 * <p>
 * Copyright © 2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 * @author Semi Malinen <semi.malinen@nokia.com>
 */
#ifndef _FILTER_BRIGHTNESS_ALS_H_
#define _FILTER_BRIGHTNESS_ALS_H_

/** Path to the ALS */
#define ALS_LUX_PATH			"/sys/devices/platform/i2c_omap.2/i2c-0/0-0029/lux"

#define ALS_DISPLAY_ON_POLL_FREQ	1500		/**< Milliseconds */
#define ALS_DISPLAY_DIM_POLL_FREQ	5000		/**< Milliseconds */
/* 0 to disable polling completely;
 * with hardware that supports power saving
 * in a better way, 60000 should be used
 */
#define ALS_DISPLAY_OFF_POLL_FREQ	0		/**< Milliseconds */
/**
 * Define this to re-initialise the median filter on display blank;
 * this will trigger a re-read on wakeup
 */
#define ALS_DISPLAY_OFF_FLUSH_FILTER

#define MEDIAN_FILTER_WINDOW_SIZE	5

/** Median filter */
typedef struct {
	gsize window_size;				/**< Window size */
	/** Current number of samples in the window */
	gsize samples;
	/** Index of the oldest sample in the window */
	gsize oldest;
	gint window[MEDIAN_FILTER_WINDOW_SIZE];		/**< Ring buffer */
	gint ordered_window[MEDIAN_FILTER_WINDOW_SIZE];	/**< Ordered buffer */
} median_filter_struct;

/** ALS profile */
typedef struct {
	/** Lower and upper bound for each brightness range */
	gint range[5][2];
	gint value[6];					/**< brightness in % */
} als_profile_struct;

als_profile_struct display_als_profiles[] = {
	{       /* Minimum */
		{
			{ 10000, 13000 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 5, 20, 0, 0, 0, 0 }
	}, {    /* Economy */
		{
			{ 2, 4 },
			{ 24, 45 },
			{ 260, 400 },
			{ 10000, 13000 },
			{ -1, -1 },
		}, { 5, 20, 40, 50, 70, 0 }
	}, {    /* Normal */
		{
			{ 2, 4 },
			{ 24, 45 },
			{ 260, 400 },
			{ 10000, 13000 },
			{ -1, -1 },
		}, { 10, 20, 50, 80, 100, 0 }
	}, {    /* Bright */
		{
			{ 2, 4 },
			{ 24, 45 },
			{ 260, 400 },
			{ 10000, 13000 },
			{ -1, -1 },
		}, { 30, 60, 80, 90, 100, 0 }
	}, {    /* Maximum */
		{
			{ 2, 4 },
			{ 8, 12 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 50, 80, 100, 0, 0, 0 }
	}
};

als_profile_struct led_als_profiles[] = {
	{	/* Minimum; unused */
		{ { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
		{ 0, 0, 0, 0, 0, 0 }
	}, {	/* Economy; unused */
		{ { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
		{ 0, 0, 0, 0, 0, 0 }
	}, {	/* Normal */
		{
			{ 3, 5 },
			{ 15, 27 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 0, 100, 0, 0, 0, 0 }
	}, {	/* Bright */
		{
			{ 3, 5 },
			{ 15, 27 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 0, 150, 0, 0, 0, 0 }
	}, {	/* Maximum */
		{
			{ 3, 5 },
			{ 15, 27 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 50, 150, 0, 0, 0, 0 }
	}
};

als_profile_struct kbd_als_profiles[] = {
	{	/* Minimum; unused */
		{ { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
		{ 0, 0, 0, 0, 0, 0 }
	}, {	/* Economy; unused */
		{ { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
		{ 0, 0, 0, 0, 0, 0 }
	}, {	/* Normal */
		{
			{ 3, 5 },
			{ 15, 27 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 40, 100, 0, 0, 0, 0 }
	}, {	/* Bright */
		{
			{ 3, 5 },
			{ 15, 27 },
			{ -1, -1 },
			{ -1, -1 },
			{ -1, -1 },
		}, { 80, 100, 0, 0, 0, 0 }
	}, {	/* Maximum; unused */
		{ { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
		{ 0, 0, 0, 0, 0, 0 }
	}
};

typedef enum {
	ALS_PROFILE_MINIMUM = 0,
	ALS_PROFILE_ECONOMY,
	ALS_PROFILE_NORMAL,
	ALS_PROFILE_BRIGHT,
	ALS_PROFILE_MAXIMUM
} als_profile_t;

#endif /* _FILTER_BRIGHTNESS_ALS_H_ */
