/**
 * @file modetransition.h
 * Headers for the mode transition component of the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MODETRANSITION_H_
#define _MODETRANSITION_H_

#include <glib.h>

/** Path to mode file */
#define MCE_MODE_FILENAME		"/var/lib/mce/mode"
/** Path to VOIP-status file */
#define MCE_DEVLOCK_FILENAME		"/var/run/mce/call"

#define SPLASH_DELAY			500		/**< 0.5 seconds */
#define ACTDEAD_DELAY			1500		/**< 1.5 seconds */
#define POWERUP_DELAY			3500		/**< 3.5 seconds */

/** Indicate enabled (sub)mode */
#define DISABLED_STRING			"yes"
/** Indicate disabled (sub)mode */
#define ENABLED_STRING			"no"

/* When MCE is made modular, this will be handled differently */
gboolean mce_mode_init(void);
void mce_mode_exit(void);

#endif /* _MODETRANSITION_H_ */
