/**
 * @file mce-modules.h
 * Headers for the module handling for MCE
 * <p>
 * Copyright © 2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_MODULES_H_
#define _MCE_MODULES_H_

#include <glib.h>

/** Name of Modules configuration group */
#define MCE_CONF_MODULES_GROUP		"Modules"

/** Name of configuration key for module path */
#define MCE_CONF_MODULES_PATH		"ModulePath"

/** Name of configuration key for modules to load */
#define MCE_CONF_MODULES_MODULES	"Modules"

/** Default value for module path */
#define DEFAULT_MCE_MODULE_PATH		"/usr/lib/mce/modules"

gboolean mce_modules_init(void);
void mce_modules_exit(void);

#endif /* _MCE_MODULES_H_ */
