/**
 * @file mce-log.h
 * Headers for the logging functions for Mode Control Entity
 * <p>
 * Copyright © 2006-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_LOG_H_
#define _MCE_LOG_H_

#include <syslog.h>	/* LOG_DAEMON, LOG_USER */

#define MCE_LOG_SYSLOG			1	/**< Log to syslog */
#define MCE_LOG_STDERR			0	/**< Log to stderr */

/** Severity of loglevels */
typedef enum {
	LL_NONE = 0,			/**< Critical error */
	LL_CRIT = 1,			/**< Critical error */
	LL_ERR = 2,			/**< Error */
	LL_WARN = 3,			/**< Warning */
	LL_DEFAULT = LL_WARN,		/**< Default log level */
	LL_INFO = 4,			/**< Informational message */
	LL_DEBUG = 5			/**< Useful when debugging */
} loglevel_t;

#ifdef OSSOLOG_COMPILE
void mce_log(const loglevel_t loglevel, const char *const fmt, ...);
void mce_log_set_verbosity(const int verbosity);
void mce_log_open(const char *const name, const int facility, const int type);
void mce_log_close(void);
#else
/** Dummy version of mce_log used when logging is disabled at compile time */
#define mce_log(_loglevel, _fmt, ...)			do {} while (0)
#define mce_log_set_verbosity(_verbosity)		do {} while (0)
#define mce_log_open(_name, _facility, _type)		do {} while (0)
#define mce_log_close()					do {} while (0)
#endif /* OSSOLOG_COMPILE */

#endif /* _MCE_LOG_H_ */
