/**
 * @file mce-io.h
 * Headers for the generic I/O functionality for the Mode Control Entity
 * <p>
 * Copyright © 2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_IO_H_
#define _MCE_IO_H_

#include <glib.h>

typedef void (*iomon_cb)(gpointer data, gsize bytes_read);

gboolean mce_read_string_from_file(const gchar *const file, gchar **string);
gboolean mce_read_number_string_from_file(const gchar *const file,
					  gulong *number);
gboolean mce_write_string_to_file(const gchar *const file,
				  const gchar *const string);
gboolean mce_write_number_string_to_file(const gchar *const file,
					 const gulong number);
gconstpointer mce_register_io_monitor_activity(const gint fd,
					       const gchar *const file,
					       gboolean error_policy,
					       iomon_cb callback);
gconstpointer mce_register_io_monitor_string(const gint fd,
					     const gchar *const file,
					     gboolean error_policy,
					     gboolean rewind_policy,
					     iomon_cb callback);
gconstpointer mce_register_io_monitor_chunk(const gint fd,
					    const gchar *const file,
					    gboolean error_policy,
					    gboolean rewind_policy,
					    iomon_cb callback,
					    gulong chunk_size);
void mce_unregister_io_monitor(gconstpointer io_monitor);

#endif /* _MCE_IO_H_ */
