/**
 * @file mce-gconf.h
 * Headers for the GConf handling code for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_GCONF_H_
#define _MCE_GCONF_H_

#include <glib.h>			/* gboolean, gpointer,
					 * gchar, guint, gint
					 */

#include <gconf/gconf-client.h>		/* GConfClientNotifyFunc */

gboolean mce_gconf_set_int(const gchar *const key, const gint value);
gboolean mce_gconf_get_bool(const gchar *const key, gboolean *value);
gboolean mce_gconf_get_int(const gchar *const key, gint *value);
gboolean mce_gconf_notifier_add(const gchar *path, const gchar *key,
				const GConfClientNotifyFunc callback,
				guint *cb_id);
void mce_gconf_notifier_remove(gpointer cb_id, gpointer user_data);

gboolean mce_gconf_init(void);
void mce_gconf_exit(void);

#endif /* _MCE_GCONF_H_ */
