/**
 * @file mce-dsme.h
 * Headers for the DSME<->MCE interface and logic
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_DSME_H_
#define _MCE_DSME_H_

#include <glib.h>

/** Default display brightness on a scale from 1-5 */
#define DEFAULT_DISP_BRIGHTNESS		3		/**< 60% */
/** Default blank timeout, in seconds */
#define DEFAULT_BLANK_TIMEOUT		60		/**< 60 seconds */
/** Default dim timeout, in seconds */
#define DEFAULT_DIM_TIMEOUT		30		/**< 30 seconds */
/** Default boot blank timeout, in seconds */
#define DEFAULT_BOOT_BLANK_TIMEOUT	120		/**< 120 seconds */
/** Default boot dim timeout, in seconds */
#define DEFAULT_BOOT_DIM_TIMEOUT	90		/**< 90 seconds */
/** Default setting for don't blank on charger connected */
#define DEFAULT_DISPLAY_ON_WITH_CHARGER	FALSE		/**< FALSE */

/** Default delay before low battery shutdown, in milliseconds */
#define LOWBAT_SHUTDOWN_DELAY		5000		/**< 5 seconds */

/** Default delay before the user can power up the device from acting dead */
#define TRANSITION_DELAY		1000		/**< 1 second */

/**
 * If there's less than this many seconds left
 * before the alarm is activated, set SNOOZE alarm state
 * when calling dsme_request_shutdown_state
 */
#define SNOOZE_TIMEOUT			120		/**< 2 minutes */

/* Display settings */

/** Path to the GConf settings for the display */
#ifndef MCE_GCONF_DISPLAY_PATH
#define MCE_GCONF_DISPLAY_PATH			"/system/osso/dsm/display"
#endif /* MCE_GCONF_DISPLAY_PATH */
/** Path to the display brightness GConf setting */
#define MCE_GCONF_DISPLAY_BRIGHTNESS_PATH	MCE_GCONF_DISPLAY_PATH "/display_brightness"
/** Path to the dim timeout GConf setting */
#define MCE_GCONF_DISPLAY_DIM_TIMEOUT_PATH	MCE_GCONF_DISPLAY_PATH "/display_dim_timeout"
/** Path to the blank timeout GConf setting */
#define MCE_GCONF_DISPLAY_BLANK_TIMEOUT_PATH	MCE_GCONF_DISPLAY_PATH "/display_blank_timeout"
/** Path to the don't blank on charger connected GConf setting */
#define MCE_GCONF_DISPLAY_ON_WITH_CHARGER_PATH	MCE_GCONF_DISPLAY_PATH "/display_on_with_charger"

/** Name of Powerkey configuration group */
#define MCE_CONF_SOFTPOWEROFF_GROUP	"SoftPowerOff"

/** Name of configuration key for connectivity policy with charger connected */
#define MCE_CONF_SOFTPOWEROFF_CONNECTIVITY_POLICY_CHARGER "ConnectivityPolicyCharger"

/** Name of configuration key for connectivity policy when running on battery */
#define MCE_CONF_SOFTPOWEROFF_CONNECTIVITY_POLICY_BATTERY "ConnectivityPolicyBattery"

/** Name of configuration key for connectivity policy when powering on */
#define MCE_CONF_SOFTPOWEROFF_CONNECTIVITY_POLICY_POWERON "ConnectivityPolicyPowerOn"

/** Soft poweroff connectivity policies */
enum {
	/** Policy not set */
	SOFTOFF_CONNECTIVITY_INVALID = -1,
	/** Retain connectivity */
	SOFTOFF_CONNECTIVITY_RETAIN = 0,
	/** Default setting when charger connected */
	DEFAULT_SOFTOFF_CONNECTIVITY_CHARGER = 0,
	/** Go to offline mode if no connections are open */
	SOFTOFF_CONNECTIVITY_SOFT_OFFLINE = 1,
	/** Go to offline mode */
	SOFTOFF_CONNECTIVITY_FORCE_OFFLINE = 2,
	/** Default setting when running on battery */
	DEFAULT_SOFTOFF_CONNECTIVITY_BATTERY = 2,
};

/** Soft poweron connectivity policies */
enum {
	/** Stay in offline mode */
	SOFTOFF_CONNECTIVITY_OFFLINE = 0,
	/** Default setting */
	DEFAULT_SOFTOFF_CONNECTIVITY_POWERON = 0,
	/** Restore previous mode */
	SOFTOFF_CONNECTIVITY_RESTORE = 1,
};

void setup_display_settings(void);
void set_device_autolock(const gint timeout, const gboolean enabled);
void request_powerup(void);
void request_reboot(void);
void request_soft_poweron(void);
void request_soft_poweroff(void);
void request_normal_shutdown(void);

/* When MCE is made modular, this will be handled differently */
gboolean mce_dsme_init(gboolean debug_mode);
void mce_dsme_exit(void);

#endif /* _MCE_DSME_H_ */
