/**
 * @file mce-dbus.h
 * Headers for the D-Bus handling code for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _MCE_DBUS_H_
#define _MCE_DBUS_H_

#include <glib.h>
#include <dbus/dbus.h>

#include <mce/dbus-names.h>

DBusMessage *dbus_new_signal(const gchar *const path,
			     const gchar *const interface,
			     const gchar *const name);
DBusMessage *dbus_new_method_call(const gchar *const service,
				  const gchar *const path,
				  const gchar *const interface,
				  const gchar *const name);
DBusMessage *dbus_new_method_reply(DBusMessage *const message);

gboolean dbus_send_message(DBusMessage *const msg);
gboolean dbus_send_message_with_reply_handler(DBusMessage *const msg,
					      DBusPendingCallNotifyFunction callback);
DBusMessage *dbus_send_message_with_reply_and_block(DBusMessage *const msg);

gboolean dbus_send(const gchar *const service, const gchar *const path,
		   const gchar *const interface, const gchar *const name,
		   DBusPendingCallNotifyFunction callback,
		   int first_arg_type, ...);

gboolean mce_dbus_handler_add(const gchar *const interface,
			      const gchar *const name,
			      const gchar *const rules,
			      const guint type,
			      gboolean (*callback)(DBusMessage *const msg));
void mce_dbus_handler_remove(gpointer handler, gpointer user_data);

gboolean mce_dbus_init(const gboolean systembus);
void mce_dbus_exit(void);

#endif /* _MCE_DBUS_H_ */
