/**
 * @file led.h
 * Headers for the led logic for the Mode Control Entity
 * <p>
 * Copyright © 2006-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _LED_H_
#define _LED_H_

#include <glib.h>

/** Name of LED configuration group */
#define MCE_CONF_LED_GROUP			"LED"

/** Name of configuration key for the list of LED patterns */
#define MCE_CONF_LED_PATTERNS			"LEDPatterns"

/** Name of LED single-colour pattern configuration group */
#define MCE_CONF_LED_PATTERN_MONO_GROUP		"LEDPatternSingleColour"

/** Name of LED NJoy-controlled RGB pattern configuration group */
#define MCE_CONF_LED_PATTERN_NJOY_GROUP		"LEDPatternNJoyRGB"

/** Path to the GConf settings for the display */
#define MCE_GCONF_LED_PATH			"/system/osso/dsm/leds"

/** Default value for LED settings */
#define DEFAULT_PATTERN_ENABLED			TRUE

/** Default NJoy LED brightness */
#define DEFAULT_NJOY_LED_BRIGHTNESS		2

/** Path to the mono LED /sys directory */
#define MCE_MONO_LED_SYS_PATH			"/sys/class/leds/keypad"
#define MCE_MONO_LED_BRIGHTNESS_PATH		MCE_MONO_LED_SYS_PATH "/brightness"
#define MCE_LED_ON_PERIOD_PATH			MCE_MONO_LED_SYS_PATH "/delay_on"
#define MCE_LED_OFF_PERIOD_PATH			MCE_MONO_LED_SYS_PATH "/delay_off"
#define MCE_LED_TRIGGER_PATH			MCE_MONO_LED_SYS_PATH "/trigger"

/** Trigger type */
#define MCE_LED_TRIGGER_TIMER			"timer"
#define MCE_LED_TRIGGER_NONE			"none"


/** Path to the NJoy LED /sys directory */
#define MCE_NJOY_LED_SYS_PATH			"/sys/devices/platform/i2c_omap.2/i2c-0/0-0032"
#define MCE_NJOY_LED_BRIGHTNESS_PATH		MCE_NJOY_LED_SYS_PATH "/led_current"
#define MCE_LED_MODE_PATH			MCE_NJOY_LED_SYS_PATH "/mode"
#define MCE_LED_LOAD_PATH			MCE_NJOY_LED_SYS_PATH "/load"
#define MCE_LED_COLOUR_PATH			MCE_NJOY_LED_SYS_PATH "/color"
#define MCE_LED_CHANNELS_PATH			MCE_NJOY_LED_SYS_PATH "/active_channels"

#define MCE_LED_DIRECT_MODE			"direct"
#define MCE_LED_LOAD_MODE			"load"
#define MCE_LED_RUN_MODE			"run"

/* Brightness levels used by the keypad LED */
#define BRIGHTNESS_LEVEL_0			"0"	/**< off */
#define BRIGHTNESS_LEVEL_1			"12"	/**< faintest */
#define BRIGHTNESS_LEVEL_2			"24"	/**< level 2 */
#define BRIGHTNESS_LEVEL_3			"36"	/**< level 3 */
#define BRIGHTNESS_LEVEL_4			"48"	/**< level 4 */
#define BRIGHTNESS_LEVEL_5			"60"	/**< level 5 */
#define BRIGHTNESS_LEVEL_6			"72"	/**< level 6 */
#define BRIGHTNESS_LEVEL_7			"84"	/**< level 7 */
#define BRIGHTNESS_LEVEL_8			"96"	/**< level 8 */
#define BRIGHTNESS_LEVEL_9			"108"	/**< level 9 */
#define BRIGHTNESS_LEVEL_10			"120"	/**< level 10 */
#define BRIGHTNESS_LEVEL_11			"132"	/**< level 11 */
#define BRIGHTNESS_LEVEL_12			"144"	/**< level 12 */
#define BRIGHTNESS_LEVEL_13			"156"	/**< level 13 */
#define BRIGHTNESS_LEVEL_14			"168"	/**< level 14 */
#define BRIGHTNESS_LEVEL_15			"180"	/**< brightest */

/* When MCE is made modular, this will be handled differently */
gboolean mce_led_init(void);
void mce_led_exit(void);

#endif /* _LED_H_ */
