/**
 * @file keypad.h
 * Headers for the keypad logic for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _KEYPAD_H_
#define _KEYPAD_H_

#include <glib.h>

/** Path to keypad backlight /sys directory */
#define MCE_KEYPAD_BACKLIGHT_SYS_PATH			"/sys/class/leds/cover"
/** Path to keypad backlight /sys entry */
#define MCE_KEYPAD_BACKLIGHT_BRIGHTNESS_SYS_PATH	MCE_KEYPAD_BACKLIGHT_SYS_PATH "/brightness"
/** Path to keypad backlight fade-time /sys entry */
#define MCE_KEYPAD_BACKLIGHT_FADETIME_SYS_PATH		MCE_KEYPAD_BACKLIGHT_SYS_PATH "/time"
/** Path to keyboard backlight /sys directory */
#define MCE_KEYBOARD_BACKLIGHT_SYS_PATH			"/sys/class/leds/keyboard"
/** Path to the SysFS interface for the keyboard backlight */
#define MCE_KEYBOARD_BACKLIGHT_BRIGHTNESS_SYS_PATH	MCE_KEYBOARD_BACKLIGHT_SYS_PATH "/brightness"
/** Path to the SysFS interface for the keyboard backlight fade-time */
#define MCE_KEYBOARD_BACKLIGHT_FADETIME_SYS_PATH	MCE_KEYBOARD_BACKLIGHT_SYS_PATH "/time"

/** Default key backlight brightness */
#define DEFAULT_KEY_BACKLIGHT_LEVEL			255

/** Default key backlight timeout in seconds */
#define DEFAULT_KEY_BACKLIGHT_TIMEOUT			10

/** Default key backlight fadeout time in milliseconds */
#define DEFAULT_KEY_BACKLIGHT_FADETIME			100

/* When MCE is made modular, this will be handled differently */
gboolean mce_keypad_init(void);
void mce_keypad_exit(void);

#endif /* _KEYPAD_H_ */
