/**
 * @file event-touchscreen.h
 * Headers for the touchscreen event provider for the Mode Control Entity
 * <p>
 * Copyright © 2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _EVENT_TOUCHSCREEN_H_
#define _EVENT_TOUCHSCREEN_H_

#include <glib.h>

/** Input layer name of the N810 touchscreen */
#define OMAP_TOUCHSCREEN_N810	"TSC2301 touchscreen"

/** Input layer name of the N800 touchscreen */
#define OMAP_TOUCHSCREEN_N800	"TSC2301 touchscreen"

/** Input layer name of the 770 touchscreen */
#define OMAP_TOUCHSCREEN_770	"TSC2301 touchscreen"

/* XXX: Add support for X-series tablet touchscreen as well */

/* When MCE is made modular, this will be handled differently */
gboolean mce_touchscreen_init(void);
void mce_touchscreen_exit(void);

#endif /* _EVENT_TOUCHSCREEN_H_ */
